/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.pmmo_saved_data;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PmmoSavedData
extends SavedData {
    public static final Logger LOGGER = LogManager.getLogger();
    private static PmmoSavedData pmmoSavedData;
    private static MinecraftServer server;
    private static String NAME;
    private Map<UUID, Map<String, Double>> xp = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> scheduledXp = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> abilities = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> preferences = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Map<String, Double>>> xpBoosts = new HashMap<UUID, Map<String, Map<String, Double>>>();
    private Set<Party> parties = new HashSet<Party>();
    private Map<UUID, String> name = new HashMap<UUID, String>();

    public PmmoSavedData load(CompoundTag inData) {
        if (inData.m_128441_("players")) {
            CompoundTag playersTag = inData.m_128469_("players");
            for (String playerUuidKey : playersTag.m_128431_()) {
                CompoundTag playerTag = playersTag.m_128469_(playerUuidKey);
                if (playerTag.m_128441_("xp")) {
                    CompoundTag xpTag = playerTag.m_128469_("xp");
                    for (String tag : new HashSet(xpTag.m_128431_())) {
                        if (!(xpTag.m_128459_(tag) <= 0.0)) continue;
                        xpTag.m_128473_(tag.toLowerCase());
                    }
                }
                if (playerTag.m_128441_("name")) {
                    this.name.put(UUID.fromString(playerUuidKey), playerTag.m_128461_("name"));
                }
                this.xp = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xp"));
                this.scheduledXp = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "scheduledXp"));
                this.abilities = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "abilities"));
                this.preferences = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "preferences"));
                this.xpBoosts = NBTHelper.nbtToMapStringMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xpBoosts"));
            }
        }
        if (inData.m_128441_("parties")) {
            CompoundTag partiesTag = inData.m_128469_("parties");
            for (String key : partiesTag.m_128431_()) {
                CompoundTag partyTag = partiesTag.m_128469_(key);
                CompoundTag membersTag = partyTag.m_128469_("members");
                HashSet<PartyMemberInfo> membersInfo = new HashSet<PartyMemberInfo>();
                for (String id : membersTag.m_128431_()) {
                    CompoundTag memberInfoTag = membersTag.m_128469_(id);
                    PartyMemberInfo memberInfo = new PartyMemberInfo(UUID.fromString(memberInfoTag.m_128461_("uuid")), memberInfoTag.m_128454_("joinDate"), memberInfoTag.m_128459_("xpGained"));
                    membersInfo.add(memberInfo);
                }
                this.parties.add(new Party(partyTag.m_128454_("creationDate"), membersInfo));
            }
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag outData) {
        CompoundTag playersTag = new CompoundTag();
        CompoundTag partiesTag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Double>> entry : this.xp.entrySet()) {
            HashMap<String, CompoundTag> playerMap = new HashMap<String, CompoundTag>();
            playerMap.put("xp", NBTHelper.mapStringToNbt(this.xp.getOrDefault(entry.getKey(), Collections.emptyMap())));
            playerMap.put("scheduledXp", NBTHelper.mapStringToNbt(this.scheduledXp.getOrDefault(entry.getKey(), Collections.emptyMap())));
            playerMap.put("abilities", NBTHelper.mapStringToNbt(this.abilities.getOrDefault(entry.getKey(), Collections.emptyMap())));
            playerMap.put("preferences", NBTHelper.mapStringToNbt(this.preferences.getOrDefault(entry.getKey(), Collections.emptyMap())));
            playerMap.put("xpBoosts", NBTHelper.mapStringMapStringToNbt(this.xpBoosts.getOrDefault(entry.getKey(), Collections.emptyMap())));
            CompoundTag playerTag = NBTHelper.mapStringNbtToNbt(playerMap);
            playerTag.m_128359_("name", this.name.get(entry.getKey()));
            playersTag.m_128365_(entry.getKey().toString(), (Tag)playerTag);
        }
        outData.m_128365_("players", (Tag)playersTag);
        int i = 0;
        for (Party party : this.parties) {
            CompoundTag partyTag = new CompoundTag();
            CompoundTag membersTag = new CompoundTag();
            int j = 0;
            for (PartyMemberInfo memberInfo : party.getAllMembersInfo()) {
                CompoundTag memberInfoTag = new CompoundTag();
                memberInfoTag.m_128359_("uuid", memberInfo.uuid.toString());
                memberInfoTag.m_128356_("joinDate", memberInfo.joinDate);
                memberInfoTag.m_128347_("xpGained", memberInfo.xpGained);
                membersTag.m_128365_("" + j++, (Tag)memberInfoTag);
            }
            partyTag.m_128356_("creationDate", party.getCreationDate());
            partyTag.m_128365_("members", (Tag)membersTag);
            partiesTag.m_128365_("" + i, (Tag)partyTag);
            ++i;
        }
        outData.m_128365_("parties", (Tag)partiesTag);
        return outData;
    }

    public Map<String, Double> getXpMap(UUID uuid) {
        if (!this.xp.containsKey(uuid)) {
            this.xp.put(uuid, new HashMap());
        }
        return this.xp.get(uuid);
    }

    public Map<String, Double> getScheduledXpMap(UUID uuid) {
        if (!this.scheduledXp.containsKey(uuid)) {
            this.scheduledXp.put(uuid, new HashMap());
        }
        return this.scheduledXp.get(uuid);
    }

    public Map<String, Double> getAbilitiesMap(UUID uuid) {
        if (!this.abilities.containsKey(uuid)) {
            this.abilities.put(uuid, new HashMap());
        }
        return this.abilities.get(uuid);
    }

    public Map<String, Double> getPreferencesMap(UUID uuid) {
        if (!this.preferences.containsKey(uuid)) {
            this.preferences.put(uuid, new HashMap());
        }
        return this.preferences.get(uuid);
    }

    public double getXp(String skill, UUID uuid) {
        return ((Map)this.xp.getOrDefault(uuid, new HashMap())).getOrDefault(skill, 0.0);
    }

    public int getLevel(String skill, UUID uuid) {
        if (skill.equals("totalLevel")) {
            return XP.getTotalLevelFromMap(Config.getXpMap(uuid));
        }
        return XP.levelAtXp(this.getXp(skill, uuid));
    }

    public double getLevelDecimal(String skill, UUID uuid) {
        if (skill.equals("totalLevel")) {
            return this.getLevel(skill, uuid);
        }
        return XP.levelAtXpDecimal(this.getXp(skill, uuid));
    }

    public boolean setXp(String skill, UUID uuid, double amount) {
        double maxXp = Config.getConfig("maxXp");
        if (amount > maxXp) {
            amount = maxXp;
        }
        if (amount < 0.0) {
            amount = 0.0;
        }
        if (!this.xp.containsKey(uuid)) {
            this.xp.put(uuid, new HashMap());
        }
        if (amount > 0.0) {
            this.xp.get(uuid).put(skill, amount);
        } else {
            this.xp.get(uuid).remove(skill);
        }
        this.m_77760_(true);
        return true;
    }

    public boolean addXp(String skill, UUID uuid, double amount) {
        this.setXp(skill, uuid, this.getXp(skill, uuid) + amount);
        this.m_77760_(true);
        return true;
    }

    public void scheduleXp(String skill, UUID uuid, double amount, String sourceName) {
        Map<String, Double> scheduledXpMap = this.getScheduledXpMap(uuid);
        if (!scheduledXpMap.containsKey(skill)) {
            scheduledXpMap.put(skill, amount);
        } else {
            scheduledXpMap.put(skill, amount + scheduledXpMap.get(skill));
        }
        LOGGER.debug("Scheduled " + amount + "xp for: " + sourceName + ", to: " + this.getName(uuid));
        this.m_77760_(true);
    }

    public void removeScheduledXpUuid(UUID uuid) {
        this.scheduledXp.remove(uuid);
    }

    public void setName(String name, UUID uuid) {
        this.name.put(uuid, name);
    }

    public String getName(UUID uuid) {
        return this.name.getOrDefault(uuid, "Nameless Warning");
    }

    public Party getParty(UUID uuid) {
        Party party = null;
        for (Party thisParty : this.parties) {
            if (thisParty.getMemberInfo(uuid) == null) continue;
            party = thisParty;
        }
        return party;
    }

    public boolean makeParty(UUID uuid) {
        if (this.getParty(uuid) == null) {
            Party party = new Party(System.currentTimeMillis(), new HashSet<PartyMemberInfo>());
            party.addMember(uuid);
            this.parties.add(party);
            return true;
        }
        return false;
    }

    public int addToParty(UUID ownerUuid, UUID newMemberUuid) {
        Party ownerParty = this.getParty(ownerUuid);
        Party newMemberParty = this.getParty(newMemberUuid);
        if (ownerParty == null) {
            return -1;
        }
        if (newMemberParty != null) {
            return -2;
        }
        if (ownerParty.getMembersCount() + 1 > Party.getMaxPartyMembers()) {
            return -4;
        }
        ownerParty.addMember(newMemberUuid);
        this.m_77762_();
        return 0;
    }

    public int removeFromParty(UUID uuid) {
        Party party = this.getParty(uuid);
        if (party == null) {
            return -1;
        }
        party.removeMember(uuid);
        if (party.getPartySize() == 0) {
            this.parties.remove(party);
            this.m_77762_();
            return 1;
        }
        return 0;
    }

    public static void init(MinecraftServer server) {
        PmmoSavedData.server = server;
        pmmoSavedData = (PmmoSavedData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(nbt -> new PmmoSavedData().load((CompoundTag)nbt), PmmoSavedData::new, NAME);
    }

    public static PmmoSavedData get() {
        return pmmoSavedData;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public Map<String, Map<String, Double>> getPlayerXpBoostsMap(UUID playerUUID) {
        return this.xpBoosts.getOrDefault(playerUUID, new HashMap());
    }

    public Map<String, Double> getPlayerXpBoostMap(UUID playerUUID, String xpBoostKey) {
        return this.getPlayerXpBoostsMap(playerUUID).getOrDefault(xpBoostKey, new HashMap());
    }

    public double getPlayerXpBoost(UUID playerUUID, String skill) {
        double xpBoost = 0.0;
        for (Map.Entry<String, Map<String, Double>> entry : this.getPlayerXpBoostsMap(playerUUID).entrySet()) {
            xpBoost += entry.getValue().getOrDefault(skill, 0.0).doubleValue();
        }
        return xpBoost;
    }

    public void setPlayerXpBoostsMaps(UUID playerUUID, Map<String, Map<String, Double>> newBoosts) {
        HashMap<String, Map<String, Double>> sanitizedBoosts = new HashMap<String, Map<String, Double>>();
        for (Map.Entry<String, Map<String, Double>> boostMapEntry : newBoosts.entrySet()) {
            sanitizedBoosts.put(boostMapEntry.getKey(), NBTHelper.stringMapToLowerCase(boostMapEntry.getValue()));
        }
        this.xpBoosts.put(playerUUID, sanitizedBoosts);
        this.m_77760_(true);
    }

    public void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, Map<String, Double> newXpBoosts) {
        for (Map.Entry<String, Double> entry : newXpBoosts.entrySet()) {
            this.setPlayerXpBoost(playerUUID, xpBoostKey, entry.getKey(), entry.getValue());
        }
        XP.syncPlayerXpBoost(playerUUID);
        this.m_77760_(true);
    }

    private void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, String skill, Double xpBoost) {
        if (!this.xpBoosts.containsKey(playerUUID)) {
            this.xpBoosts.put(playerUUID, new HashMap());
        }
        if (!this.xpBoosts.get(playerUUID).containsKey(xpBoostKey)) {
            this.xpBoosts.get(playerUUID).put(xpBoostKey, new HashMap());
        }
        this.xpBoosts.get(playerUUID).get(xpBoostKey).put(skill.toLowerCase(), xpBoost);
        this.m_77760_(true);
    }

    public void removePlayerXpBoost(UUID playerUUID, String xpBoostKey) {
        this.getPlayerXpBoostsMap(playerUUID).remove(xpBoostKey);
        XP.syncPlayerXpBoost(playerUUID);
        this.m_77760_(true);
    }

    public void removeAllPlayerXpBoosts(UUID playerUUID) {
        this.xpBoosts.remove(playerUUID);
        XP.syncPlayerXpBoost(playerUUID);
        this.m_77760_(true);
    }

    public Map<UUID, Map<String, Double>> getAllXpMaps() {
        return this.xp;
    }

    static {
        NAME = "pmmo";
    }
}

