/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.biome.Biome;

public class AttributeHandler {
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");

    public static void updateHP(Mob mob, float bonus) {
        AttributeInstance hpAttribute = mob.m_21051_(Attributes.f_22276_);
        if (hpAttribute != null) {
            boolean wasMaxHealth = mob.m_21223_() == mob.m_21233_();
            double maxMobHPBoost = Config.getConfig("maxMobHPBoost");
            double mobHPBoostPerPowerLevel = Config.getConfig("mobHPBoostPerPowerLevel");
            if (!(mob instanceof Animal)) {
                bonus = (float)((double)bonus * mobHPBoostPerPowerLevel);
            }
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "hpBonus"))) > maxMobHPBoost) {
                bonus = (float)maxMobHPBoost;
            }
            AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            hpAttribute.m_22120_(hpModifierID);
            hpAttribute.m_22125_(hpModifier);
            if (wasMaxHealth) {
                mob.m_21153_(mob.m_21233_());
            }
        }
    }

    public static void updateDamage(Mob mob, float bonus) {
        AttributeInstance damageAttribute = mob.m_21051_(Attributes.f_22281_);
        if (damageAttribute != null) {
            double maxMobDamageBoost = Config.getConfig("maxMobDamageBoost");
            double mobDamageBoostPerPowerLevel = Config.getConfig("mobDamageBoostPerPowerLevel");
            bonus = (float)((double)bonus * mobDamageBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "damageBonus"))) > maxMobDamageBoost) {
                bonus = (float)maxMobDamageBoost;
            }
            AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            damageAttribute.m_22120_(damageModifierID);
            damageAttribute.m_22125_(damageModifier);
        }
    }

    public static void updateSpeed(Mob mob, float bonus) {
        AttributeInstance speedAttribute = mob.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null && !(mob instanceof Animal)) {
            double maxMobSpeedBoost = Config.getConfig("maxMobSpeedBoost");
            double mobSpeedBoostPerPowerLevel = Config.getConfig("mobSpeedBoostPerPowerLevel");
            bonus = (float)((double)bonus * mobSpeedBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "speedBonus"))) > maxMobSpeedBoost) {
                bonus = (float)maxMobSpeedBoost;
            }
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Movement Speed Boost thanks to Nearby Player Power Level", (double)(bonus / 100.0f), AttributeModifier.Operation.ADDITION);
            speedAttribute.m_22120_(speedModifierID);
            speedAttribute.m_22125_(speedModifier);
        }
    }

    private static double getBiomeMobMultiplier(Mob mob, String type) {
        Biome biome = mob.f_19853_.m_46857_(new BlockPos(mob.m_20182_()));
        ResourceLocation biomeResLoc = biome.getRegistryName();
        double multiplier = 1.0;
        if (biomeResLoc != null) {
            String biomeKey = biome.getRegistryName().toString();
            Map<String, Double> theMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(biomeKey);
            if (theMap != null && theMap.containsKey(type)) {
                multiplier = theMap.get(type);
            }
        }
        return multiplier;
    }
}

