/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTHelper {
    public static <T> Map<T, Double> maxDoubleMaps(Map<T, Double> mapA, Map<T, Double> mapB) {
        for (Map.Entry<T, Double> entry : mapB.entrySet()) {
            mapA.put(entry.getKey(), Math.max(entry.getValue(), mapA.getOrDefault(entry.getKey(), entry.getValue())));
        }
        return mapA;
    }

    public static <T> Map<String, T> stringMapToLowerCase(Map<String, T> inMap) {
        HashMap<String, T> outMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : inMap.entrySet()) {
            outMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return outMap;
    }

    public static <T> Map<String, T> mapStringKeyToString(Map<String, T> inMap) {
        HashMap<String, T> outMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : inMap.entrySet()) {
            outMap.put(entry.getKey(), entry.getValue());
        }
        return outMap;
    }

    public static Map<String, Double> nbtToMapString(CompoundTag nbt) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : nbt.m_128431_()) {
            if (Double.isNaN(nbt.m_128459_(key))) continue;
            map.put(key, nbt.m_128459_(key));
        }
        return map;
    }

    public static CompoundTag mapStringToNbt(Map<String, Double> map) {
        if (map == null) {
            return new CompoundTag();
        }
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            nbt.m_128347_(entry.getKey(), entry.getValue().doubleValue());
        }
        return nbt;
    }

    public static CompoundTag mapStringMapStringToNbt(Map<String, Map<String, Double>> map) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
            nbt.m_128365_(entry.getKey(), (Tag)NBTHelper.mapStringToNbt(entry.getValue()));
        }
        return nbt;
    }

    public static CompoundTag mapUuidStringToNbt(Map<UUID, Map<String, Double>> inMap) {
        CompoundTag outData = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Double>> entry : inMap.entrySet()) {
            outData.m_128365_(entry.getKey().toString(), (Tag)NBTHelper.mapStringToNbt(entry.getValue()));
        }
        return outData;
    }

    public static Map<UUID, Map<String, Double>> nbtToMapUuidString(CompoundTag inData) {
        HashMap<UUID, Map<String, Double>> outMap = new HashMap<UUID, Map<String, Double>>();
        for (String uuidKey : inData.m_128431_()) {
            outMap.put(UUID.fromString(uuidKey), NBTHelper.nbtToMapString(inData.m_128469_(uuidKey)));
        }
        return outMap;
    }

    public static Map<String, Map<String, Double>> nbtToMapStringString(CompoundTag inData) {
        HashMap<String, Map<String, Double>> outMap = new HashMap<String, Map<String, Double>>();
        for (String key : inData.m_128431_()) {
            outMap.put(key, NBTHelper.nbtToMapString(inData.m_128469_(key)));
        }
        return outMap;
    }

    public static Map<UUID, Map<String, Map<String, Double>>> nbtToMapStringMapUuidString(CompoundTag inData) {
        HashMap<UUID, Map<String, Map<String, Double>>> outMap = new HashMap<UUID, Map<String, Map<String, Double>>>();
        for (String playerUUIDKey : inData.m_128431_()) {
            UUID playerUUID = UUID.fromString(playerUUIDKey);
            outMap.put(playerUUID, new HashMap());
            for (String xpBoostKey : inData.m_128469_(playerUUIDKey).m_128431_()) {
                ((Map)outMap.get(playerUUID)).put(xpBoostKey, NBTHelper.nbtToMapString(inData.m_128469_(playerUUIDKey).m_128469_(xpBoostKey)));
            }
        }
        return outMap;
    }

    public static CompoundTag mapStringNbtToNbt(Map<String, CompoundTag> inMap) {
        CompoundTag outNbt = new CompoundTag();
        for (Map.Entry<String, CompoundTag> entry : inMap.entrySet()) {
            outNbt.m_128365_(entry.getKey(), (Tag)entry.getValue());
        }
        return outNbt;
    }

    public static CompoundTag extractNbtPlayersIndividualTagsFromPlayersTag(CompoundTag playersTag, String element) {
        CompoundTag outData = new CompoundTag();
        for (String uuidKey : playersTag.m_128431_()) {
            CompoundTag playerTag = playersTag.m_128469_(uuidKey);
            if (!playerTag.m_128441_(element)) continue;
            outData.m_128365_(uuidKey, (Tag)playerTag.m_128469_(element));
        }
        return outData;
    }

    public static Map<UUID, Map<String, Double>> nbtToXpMaps(CompoundTag input) {
        HashMap<UUID, Map<String, Double>> output = new HashMap<UUID, Map<String, Double>>();
        for (String key1 : input.m_128431_()) {
            UUID uuid = UUID.fromString(key1);
            output.put(uuid, new HashMap());
            for (String key2 : input.m_128469_(key1).m_128431_()) {
                ((Map)output.get(uuid)).put(key2, input.m_128469_(key1).m_128459_(key2));
            }
        }
        return output;
    }

    public static CompoundTag xpMapsToNbt(Map<UUID, Map<String, Double>> input) {
        CompoundTag output = new CompoundTag();
        for (UUID key1 : input.keySet()) {
            output.m_128365_(key1.toString(), (Tag)new CompoundTag());
            output.m_128469_(key1.toString()).m_128359_("name", PmmoSavedData.get().getName(key1));
            for (String skill : input.get(key1).keySet()) {
                Double value = input.get(key1).get(skill);
                output.m_128469_(key1.toString()).m_128347_(skill, value.doubleValue());
            }
        }
        return output;
    }

    public static Map<JType, Map<String, Map<String, Double>>> nbtToData3(CompoundTag input) {
        HashMap<JType, Map<String, Map<String, Double>>> output = new HashMap<JType, Map<String, Map<String, Double>>>();
        for (String jTypeKey : input.m_128431_()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.m_128469_(jTypeKey).m_128431_()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String botKey : input.m_128469_(jTypeKey).m_128469_(topKey).m_128431_()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(botKey, input.m_128469_(jTypeKey).m_128469_(topKey).m_128459_(botKey));
                }
            }
        }
        return output;
    }

    public static CompoundTag data3ToNbt(Map<JType, Map<String, Map<String, Double>>> input) {
        CompoundTag output = new CompoundTag();
        for (JType jType : input.keySet()) {
            output.m_128365_(jType.toString(), (Tag)new CompoundTag());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.m_128469_(jType.toString()).m_128365_(topKey, (Tag)new CompoundTag());
                for (String botKey : input.get((Object)jType).get(topKey).keySet()) {
                    Double value = input.get((Object)jType).get(topKey).get(botKey);
                    output.m_128469_(jType.toString()).m_128469_(topKey).m_128347_(botKey, value.doubleValue());
                }
            }
        }
        return output;
    }

    public static void addData3(Map<JType, Map<String, Map<String, Double>>> input1, Map<JType, Map<String, Map<String, Double>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Double>>> entry3 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry3.getKey())) {
                input1.put(entry3.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                if (!input1.get((Object)entry3.getKey()).containsKey(entry2.getKey())) {
                    input1.get((Object)entry3.getKey()).put(entry2.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry1 : entry2.getValue().entrySet()) {
                    if (input1.get((Object)entry3.getKey()).get(entry2.getKey()).containsKey(entry1.getKey())) continue;
                    input1.get((Object)entry3.getKey()).get(entry2.getKey()).put(entry1.getKey(), entry1.getValue());
                }
            }
        }
    }

    public static Map<JType, Map<String, Map<String, Map<String, Double>>>> nbtToData4(CompoundTag input) {
        HashMap<JType, Map<String, Map<String, Map<String, Double>>>> output = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        for (String jTypeKey : input.m_128431_()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.m_128469_(jTypeKey).m_128431_()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String midKey : input.m_128469_(jTypeKey).m_128469_(topKey).m_128431_()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(midKey, new HashMap());
                    for (String botKey : input.m_128469_(jTypeKey).m_128469_(topKey).m_128469_(midKey).m_128431_()) {
                        ((Map)((Map)((Map)output.get((Object)jType)).get(topKey)).get(midKey)).put(botKey, input.m_128469_(jTypeKey).m_128469_(topKey).m_128469_(midKey).m_128459_(botKey));
                    }
                }
            }
        }
        return output;
    }

    public static CompoundTag data4ToNbt(Map<JType, Map<String, Map<String, Map<String, Double>>>> input) {
        CompoundTag output = new CompoundTag();
        for (JType jType : input.keySet()) {
            output.m_128365_(jType.toString(), (Tag)new CompoundTag());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.m_128469_(jType.toString()).m_128365_(topKey, (Tag)new CompoundTag());
                for (String midKey : input.get((Object)jType).get(topKey).keySet()) {
                    output.m_128469_(jType.toString()).m_128469_(topKey).m_128365_(midKey, (Tag)new CompoundTag());
                    for (String botKey : input.get((Object)jType).get(topKey).get(midKey).keySet()) {
                        Double value = input.get((Object)jType).get(topKey).get(midKey).get(botKey);
                        output.m_128469_(jType.toString()).m_128469_(topKey).m_128469_(midKey).m_128347_(botKey, value.doubleValue());
                    }
                }
            }
        }
        return output;
    }

    public static void addData4(Map<JType, Map<String, Map<String, Map<String, Double>>>> input1, Map<JType, Map<String, Map<String, Map<String, Double>>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Map<String, Double>>>> entry4 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry4.getKey())) {
                input1.put(entry4.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Map<String, Double>>> entry3 : entry4.getValue().entrySet()) {
                if (!input1.get((Object)entry4.getKey()).containsKey(entry3.getKey())) {
                    input1.get((Object)entry4.getKey()).put(entry3.getKey(), new HashMap());
                }
                for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                    if (input1.get((Object)entry4.getKey()).get(entry3.getKey()).containsKey(entry2.getKey())) continue;
                    input1.get((Object)entry4.getKey()).get(entry3.getKey()).put(entry2.getKey(), entry2.getValue());
                }
            }
        }
    }

    public static float getOrDefaultFromNBT(CompoundTag nbt, String key, float defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128457_(key) : defaultValue;
    }

    public static double getOrDefaultFromNBT(CompoundTag nbt, String key, double defaultValue) {
        try {
            return nbt.m_128441_(key) ? nbt.m_128459_(key) : defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static long getOrDefaultFromNBT(CompoundTag nbt, String key, long defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128454_(key) : defaultValue;
    }

    public static int getOrDefaultFromNBT(CompoundTag nbt, String key, int defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128451_(key) : defaultValue;
    }

    public static String getOrDefaultFromNBT(CompoundTag nbt, String key, String defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128461_(key) : defaultValue;
    }

    public static boolean getOrDefaultFromNBT(CompoundTag nbt, String key, boolean defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128471_(key) : defaultValue;
    }

    public static byte getOrDefaultFromNBT(CompoundTag nbt, String key, byte defaultValue) {
        return nbt.m_128441_(key) ? nbt.m_128445_(key) : defaultValue;
    }
}

