/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib;

import fuzs.puzzleslib.capability.CapabilityController;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.ElementRegistry;
import fuzs.puzzleslib.network.NetworkHandler;
import fuzs.puzzleslib.proxy.IProxy;
import fuzs.puzzleslib.recipe.ElementConfigCondition;
import fuzs.puzzleslib.registry.RegistryManager;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="puzzleslib")
public class PuzzlesLib {
    public static final String MODID = "puzzleslib";
    public static final String NAME = "Puzzles Lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"Puzzles Lib");
    private static IProxy<?> sidedProxy;
    private static RegistryManager registryManager;
    private static NetworkHandler networkHandler;
    private static CapabilityController capabilityController;
    private static boolean isConditionLoaded;

    public PuzzlesLib() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onServerSetup);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PuzzlesLib.getRegistryManager());
    }

    private void onCommonSetup(FMLCommonSetupEvent evt) {
        evt.enqueueWork(() -> ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.COMMON));
    }

    private void onClientSetup(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.CLIENT));
    }

    private void onServerSetup(FMLDedicatedServerSetupEvent evt) {
        evt.enqueueWork(() -> ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.SERVER));
    }

    public static void setSideSideOnly() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
    }

    public static void loadConfigCondition() {
        if (!isConditionLoaded) {
            isConditionLoaded = true;
            CraftingHelper.register((IConditionSerializer)new ElementConfigCondition.Serializer());
        }
    }

    public static IProxy<?> getProxy() {
        return PuzzlesUtil.getOrElse(sidedProxy, IProxy::getProxy, instance -> {
            sidedProxy = instance;
        });
    }

    public static RegistryManager getRegistryManager() {
        return PuzzlesUtil.getOrElse(registryManager, RegistryManager::new, instance -> {
            registryManager = instance;
        });
    }

    public static NetworkHandler getNetworkHandler() {
        return PuzzlesUtil.getOrElse(networkHandler, NetworkHandler::new, instance -> {
            networkHandler = instance;
        });
    }

    public static CapabilityController getCapabilityController() {
        return PuzzlesUtil.getOrElse(capabilityController, CapabilityController::new, instance -> {
            capabilityController = instance;
        });
    }

    public static <T extends AbstractElement> AbstractElement register(String modId, String key, Supplier<T> supplier) {
        return ElementRegistry.register(new ResourceLocation(modId, key), supplier);
    }

    public static <T extends AbstractElement> AbstractElement register(String modId, String key, Supplier<T> supplier, Dist dist) {
        return ElementRegistry.register(new ResourceLocation(modId, key), supplier, dist);
    }

    public static void setup(boolean config, String ... path) {
        ElementRegistry.setup(config, path);
    }
}

