/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.option.ConfigOption;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.ElementRegistry;
import fuzs.puzzleslib.element.side.ISidedElement;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigManager {
    private static void onModConfig(ModConfig.ModConfigEvent evt, Collection<AbstractElement> generalElement, Collection<AbstractElement> allElements) {
        ModConfig.Type type = evt.getConfig().getType();
        ConfigManager.syncOptions(allElements, type, evt instanceof ModConfig.Reloading);
        ConfigManager.getAllOptions(generalElement, type).forEach(ConfigOption::sync);
    }

    public static void load(AbstractElement generalElement, Collection<AbstractElement> allElements, Function<ModConfig.Type, String> fileName) {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            if (type == ModConfig.Type.CLIENT && FMLEnvironment.dist.isDedicatedServer() || type == ModConfig.Type.SERVER && FMLEnvironment.dist.isClient()) continue;
            OptionsBuilder optionsBuilder = new OptionsBuilder(type);
            ConfigManager.create(optionsBuilder, generalElement, builder -> allElements.stream().filter(ISidedElement.getGeneralFilter(type)).forEach(element -> element.setupGeneralConfig((OptionsBuilder)builder)), new String[0]);
            for (AbstractElement element : allElements) {
                ISidedElement.setupConfig(optionsBuilder, type, element);
            }
            optionsBuilder.build().ifPresent(spec -> ModLoadingContext.get().registerConfig(type, spec, (String)fileName.apply(type)));
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(evt -> ConfigManager.onModConfig(evt, (Collection<AbstractElement>)ImmutableSet.of((Object)generalElement), allElements));
    }

    public static void create(OptionsBuilder builder, AbstractElement element, Consumer<OptionsBuilder> setupConfig, String ... comment) {
        if (comment.length != 0) {
            builder.comment(comment);
        }
        builder.push(element);
        setupConfig.accept(builder);
        builder.pop(element);
    }

    public static void syncOptions(Collection<AbstractElement> elements, ModConfig.Type type) {
        ConfigManager.syncOptions(elements, type, false);
    }

    private static void syncOptions(Collection<AbstractElement> allElements, ModConfig.Type type, boolean printLog) {
        Collection<ConfigOption<?>> options = ConfigManager.getAllOptions(allElements, type);
        if (!options.isEmpty()) {
            options.forEach(ConfigOption::sync);
        }
        if (printLog) {
            PuzzlesLib.LOGGER.info("Reloaded " + type.extension() + " config options for " + (options.isEmpty() ? "no elements" : ElementRegistry.joinElementNames(allElements)));
        }
    }

    public static Collection<ConfigOption<?>> getAllOptions(Collection<AbstractElement> elements, ModConfig.Type type) {
        return elements.stream().flatMap(element -> element.getOptions().stream()).filter(option -> option.isType(type)).collect(Collectors.toSet());
    }

    public static String getFileName(String modId, ModConfig.Type type) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getFileName(String modId, ModConfig.Type type, String ... path) {
        String fileName = ConfigManager.getFileName(modId, type);
        if (path.length != 0) {
            String prefix = String.join((CharSequence)File.separator, path);
            JsonConfigFileUtil.mkdirs(prefix);
            return prefix + File.separator + fileName;
        }
        return fileName;
    }

    @SafeVarargs
    public static <T extends IForgeRegistryEntry<T>> List<String> getKeyList(T ... entries) {
        return Stream.of(entries).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> deserializeToSet(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntrySet(data);
    }

    public static <T extends IForgeRegistryEntry<T>> Map<T, double[]> deserializeToMap(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntryMap(data);
    }
}

