/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.option;

import fuzs.puzzleslib.config.option.BooleanOption;
import fuzs.puzzleslib.config.option.ConfigOption;
import fuzs.puzzleslib.config.option.DoubleOption;
import fuzs.puzzleslib.config.option.EnumOption;
import fuzs.puzzleslib.config.option.GenericOption;
import fuzs.puzzleslib.config.option.IntegerOption;
import fuzs.puzzleslib.config.option.LongOption;
import fuzs.puzzleslib.element.AbstractElement;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class OptionsBuilder {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ModConfig.Type type;
    private AbstractElement activeElement;
    private ConfigOption.ConfigOptionBuilder<?> activeOptionBuilder;
    private int useCounter;

    public OptionsBuilder(ModConfig.Type type) {
        this.type = type;
    }

    public OptionsBuilder comment(String ... comment) {
        this.builder.comment(comment);
        return this;
    }

    public OptionsBuilder push(AbstractElement element) {
        assert (this.activeElement == null) : "Unable to push element on builder: Element already set";
        this.activeElement = element;
        this.builder.push(element.getRegistryName().func_110623_a());
        return this;
    }

    public OptionsBuilder push(String path) {
        this.tryCreateLast();
        this.builder.push(path);
        return this;
    }

    public OptionsBuilder pop(AbstractElement element) {
        assert (element == this.activeElement) : "Unable to pop element from builder: No element set";
        this.pop();
        this.activeElement = null;
        return this;
    }

    public OptionsBuilder pop() {
        this.tryCreateLast();
        this.builder.pop();
        return this;
    }

    public Optional<ForgeConfigSpec> build() {
        return this.useCounter > 0 ? Optional.of(this.builder.build()) : Optional.empty();
    }

    public <T> GenericOption.GenericOptionBuilder<T> define(String optionName, T defaultValue) {
        return this.setBuilder(new GenericOption.GenericOptionBuilder<T>(optionName, defaultValue));
    }

    public BooleanOption.BooleanOptionBuilder define(String optionName, boolean defaultValue) {
        return this.setBuilder(new BooleanOption.BooleanOptionBuilder(optionName, defaultValue));
    }

    public IntegerOption.IntegerOptionBuilder define(String optionName, int defaultValue) {
        return this.setBuilder(new IntegerOption.IntegerOptionBuilder(optionName, defaultValue));
    }

    public LongOption.LongOptionBuilder define(String optionName, long defaultValue) {
        return this.setBuilder(new LongOption.LongOptionBuilder(optionName, defaultValue));
    }

    public DoubleOption.DoubleOptionBuilder define(String optionName, double defaultValue) {
        return this.setBuilder(new DoubleOption.DoubleOptionBuilder(optionName, defaultValue));
    }

    public <T extends Enum<T>> EnumOption.EnumOptionBuilder<T> define(String optionName, T defaultValue) {
        return this.setBuilder(new EnumOption.EnumOptionBuilder<T>(optionName, defaultValue));
    }

    private <T extends ConfigOption.ConfigOptionBuilder<?>> T setBuilder(T optionBuilder) {
        this.tryCreateLast();
        ++this.useCounter;
        this.activeOptionBuilder = optionBuilder;
        return optionBuilder;
    }

    private void tryCreateLast() {
        if (this.activeOptionBuilder != null) {
            this.createOption(this.activeOptionBuilder);
            this.activeOptionBuilder = null;
        }
    }

    private <T> void createOption(ConfigOption.ConfigOptionBuilder<T> builder) {
        if (builder.comment.length != 0) {
            this.builder.comment(builder.comment);
        }
        BiFunction<ForgeConfigSpec.ConfigValue<ForgeConfigSpec.ConfigValue<T>>, ModConfig.Type, ConfigOption<ForgeConfigSpec.ConfigValue<T>>> factory = builder.getFactory();
        ForgeConfigSpec.ConfigValue<T> configValue = builder.getConfigValue(this.builder);
        ConfigOption<T> option = factory.apply(configValue, this.type);
        this.activeElement.addOption(option);
    }
}

