/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.PuzzlesLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StringEntryReader<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> activeRegistry;

    protected StringEntryReader(IForgeRegistry<T> registry) {
        this.activeRegistry = registry;
    }

    protected final List<T> getEntriesFromRegistry(String source) {
        return StringEntryReader.getEntriesFromRegistry(source, this.activeRegistry);
    }

    public static <R extends IForgeRegistryEntry<R>> List<R> getEntriesFromRegistry(String source, IForgeRegistry<R> activeRegistry) {
        ArrayList foundEntries = Lists.newArrayList();
        if (source.contains("*")) {
            foundEntries.addAll(StringEntryReader.getWildcardEntries(source, activeRegistry));
        } else {
            Optional<ResourceLocation> location = Optional.ofNullable(ResourceLocation.func_208304_a((String)source));
            if (location.isPresent()) {
                Optional<R> entry = StringEntryReader.getEntryFromRegistry(location.get(), activeRegistry);
                entry.ifPresent(foundEntries::add);
            } else {
                StringEntryReader.log(source, "Entry not found");
            }
        }
        return foundEntries;
    }

    private static <R extends IForgeRegistryEntry<R>> Optional<R> getEntryFromRegistry(ResourceLocation location, IForgeRegistry<R> activeRegistry) {
        if (activeRegistry.containsKey(location)) {
            return Optional.ofNullable(activeRegistry.getValue(location));
        }
        StringEntryReader.log(location.toString(), "Entry not found");
        return Optional.empty();
    }

    private static <R extends IForgeRegistryEntry<R>> List<R> getWildcardEntries(String source, IForgeRegistry<R> activeRegistry) {
        String[] s = source.split(":");
        switch (s.length) {
            case 1: {
                return StringEntryReader.getListFromRegistry("minecraft", s[0], activeRegistry);
            }
            case 2: {
                return StringEntryReader.getListFromRegistry(s[0], s[1], activeRegistry);
            }
        }
        StringEntryReader.log(source, "Invalid resource location format");
        return Lists.newArrayList();
    }

    private static <R extends IForgeRegistryEntry<R>> List<R> getListFromRegistry(String namespace, String path, IForgeRegistry<R> activeRegistry) {
        String regexPath = path.replace("*", "[a-z0-9/._-]*");
        List entries = activeRegistry.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).getRegistryName().func_110624_b().equals(namespace)).filter(entry -> ((RegistryKey)entry.getKey()).getRegistryName().func_110623_a().matches(regexPath)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (entries.isEmpty()) {
            StringEntryReader.log(new ResourceLocation(namespace, path).toString(), "Entry not found");
        }
        return entries;
    }

    protected final boolean isNotPresent(Collection<T> collection, T entry) {
        if (collection.contains(entry)) {
            StringEntryReader.log(Objects.requireNonNull(entry.getRegistryName()).toString(), "Already present");
            return false;
        }
        return true;
    }

    protected static void log(String entry, String message) {
        PuzzlesLib.LOGGER.warn("Unable to parse entry \"{}\": {}", (Object)entry, (Object)message);
    }
}

