/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.element;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.option.ConfigOption;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.element.EventListener;
import fuzs.puzzleslib.element.IConfigurableElement;
import fuzs.puzzleslib.element.IRegistryElement;
import fuzs.puzzleslib.element.side.IClientElement;
import fuzs.puzzleslib.element.side.ICommonElement;
import fuzs.puzzleslib.element.side.IServerElement;
import fuzs.puzzleslib.element.side.ISidedElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractElement
extends EventListener
implements IConfigurableElement,
IRegistryElement<AbstractElement> {
    private ResourceLocation name;
    private int enabled = this.isEnabledByDefault() ? 1 : 0;
    private final List<EventListener.EventStorage<? extends Event>> eventListeners = Lists.newArrayList();
    private final Map<String, ConfigOption<?>> configOptions = Maps.newHashMap();
    private boolean isLoaded;

    @Override
    @Nonnull
    public final ResourceLocation getRegistryName() {
        if (this.name == null) {
            throw new UnsupportedOperationException("Cannot get name for element: Name not set");
        }
        return this.name;
    }

    @Override
    @Nonnull
    public final AbstractElement setRegistryName(@Nonnull ResourceLocation name) {
        if (this.name != null) {
            throw new UnsupportedOperationException("Cannot set name \"" + name + "\" for element: Name already set as \"" + this.name + "\"");
        }
        this.name = name;
        return this;
    }

    @Override
    public final String getDisplayName() {
        return Stream.of(this.getRegistryName().func_110623_a().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    protected String[] getIncompatibleMods() {
        return new String[0];
    }

    protected final boolean isIncompatibleModPresent() {
        return Stream.of(this.getIncompatibleMods()).anyMatch(modId -> ModList.get().isLoaded(modId));
    }

    @Override
    public final void setupGeneralConfig(OptionsBuilder builder) {
        if (!this.isPersistent()) {
            builder.define(this.getDisplayName(), this.isEnabledByDefault()).comment(this.getDescription()).sync(this::setEnabled);
        }
    }

    public final void setup() {
        ISidedElement.setup((ISidedElement)((Object)this));
    }

    public final void load(ParallelDispatchEvent evt) {
        this.isLoaded = true;
        if (this.isIncompatibleModPresent()) {
            this.enabled = -1;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (evt instanceof FMLCommonSetupEvent) {
            this.reloadEventListeners(true);
        }
        ISidedElement.loadSide((ISidedElement)((Object)this), evt);
    }

    private void reload(boolean enable) {
        if (enable) {
            this.reloadEventListeners(true);
            ISidedElement.runForSides((ISidedElement)((Object)this), ICommonElement::loadCommon, IClientElement::loadClient, IServerElement::loadServer);
        } else {
            this.reloadEventListeners(false);
            ISidedElement.runForSides((ISidedElement)((Object)this), ICommonElement::unloadCommon, IClientElement::unloadClient, IServerElement::unloadServer);
        }
    }

    private void reloadEventListeners(boolean enable) {
        if (enable) {
            this.getEventListeners().forEach(EventListener.EventStorage::register);
        } else {
            this.getEventListeners().forEach(EventListener.EventStorage::unregister);
        }
    }

    protected boolean isPersistent() {
        return false;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled == 1;
    }

    private void setEnabled(boolean enabled) {
        this.setEnabled(enabled ? 1 : 0);
    }

    private void setEnabled(int enabled) {
        if (this.enabled != -1 && this.enabled != enabled) {
            this.enabled = enabled;
            if (this.isLoaded) {
                this.reload(enabled == 1);
            }
        }
    }

    protected final void disable() {
        this.setEnabled(-1);
        PuzzlesLib.LOGGER.warn("Detected issue in {} element: {}", (Object)this.getDisplayName(), (Object)"Disabling until game restart");
        if (this.isPersistent()) {
            PuzzlesLib.LOGGER.warn("{} is a persistent element", (Object)this.getDisplayName());
        }
    }

    @Override
    public final List<EventListener.EventStorage<? extends Event>> getEventListeners() {
        return this.eventListeners;
    }

    @Override
    public final void addOption(ConfigOption<?> option) {
        this.configOptions.put(String.join((CharSequence)".", option.getPath()), option);
    }

    @Override
    public final Optional<ConfigOption<?>> getOption(String ... path) {
        String singlePath = String.join((CharSequence)".", path);
        ConfigOption<?> option = this.configOptions.get(singlePath);
        if (option != null) {
            return Optional.of(option);
        }
        PuzzlesLib.LOGGER.error("Unable to get option at path {}: {}", (Object)singlePath, (Object)"Option not found");
        return Optional.empty();
    }

    @Override
    public final <T> Optional<T> getValue(String ... path) {
        return this.getOption(new String[0]).map(ConfigOption::get);
    }

    public Collection<ConfigOption<?>> getOptions() {
        return this.configOptions.values();
    }

    public static AbstractElement createEmpty(ResourceLocation name) {
        return new EmptyElement(name);
    }

    private static class EmptyElement
    extends AbstractElement
    implements ISidedElement {
        public EmptyElement(ResourceLocation name) {
            this.setRegistryName(name);
        }

        @Override
        public String[] getDescription() {
            return new String[0];
        }
    }
}

