/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.element.side;

import fuzs.puzzleslib.config.ConfigManager;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.side.IClientElement;
import fuzs.puzzleslib.element.side.ICommonElement;
import fuzs.puzzleslib.element.side.IServerElement;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public interface ISidedElement {
    public static void setup(ISidedElement element) {
        ISidedElement.runForSides(element, ICommonElement::setupCommon, IClientElement::setupClient, IServerElement::setupServer);
    }

    public static void loadSide(ISidedElement element, ParallelDispatchEvent evt) {
        if (element instanceof ICommonElement && evt instanceof FMLCommonSetupEvent) {
            ((ICommonElement)element).loadCommon();
        } else if (element instanceof IClientElement && evt instanceof FMLClientSetupEvent) {
            ((IClientElement)element).loadClient();
        } else if (element instanceof IServerElement && evt instanceof FMLDedicatedServerSetupEvent) {
            ((IServerElement)element).loadServer();
        }
    }

    public static void runForSides(ISidedElement element, Consumer<ICommonElement> common, Consumer<IClientElement> client, Consumer<IServerElement> server) {
        if (element instanceof ICommonElement) {
            common.accept((ICommonElement)element);
        }
        if (FMLEnvironment.dist.isClient() && element instanceof IClientElement) {
            client.accept((IClientElement)element);
        }
        if (FMLEnvironment.dist.isDedicatedServer() && element instanceof IServerElement) {
            server.accept((IServerElement)element);
        }
    }

    public static Predicate<Object> getGeneralFilter(ModConfig.Type type) {
        switch (type) {
            case COMMON: {
                return element -> element instanceof ICommonElement;
            }
            case CLIENT: {
                return element -> !(element instanceof ICommonElement) && element instanceof IClientElement;
            }
            case SERVER: {
                return element -> !(element instanceof ICommonElement) && element instanceof IServerElement;
            }
        }
        throw new IllegalStateException();
    }

    public static void setupConfig(OptionsBuilder optionsBuilder, ModConfig.Type type, AbstractElement element) {
        switch (type) {
            case COMMON: {
                if (!(element instanceof ICommonElement)) break;
                ConfigManager.create(optionsBuilder, element, ((ICommonElement)((Object)element))::setupCommonConfig, ((ICommonElement)((Object)element)).getCommonDescription());
                break;
            }
            case CLIENT: {
                if (!(element instanceof IClientElement)) break;
                ConfigManager.create(optionsBuilder, element, ((IClientElement)((Object)element))::setupClientConfig, ((IClientElement)((Object)element)).getClientDescription());
                break;
            }
            case SERVER: {
                if (!(element instanceof IServerElement)) break;
                ConfigManager.create(optionsBuilder, element, ((IServerElement)((Object)element))::setupServerConfig, ((IServerElement)((Object)element)).getServerDescription());
            }
        }
    }
}

