/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.recipe;

import com.google.gson.JsonObject;
import fuzs.puzzleslib.element.ElementRegistry;
import java.util.Optional;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ElementConfigCondition
implements ICondition {
    private final ResourceLocation element;
    private final String path;

    public ElementConfigCondition(ResourceLocation element, String path) {
        this.element = element;
        this.path = path;
    }

    public ResourceLocation getID() {
        return new ResourceLocation("puzzleslib", "element_config");
    }

    public boolean test() {
        Optional configValue = ElementRegistry.getConfigValue(this.element, this.path);
        return configValue.isPresent() && (Boolean)configValue.get() != false;
    }

    public static class Serializer
    implements IConditionSerializer<ElementConfigCondition> {
        public void write(JsonObject json, ElementConfigCondition value) {
            json.addProperty("element", value.element.toString());
            json.addProperty("path", value.path);
        }

        public ElementConfigCondition read(JsonObject json) {
            ResourceLocation element = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"element"));
            String path = JSONUtils.func_151200_h((JsonObject)json, (String)"path");
            return new ElementConfigCondition(element, path);
        }

        public ResourceLocation getID() {
            return new ResourceLocation("puzzleslib", "element_config");
        }
    }
}

