/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry;

import com.google.common.collect.ArrayListMultimap;
import fuzs.puzzleslib.util.NamespaceUtil;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryManager {
    private final ArrayListMultimap<Class<?>, IForgeRegistryEntry<?>> registryEntries = ArrayListMultimap.create();

    @SubscribeEvent
    public void onRegistryRegister(RegistryEvent.Register<?> evt) {
        this.addAllToRegistry(evt.getRegistry());
    }

    private <T extends IForgeRegistryEntry<T>> void addAllToRegistry(IForgeRegistry<T> registry) {
        Class type = registry.getRegistrySuperType();
        if (this.registryEntries.containsKey((Object)type)) {
            for (IForgeRegistryEntry entry : this.registryEntries.get((Object)type)) {
                registry.register(entry);
            }
            this.registryEntries.removeAll((Object)type);
        }
    }

    public void register(IForgeRegistryEntry<?> entry) {
        assert (entry.getRegistryName() != null);
        this.register(null, entry);
    }

    public void register(@Nullable String path, IForgeRegistryEntry<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        if (entry.getRegistryName() == null) {
            assert (path != null);
            entry.setRegistryName(new ResourceLocation(NamespaceUtil.getActiveNamespace(), path));
        }
        this.registryEntries.put((Object)entry.getRegistryType(), entry);
    }
}

