/*
 * Decompiled with CFR 0.152.
 */
package superlord.ravagecabbage;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superlord.ravagecabbage.entity.CabbagerEntity;
import superlord.ravagecabbage.entity.RCRavagerEntity;
import superlord.ravagecabbage.init.RCBlocks;
import superlord.ravagecabbage.init.RCConfiguredStructures;
import superlord.ravagecabbage.init.RCEntities;
import superlord.ravagecabbage.init.RCItems;
import superlord.ravagecabbage.init.RCStructures;
import superlord.ravagecabbage.network.RCNetwork;

@Mod(value="ravageandcabbage")
@Mod.EventBusSubscriber(modid="ravageandcabbage")
public class RavageAndCabbage {
    public static final String MOD_ID = "ravageandcabbage";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup GROUP = new ItemGroup("ravageandcabbage_item_group"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RCItems.CABBAGE.get());
        }
    };
    private static Method GETCODEC_METHOD;

    public RavageAndCabbage() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerCommon);
        bus.addListener(this::setup);
        bus.addListener(this::registerEntityAttributes);
        RCEntities.REGISTER.register(bus);
        RCItems.REGISTER.register(bus);
        RCBlocks.REGISTER.register(bus);
        RCStructures.REGISTER.register(bus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    private void registerCommon(FMLCommonSetupEvent event) {
        RCNetwork.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RCStructures.setupStructures();
            RCStructures.registerStructurePieces();
            RCConfiguredStructures.registerConfiguredStructures();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(structureMap);
                    tempMap.put(RCStructures.STABLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)RCStructures.STABLE.get()));
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(RCStructures.STABLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)RCStructures.STABLE.get()));
                }
            });
        });
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RCEntities.CABBAGER.get(), CabbagerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)RCEntities.RAVAGER.get(), RCRavagerEntity.func_234233_eS_().func_233813_a_());
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation(MOD_ID, registryKey));
        registry.register(entry);
        return entry;
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.PLAINS) {
            event.getGeneration().getStructures().add(() -> RCConfiguredStructures.CONFIGURED_STABLE);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"getCodec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(RCStructures.STABLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)RCStructures.STABLE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

