/*
 * Decompiled with CFR 0.152.
 */
package superlord.ravagecabbage.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.ravagecabbage.entity.RCRavagerEntity;

@OnlyIn(value=Dist.CLIENT)
public class RCRavagerModel<T extends Entity>
extends AgeableModel<RCRavagerEntity> {
    private final ModelRenderer head;
    private final ModelRenderer jaw;
    private final ModelRenderer body;
    private final ModelRenderer legBackRight;
    private final ModelRenderer legBackLeft;
    private final ModelRenderer legFrontRight;
    private final ModelRenderer legFrontLeft;
    private final ModelRenderer neck;

    public RCRavagerModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.neck = new ModelRenderer((Model)this);
        this.neck.func_78793_a(0.0f, -7.0f, -1.5f);
        this.neck.func_78784_a(68, 73).func_228301_a_(-5.0f, -1.0f, -18.0f, 10.0f, 10.0f, 18.0f, 0.0f);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 10.0f, -17.0f);
        this.head.func_78784_a(0, 0).func_228301_a_(-8.0f, -14.0f, -14.0f, 16.0f, 20.0f, 16.0f, 0.0f);
        this.head.func_78784_a(0, 0).func_228301_a_(-2.0f, 0.0f, -18.0f, 4.0f, 8.0f, 4.0f, 0.0f);
        ModelRenderer modelrenderer = new ModelRenderer((Model)this);
        modelrenderer.func_78793_a(-10.0f, -8.0f, -8.0f);
        modelrenderer.func_78784_a(74, 55).func_228301_a_(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f, 0.0f);
        modelrenderer.field_78795_f = 1.0995574f;
        this.head.func_78792_a(modelrenderer);
        ModelRenderer modelrenderer1 = new ModelRenderer((Model)this);
        modelrenderer1.field_78809_i = true;
        modelrenderer1.func_78793_a(8.0f, -8.0f, -8.0f);
        modelrenderer1.func_78784_a(74, 55).func_228301_a_(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f, 0.0f);
        modelrenderer1.field_78795_f = 1.0995574f;
        this.head.func_78792_a(modelrenderer1);
        this.jaw = new ModelRenderer((Model)this);
        this.jaw.func_78793_a(0.0f, 4.0f, 2.0f);
        this.jaw.func_78784_a(0, 36).func_228301_a_(-8.0f, 0.0f, -16.0f, 16.0f, 3.0f, 16.0f, 0.0f);
        this.head.func_78792_a(this.jaw);
        this.neck.func_78792_a(this.head);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78784_a(0, 55).func_228301_a_(-7.0f, -10.0f, -7.0f, 14.0f, 16.0f, 20.0f, 0.0f);
        this.body.func_78784_a(0, 91).func_228301_a_(-6.0f, 6.0f, -7.0f, 12.0f, 13.0f, 18.0f, 0.0f);
        this.body.func_78793_a(0.0f, 1.0f, 2.0f);
        this.legBackRight = new ModelRenderer((Model)this, 96, 0);
        this.legBackRight.func_228301_a_(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, 0.0f);
        this.legBackRight.func_78793_a(-8.0f, -13.0f, 18.0f);
        this.legBackLeft = new ModelRenderer((Model)this, 96, 0);
        this.legBackLeft.field_78809_i = true;
        this.legBackLeft.func_228301_a_(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, 0.0f);
        this.legBackLeft.func_78793_a(8.0f, -13.0f, 18.0f);
        this.legFrontRight = new ModelRenderer((Model)this, 64, 0);
        this.legFrontRight.func_228301_a_(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, 0.0f);
        this.legFrontRight.func_78793_a(-8.0f, -13.0f, -5.0f);
        this.legFrontLeft = new ModelRenderer((Model)this, 64, 0);
        this.legFrontLeft.field_78809_i = true;
        this.legFrontLeft.func_228301_a_(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, 0.0f);
        this.legFrontLeft.func_78793_a(8.0f, -13.0f, -5.0f);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return Collections.EMPTY_LIST;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return this.getParts();
    }

    public Iterable<ModelRenderer> getParts() {
        return ImmutableList.of((Object)this.neck, (Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft);
    }

    public void setRotationAngles(RCRavagerEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.body.field_78795_f = 1.5707964f;
        float f = 0.4f * limbSwingAmount;
        this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * f;
        this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * f;
        this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * f;
        this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * f;
        if (entityIn.func_184207_aI()) {
            this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing / 3.0f * 0.6662f)) * f;
            this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing / 3.0f + (float)Math.PI)) * f;
            this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing / 3.0f + (float)Math.PI)) * f;
            this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing / 3.0f * 0.6662f)) * f;
        }
    }

    public void setLivingAnimations(RCRavagerEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_((Entity)entityIn, limbSwing, limbSwingAmount, partialTick);
        int i = entityIn.func_213684_dX();
        int j = entityIn.func_213687_eg();
        int l = entityIn.func_213683_l();
        if (l > 0) {
            float f = MathHelper.func_233021_e_((float)((float)l - partialTick), (float)10.0f);
            float f1 = (1.0f + f) * 0.5f;
            float f2 = f1 * f1 * f1 * 12.0f;
            float f3 = f2 * MathHelper.func_76126_a((float)this.neck.field_78795_f);
            this.neck.field_78798_e = -6.5f + f2;
            this.neck.field_78797_d = -7.0f - f3;
            float f4 = MathHelper.func_76126_a((float)(((float)l - partialTick) / 10.0f * (float)Math.PI * 0.25f));
            this.jaw.field_78795_f = 1.5707964f * f4;
            this.jaw.field_78795_f = l > 5 ? MathHelper.func_76126_a((float)(((float)(-4 + l) - partialTick) / 4.0f)) * (float)Math.PI * 0.4f : 0.15707964f * MathHelper.func_76126_a((float)((float)Math.PI * ((float)l - partialTick) / 10.0f));
        } else {
            float f6 = -1.0f * MathHelper.func_76126_a((float)this.neck.field_78795_f);
            this.neck.field_78800_c = 0.0f;
            this.neck.field_78797_d = -7.0f - f6;
            this.neck.field_78798_e = 5.5f;
            boolean flag = i > 0;
            this.neck.field_78795_f = flag ? 0.21991149f : 0.0f;
            this.jaw.field_78795_f = (float)Math.PI * (flag ? 0.05f : 0.01f);
            if (flag) {
                double d0 = (double)i / 40.0;
                this.neck.field_78800_c = (float)Math.sin(d0 * 10.0) * 3.0f;
            } else if (j > 0) {
                float f7 = MathHelper.func_76126_a((float)(((float)(20 - j) - partialTick) / 20.0f * (float)Math.PI * 0.25f));
                this.jaw.field_78795_f = 1.5707964f * f7;
            }
        }
    }
}

