/*
 * Decompiled with CFR 0.152.
 */
package superlord.ravagecabbage.entity;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.ravagecabbage.init.RCEntities;
import superlord.ravagecabbage.init.RCItems;
import superlord.ravagecabbage.items.IRavagerHornArmorItem;

public class RCRavagerEntity
extends TameableEntity
implements IRideable,
IEquipable {
    private static final Predicate<Entity> field_213690_b = p_213685_0_ -> p_213685_0_.func_70089_S() && !(p_213685_0_ instanceof RCRavagerEntity);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(RCRavagerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(RCRavagerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int attackTick;
    private int stunTick;
    private int roarTick;
    private final BoostHelper field_234214_bx_;

    public RCRavagerEntity(EntityType<? extends RCRavagerEntity> p_i50250_1_, World p_i50250_2_) {
        super(p_i50250_1_, p_i50250_2_);
        this.field_234214_bx_ = new BoostHelper(this.field_70180_af, BOOST_TIME, SADDLED);
        this.field_70138_W = 1.0f;
        this.field_70699_by = new Navigator((MobEntity)this, this.field_70170_p);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class, RCRavagerEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, new UntamedAttackGoal<PlayerEntity>(this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(5, new UntamedAttackGoal<AbstractVillagerEntity>(this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(5, new UntamedAttackGoal<IronGolemEntity>(this, IronGolemEntity.class, true));
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    private void setSaddled(boolean isSaddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)isSaddled);
    }

    public boolean hasHornArmor() {
        ItemStack itemStackHeadSlot = this.func_184582_a(EquipmentSlotType.HEAD);
        return itemStackHeadSlot != null && !itemStackHeadSlot.func_190926_b() && itemStackHeadSlot.func_77973_b() instanceof IRavagerHornArmorItem;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.isSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
        if (this.hasHornArmor()) {
            ItemStack hornArmor = this.func_184582_a(EquipmentSlotType.HEAD);
            this.func_199701_a_(hornArmor);
        }
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Vector3d vector3d = RCRavagerEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.RIGHT ? 90.0f : -90.0f)));
        Vector3d vector3d1 = this.func_234236_a_(vector3d, livingEntity);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vector3d vector3d2 = RCRavagerEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.LEFT ? 90.0f : -90.0f)));
        Vector3d vector3d3 = this.func_234236_a_(vector3d2, livingEntity);
        return vector3d3 != null ? vector3d3 : this.func_213303_ch();
    }

    @Nullable
    private Vector3d func_234236_a_(Vector3d p_234236_1_, LivingEntity p_234236_2_) {
        double d0 = this.func_226277_ct_() + p_234236_1_.field_72450_a;
        double d1 = this.func_174813_aQ().field_72338_b;
        double d2 = this.func_226281_cx_() + p_234236_1_.field_72449_c;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (Pose pose : p_234236_2_.func_230297_ef_()) {
            blockpos$mutable.func_189532_c(d0, d1, d2);
            double d3 = this.func_174813_aQ().field_72337_e + 0.75;
            do {
                Vector3d vector3d;
                AxisAlignedBB axisalignedbb;
                double d4 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.func_177956_o() + d4 > d3) continue block0;
                if (TransportationHelper.func_234630_a_((double)d4) && TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_234236_2_, (AxisAlignedBB)(axisalignedbb = p_234236_2_.func_233648_f_(pose)).func_191194_a(vector3d = new Vector3d(d0, (double)blockpos$mutable.func_177956_o() + d4, d2)))) {
                    p_234236_2_.func_213301_b(pose);
                    return vector3d;
                }
                blockpos$mutable.func_189536_c(Direction.UP);
            } while ((double)blockpos$mutable.func_177956_o() < d3);
        }
        return null;
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.7f : 1.3f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AttackTick", this.attackTick);
        compound.func_74768_a("StunTick", this.stunTick);
        compound.func_74768_a("RoarTick", this.roarTick);
        compound.func_74757_a("IsSaddled", this.isSaddled());
        ItemStack itemStackHead = this.func_184582_a(EquipmentSlotType.HEAD);
        if (!itemStackHead.func_190926_b()) {
            CompoundNBT headCompoundNBT = new CompoundNBT();
            itemStackHead.func_77955_b(headCompoundNBT);
            compound.func_218657_a("HeadSlot", (INBT)headCompoundNBT);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        boolean hasHornArmor;
        super.func_70037_a(compound);
        this.attackTick = compound.func_74762_e("AttackTick");
        this.stunTick = compound.func_74762_e("StunTick");
        this.roarTick = compound.func_74762_e("RoarTick");
        this.setSaddled(compound.func_74767_n("IsSaddled"));
        CompoundNBT compoundNBT = compound.func_74775_l("HeadSlot");
        boolean bl = hasHornArmor = !compoundNBT.isEmpty();
        if (hasHornArmor) {
            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.func_199557_a((CompoundNBT)compoundNBT));
        }
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(160.0);
        this.func_70606_j(160.0f);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f = i == 0 ? 0.2f : -0.6f;
            Vector3d vec3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + vec3d.field_72449_c);
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public double func_70042_X() {
        return this.func_213302_cg() - 0.2f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == RCItems.CABBAGE.get();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219643_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219647_fg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219646_ff;
    }

    public float func_213307_e(Pose pose) {
        return this.func_70631_g_() ? this.func_213302_cg() : 2.0f;
    }

    public static AttributeModifierMap.MutableAttribute func_234233_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 0.75).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233824_g_, 1.5).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return super.func_70652_k(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            if (this.func_70610_aX()) {
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
            } else {
                double d0 = this.func_70638_az() != null ? 0.35 : 0.3;
                double d1 = this.func_110148_a(Attributes.field_233821_d_).func_111125_b();
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(MathHelper.func_219803_d((double)0.1, (double)d1, (double)d0));
            }
            if (!this.field_70170_p.field_72995_K && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
                for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (!(block instanceof LeavesBlock)) continue;
                    flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
                }
            }
            if (this.roarTick > 0) {
                --this.roarTick;
                if (this.roarTick == 10) {
                    this.roar();
                }
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (this.stunTick > 0) {
                --this.stunTick;
                this.func_213682_eh();
                if (this.stunTick == 0) {
                    this.func_184185_a(SoundEvents.field_219650_fj, 1.0f, 1.0f);
                    this.roarTick = 20;
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70685_l(Entity entityIn) {
        return this.stunTick <= 0 && this.roarTick <= 0 && super.func_70685_l(entityIn);
    }

    protected void func_213371_e(LivingEntity entityIn) {
        if (this.roarTick == 0) {
            if (this.field_70146_Z.nextDouble() < 0.5) {
                this.stunTick = 40;
                this.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)39);
                entityIn.func_70108_f((Entity)this);
            } else {
                this.launch((Entity)entityIn);
            }
            entityIn.field_70133_I = true;
        }
    }

    public void roar() {
        if (this.func_70089_S()) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(4.0), field_213690_b)) {
                if (!(entity instanceof AbstractIllagerEntity)) {
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 6.0f);
                }
                this.launch(entity);
            }
            Vector3d vec3d = this.func_174813_aQ().func_189972_c();
            for (int i = 0; i < 40; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.2;
                double d1 = this.field_70146_Z.nextGaussian() * 0.2;
                double d2 = this.field_70146_Z.nextGaussian() * 0.2;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, d0, d1, d2);
            }
        }
    }

    private void func_213682_eh() {
        if (this.field_70146_Z.nextInt(6) == 0) {
            double d0 = this.func_226277_ct_() - (double)this.func_213311_cf() * Math.sin(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            double d1 = this.func_226278_cu_() + (double)this.func_213302_cg() - 0.3;
            double d2 = this.func_226281_cx_() + (double)this.func_213311_cf() * Math.cos(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    private void launch(Entity p_213688_1_) {
        double d0 = p_213688_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_213688_1_.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.func_70024_g(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    public RCRavagerEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        RCRavagerEntity ravagerentity = (RCRavagerEntity)((EntityType)RCEntities.RAVAGER.get()).func_200721_a((World)p_241840_1_);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            ravagerentity.func_184754_b(uuid);
            ravagerentity.func_70903_f(true);
        }
        return ravagerentity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTick = 10;
            this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        } else if (id == 39) {
            this.stunTick = 40;
        }
        super.func_70103_a(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213683_l() {
        return this.attackTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213684_dX() {
        return this.stunTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213687_eg() {
        return this.roarTick;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.5f;
                }
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) / 2.0f);
                    super.func_213352_e(new Vector3d((double)f, travelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(travelVector);
            }
        }
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack itemStack) {
        Item item;
        super.func_184201_a(slotIn, itemStack);
        if (slotIn == EquipmentSlotType.HEAD && itemStack != null && !itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof IRavagerHornArmorItem) {
            IRavagerHornArmorItem hornArmor = (IRavagerHornArmorItem)item;
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a((double)hornArmor.getArmorValue());
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)RCItems.RAVAGER_SPAWN_EGG.get());
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == RCItems.RAVAGER_MILK.get() && !this.func_70909_n()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                ItemStack itemstack1 = DrinkHelper.func_242398_a((ItemStack)itemstack, (PlayerEntity)player, (ItemStack)Items.field_151133_ar.func_190903_i());
                player.func_184611_a(hand, itemstack1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(3.0f);
            return ActionResultType.SUCCESS;
        }
        if (!this.isSaddled() && this.func_70909_n() && !this.func_70631_g_() && item == Items.field_151141_av) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.setSaddled(true);
            this.field_70170_p.func_217384_a(player, (Entity)this, SoundEvents.field_187706_dO, SoundCategory.AMBIENT, 0.5f, 1.0f);
            return ActionResultType.CONSUME;
        }
        if (!this.hasHornArmor() && this.func_70909_n() && !this.func_70631_g_() && item instanceof IRavagerHornArmorItem) {
            this.func_184201_a(EquipmentSlotType.HEAD, itemstack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            IRavagerHornArmorItem hornArmorItem = (IRavagerHornArmorItem)item;
            this.field_70170_p.func_217384_a(player, (Entity)this, hornArmorItem.getArmorMaterial().func_200899_b(), SoundCategory.AMBIENT, 0.5f, 1.0f);
            return ActionResultType.CONSUME;
        }
        if (player.func_226563_dT_() && this.hasHornArmor() && this.func_70909_n() && !this.func_70631_g_() && itemstack.func_190926_b()) {
            ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemStack.func_190926_b()) {
                this.func_199701_a_(itemStack.func_77946_l());
                this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
            }
            return ActionResultType.CONSUME;
        }
        if (this.isSaddled() && item == Items.field_190931_a) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && item == Items.field_151133_ar && !this.func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            ItemStack itemstack1 = DrinkHelper.func_242398_a((ItemStack)itemstack, (PlayerEntity)player, (ItemStack)((Item)RCItems.RAVAGER_MILK.get()).func_190903_i());
            player.func_184611_a(hand, itemstack1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    public void func_230266_a_(SoundCategory p_230266_1_) {
    }

    public boolean func_110257_ck() {
        return this.isSaddled();
    }

    public boolean func_184762_da() {
        return this.field_234214_bx_.func_233617_a_(this.func_70681_au());
    }

    public void func_230267_a__(Vector3d travelVec) {
        super.func_213352_e(travelVec);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof RCRavagerEntity) {
                RCRavagerEntity ravager = (RCRavagerEntity)target;
                return !ravager.func_70909_n() || ravager.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    class UntamedAttackGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        RCRavagerEntity field_75299_d;

        public UntamedAttackGoal(RCRavagerEntity goalOwnerIn, Class<T> targetClassIn, boolean checkSight) {
            this(goalOwnerIn, targetClassIn, checkSight, false);
        }

        public UntamedAttackGoal(RCRavagerEntity goalOwnerIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
            this(goalOwnerIn, targetClassIn, 10, checkSight, nearbyOnlyIn, null);
        }

        public UntamedAttackGoal(RCRavagerEntity goalOwnerIn, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, @Nullable boolean nearbyOnlyIn, Predicate<LivingEntity> targetPredicate) {
            super((MobEntity)goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
            this.field_75299_d = goalOwnerIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75299_d.func_70631_g_() && !this.field_75299_d.func_70909_n();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        protected PathNodeType func_215744_a(IBlockReader p_215744_1_, boolean p_215744_2_, boolean p_215744_3_, BlockPos p_215744_4_, PathNodeType p_215744_5_) {
            return p_215744_5_ == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(p_215744_1_, p_215744_2_, p_215744_3_, p_215744_4_, p_215744_5_);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity p_i50754_1_, World p_i50754_2_) {
            super(p_i50754_1_, p_i50754_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)RCRavagerEntity.this, 1.0, true);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            float f = RCRavagerEntity.this.func_213311_cf() - 0.1f;
            return f * 2.0f * f * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

