/*
 * Decompiled with CFR 0.152.
 */
package superlord.ravagecabbage.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.ravagecabbage.world.structures.StableStructure;

@Mod.EventBusSubscriber(modid="ravageandcabbage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RCStructures {
    public static IStructurePieceType STABLE_PIECE_TYPE = StableStructure.Piece::new;
    public static final DeferredRegister<Structure<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"ravageandcabbage");
    public static final RegistryObject<Structure<NoFeatureConfig>> STABLE = REGISTER.register("stable", () -> new StableStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        RCStructures.setupMapSpacingAndLand((Structure)STABLE.get(), new StructureSeparationSettings(100, 50, 2538959), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }

    public static void registerStructurePieces() {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("ravageandcabbage", "stable"), (Object)STABLE_PIECE_TYPE);
    }
}

