/*
 * Decompiled with CFR 0.152.
 */
package superlord.ravagecabbage.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import superlord.ravagecabbage.entity.CabbagerEntity;
import superlord.ravagecabbage.entity.RCRavagerEntity;
import superlord.ravagecabbage.init.RCEntities;
import superlord.ravagecabbage.init.RCLootTables;
import superlord.ravagecabbage.init.RCStructures;

public class StableStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STABLE_ENEMIES = ImmutableList.of((Object)new MobSpawnInfo.Spawners((EntityType)RCEntities.CABBAGER.get(), 1, 1, 1));

    public StableStructure(Codec<NoFeatureConfig> p_i51440_1_) {
        super(p_i51440_1_);
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STABLE_ENEMIES;
    }

    public String func_143025_a() {
        return "ravageandcabbage:stable";
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        int i = p_230363_6_ >> 4;
        int j = p_230363_7_ >> 4;
        p_230363_5_.setSeed((long)(i ^ j << 4) ^ p_230363_3_);
        p_230363_5_.nextInt();
        for (int k = p_230363_6_ - 10; k <= p_230363_6_ + 10; ++k) {
            for (int l = p_230363_7_ - 10; l <= p_230363_7_ + 10; ++l) {
                ChunkPos chunkpos = Structure.field_236381_q_.func_236392_a_(p_230363_1_.func_235957_b_().func_236197_a_(Structure.field_236381_q_), p_230363_3_, p_230363_5_, k, l);
                if (k != chunkpos.field_77276_a || l != chunkpos.field_77275_b) continue;
                return false;
            }
        }
        return true;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(RCStructures.STABLE_PIECE_TYPE, 0);
            this.resourceLocation = resourceLocationIn;
            this.field_186178_c = pos;
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(RCStructures.STABLE_PIECE_TYPE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
            BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
            pieceList.add((StructurePiece)new Piece(templateManager, new ResourceLocation("ravageandcabbage", "stable"), blockpos, rotation));
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        public boolean func_230383_a_(ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos pos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            BlockPos blockpos = BlockPos.field_177992_a;
            this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(-blockpos.func_177958_n(), 0, -blockpos.func_177952_p())));
            return super.func_230383_a_(seedReader, structureManager, chunkGenerator, randomIn, structureBoundingBoxIn, chunkPos, pos);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            Object entity;
            if ("baby".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                entity = (RCRavagerEntity)((EntityType)RCEntities.RAVAGER.get()).func_200721_a((World)worldIn.func_201672_e());
                if (entity != null) {
                    entity.func_70873_a(-24000);
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if ("adult".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                entity = (RavagerEntity)EntityType.field_220352_aU.func_200721_a((World)worldIn.func_201672_e());
                if (entity != null) {
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if ("cabbager1".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                entity = (CabbagerEntity)((EntityType)RCEntities.CABBAGER.get()).func_200721_a((World)worldIn.func_201672_e());
                if (entity != null) {
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if ("cabbager2".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                entity = (CabbagerEntity)((EntityType)RCEntities.CABBAGER.get()).func_200721_a((World)worldIn.func_201672_e());
                if (entity != null) {
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if ("barrel".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof BarrelTileEntity) {
                    ((BarrelTileEntity)tileentity).func_189404_a(RCLootTables.STABLE_LOOT_TABLE, rand.nextLong());
                }
            }
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(LootTables.field_215813_K, rand.nextLong());
                }
            }
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = Math.max(generator.func_222531_c(x + 12, z + 12, Heightmap.Type.WORLD_SURFACE_WG) - 1, generator.func_205470_d() - 1);
            BlockPos blockpos = new BlockPos(x, surfaceY, z);
            Piece.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

