/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoveEntityEvent {
    private static int[] dx = new int[]{1, 0, -1, 0};
    private static int[] dz = new int[]{0, 1, 0, -1};
    private static int TICKS_PER_SECOND = 20;
    private static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    private static int lastTorchX = 0;
    private static int lastTorchY = 0;
    private static int lastTorchZ = 0;
    static final int WALL_CENTER = 0;
    static final int FENCE_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;

    @SubscribeEvent
    public void handleTrampleEvents(BlockEvent.FarmlandTrampleEvent event) {
        BlockPos pos = event.getEntity().m_142538_();
        MyConfig.debugMsg(1, pos, "Enter FarmlandTrampleEvent");
        if (event.isCancelable()) {
            Entity entity = event.getEntity();
            if (entity instanceof Villager) {
                Villager ve = (Villager)entity;
                if (ve.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
                    MyConfig.debugMsg(2, pos, "Villager Not A Farmer");
                    return;
                }
                if (ve.m_7141_().m_35576_() >= 3) {
                    event.setCanceled(true);
                    MyConfig.debugMsg(2, pos, "Farmer under level 3.");
                    return;
                }
            }
            if ((entity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)entity;
                if (!spe.m_7500_()) {
                    return;
                }
                MyConfig.debugMsg(2, pos, "FarmlandTrampleCancelled");
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleEntityMoveEvents(LivingEvent.LivingUpdateEvent event) {
        boolean debugvalue;
        double randomD100Roll;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if (!(entity.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)entity.f_19853_;
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        Block footBlock = sWorld.m_8055_(ePos).m_60734_();
        if (footBlock instanceof WoolCarpetBlock) {
            return;
        }
        if (footBlock == Blocks.f_50125_) {
            footBlock = Blocks.f_50016_;
        }
        Block groundBlock = sWorld.m_8055_(ePos.m_7495_()).m_60734_();
        if (entity.m_20096_() && footBlock == Blocks.f_50016_ && groundBlock == Blocks.f_50016_) {
            return;
        }
        Biome localBiome = sWorld.m_46857_(ePos);
        EntityType tempType = entity.m_6095_();
        ResourceLocation registryName = tempType.getRegistryName();
        String registryNameAsString = registryName.toString();
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
        if (MoveEntityEvent.isImpossibleRegrowthEvent(footBlock, regrowthActions)) {
            return;
        }
        double regrowthEventOdds = 1.0 / (currentRegrowthMobItem.getRegrowthEventSeconds() * (double)TICKS_PER_SECOND);
        if (this.isHorseTypeEatingNow(entity)) {
            regrowthEventOdds *= 20.0;
        }
        if ((randomD100Roll = entity.f_19853_.f_46441_.nextDouble()) <= regrowthEventOdds + (double)(debugvalue = false)) {
            if (entity instanceof Villager) {
                Villager ve = (Villager)entity;
                if (ve.m_20096_() && !(footBlock instanceof BedBlock)) {
                    this.doVillagerRegrowthEvents(ve, footBlock, groundBlock, registryNameAsString, regrowthActions, localBiome);
                }
            } else {
                this.doMobRegrowthEvents(entity, footBlock, groundBlock, registryNameAsString, regrowthActions, localBiome);
            }
        }
    }

    private static BlockPos getAdjustedBlockPos(Entity entity) {
        BlockPos ePos = new BlockPos(entity.m_20185_(), entity.m_20186_() + 0.99, entity.m_20189_());
        return ePos;
    }

    private void doMobRegrowthEvents(Entity entity, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        if (regrowthType.equals("stumble")) {
            if (footBlock instanceof TorchBlock || footBlock instanceof WallTorchBlock) {
                this.mobStumbleAction(entity, key);
            }
            return;
        }
        if (regrowthType.equals("reforest")) {
            this.mobReforestAction(entity, footBlock, groundBlock, key, localBiome);
            return;
        }
        if (regrowthType.equals("mushroom")) {
            this.mobGrowMushroomAction(entity, groundBlock, key);
            return;
        }
        if (!MoveEntityEvent.isKindOfGrassBlock(groundBlock)) {
            return;
        }
        if (regrowthType.equals("tall")) {
            this.mobGrowTallAction(entity, footBlock, key);
            return;
        }
        if (regrowthType.equals("both")) {
            regrowthType = entity.f_19853_.f_46441_.nextDouble() * 100.0 > 85.0 ? "grow" : "eat";
        }
        if (regrowthType.contentEquals("eat")) {
            this.mobEatPlantsAction(entity, footBlock, groundBlock, key, regrowthType);
            return;
        }
        if (regrowthType.equals("grow")) {
            this.mobGrowPlantsAction(entity, footBlock, groundBlock, key);
            return;
        }
    }

    private boolean mobGrowPlantsAction(Entity entity, Block footBlock, Block groundBlock, String key) {
        if (footBlock instanceof AirBlock) {
            if (!(groundBlock instanceof BonemealableBlock)) {
                return false;
            }
            BlockPos bpos = entity.m_142538_();
            if (bpos == null) {
                MyConfig.debugMsg(1, "ERROR:" + key + "grow plant null position.");
                return false;
            }
            BonemealableBlock ib = (BonemealableBlock)groundBlock;
            MyConfig.debugMsg(1, entity.m_142538_(), key + " growable plant found.");
            try {
                ServerLevel serverworld = (ServerLevel)entity.f_19853_;
                Random rand = entity.f_19853_.f_46441_;
                BlockState bs = entity.f_19853_.m_8055_(bpos);
                ib.m_7719_(serverworld, rand, bpos, bs);
                MyConfig.debugMsg(1, bpos, key + " grew plant.");
            }
            catch (Exception e) {
                MyConfig.debugMsg(1, bpos, key + " caught grow attempt exception.");
            }
        }
        return true;
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!level.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static boolean isKindOfGrassBlock(Block groundBlock) {
        if (groundBlock instanceof GrassBlock) {
            return true;
        }
        return groundBlock.m_7705_().equals("block.byg.meadow_grass_block");
    }

    private static boolean isBlockGrassOrDirt(Block tempBlock) {
        return MoveEntityEvent.isKindOfGrassBlock(tempBlock) || tempBlock == Blocks.f_50493_;
    }

    private BlockState helperSaplingState(Level world, BlockPos pos, Biome localBiome, BlockState sapling) {
        sapling = Blocks.f_50746_.m_49966_();
        ResourceKey k = Registry.f_122885_;
        String biomeName = world.m_5962_().m_175515_(k).m_7981_((Object)localBiome).toString();
        if (biomeName.contains("birch")) {
            sapling = Blocks.f_50748_.m_49966_();
        }
        if (biomeName.contains("taiga")) {
            sapling = Blocks.f_50747_.m_49966_();
        }
        if (biomeName.contains("jungle")) {
            sapling = Blocks.f_50749_.m_49966_();
        }
        if (biomeName.contains("savanna")) {
            sapling = Blocks.f_50750_.m_49966_();
        }
        if (biomeName.contains("desert")) {
            sapling = Blocks.f_50750_.m_49966_();
        }
        return sapling;
    }

    private void mobReforestAction(Entity entity, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        if (footBlock != Blocks.f_50016_) {
            return;
        }
        if (!MoveEntityEvent.isBlockGrassOrDirt(groundBlock)) {
            return;
        }
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        int eX = ePos.m_123341_();
        int eY = ePos.m_123342_();
        int eZ = ePos.m_123343_();
        double sinY = Math.sin((double)((eY + 64) % 256) / 256.0);
        if (entity.f_19853_.f_46441_.nextDouble() > Math.abs(sinY)) {
            return;
        }
        BlockState sapling = null;
        sapling = this.helperSaplingState(entity.f_19853_, ePos, localBiome, sapling);
        int hval = 5;
        int yval = 0;
        int yrange = 0;
        if (this.helperCountBlocksBB(SaplingBlock.class, 1, entity.f_19853_, ePos, hval, yrange) > 0) {
            return;
        }
        int leafCount = 0;
        yval = 4;
        yrange = 0;
        hval = 4;
        if (sapling == Blocks.f_50750_.m_49966_()) {
            yval = 5;
            hval = 7;
        }
        if ((leafCount = this.helperCountBlocksBB(LeavesBlock.class, 1, entity.f_19853_, ePos.m_6630_(yval), hval, yrange)) > 0) {
            return;
        }
        entity.f_19853_.m_46597_(ePos, sapling);
        MyConfig.debugMsg(1, ePos, key + " planted sapling.");
    }

    private void mobGrowMushroomAction(Entity entity, Block groundBlock, String key) {
        int huge;
        ServerLevel sWorld = (ServerLevel)entity.f_19853_;
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        if (sWorld.m_8055_(ePos).m_60734_() instanceof MushroomBlock) {
            return;
        }
        if (sWorld.m_45527_(ePos)) {
            return;
        }
        if (!this.isGoodMushroomTemperature(entity)) {
            return;
        }
        Random mushRand = new Random(this.helperLongRandomSeed(ePos));
        double fertilityDouble = mushRand.nextDouble();
        fertilityDouble = mushRand.nextDouble();
        if (fertilityDouble < 0.75) {
            MyConfig.debugMsg(1, ePos, key + " Mushroom fertility (" + fertilityDouble + ") non-growing spot.");
            return;
        }
        int smallMushroomCount = this.helperCountBlocksBB(MushroomBlock.class, 4, (Level)sWorld, ePos, 4, 1);
        if (smallMushroomCount > 3) {
            MyConfig.debugMsg(1, ePos, key + " smallMushroomCount (" + smallMushroomCount + ") mushroom too crowded.");
            return;
        }
        if (groundBlock == Blocks.f_50181_) {
            sWorld.m_46597_(ePos, Blocks.f_50073_.m_49966_());
            return;
        }
        if (groundBlock == Blocks.f_50180_) {
            sWorld.m_46597_(ePos, Blocks.f_50072_.m_49966_());
            return;
        }
        int hugeMushroomCount = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (Level)sWorld, ePos, 1, 1);
        if (hugeMushroomCount <= 0 && (huge = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (Level)sWorld, ePos, MyConfig.getMushroomDensity(), 1)) > 0) {
            MyConfig.debugMsg(1, ePos, key + " huge (" + huge + ") mushroom too crowded.");
            return;
        }
        boolean growMushroom = false;
        if (BlockTags.f_13061_ == null) {
            MyConfig.debugMsg(0, "BlockTags.BASE_STONE_OVERWORLD missing.");
            if (groundBlock == Blocks.f_50069_ || groundBlock == Blocks.f_50228_ || groundBlock == Blocks.f_50334_ || groundBlock == Blocks.f_50122_) {
                growMushroom = true;
            }
        } else {
            if (!BlockTags.f_13061_.m_8110_((Object)groundBlock)) {
                return;
            }
            growMushroom = true;
        }
        if (growMushroom) {
            double vx = entity.m_20182_().m_7096_() - ((double)ePos.m_123341_() + 0.5);
            double vz = entity.m_20182_().m_7094_() - ((double)ePos.m_123343_() + 0.5);
            Vec3 vM = new Vec3(vx, 0.0, vz).m_82541_().m_82490_(1.0).m_82520_(0.0, 0.5, 0.0);
            entity.m_20256_(entity.m_20184_().m_82549_(vM));
            if (fertilityDouble > 0.9) {
                sWorld.m_46597_(ePos.m_7495_(), Blocks.f_50195_.m_49966_());
            }
            Block theBlock = null;
            theBlock = sWorld.f_46441_.nextDouble() * 100.0 > 75.0 ? Blocks.f_50073_ : Blocks.f_50072_;
            sWorld.m_46597_(ePos, theBlock.m_49966_());
            MushroomBlock mb = (MushroomBlock)theBlock;
            try {
                mb.m_54859_(sWorld, ePos, theBlock.m_49966_(), sWorld.f_46441_);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (theBlock == Blocks.f_50073_) {
                for (int y = 9; y > 3; --y) {
                    Block b = sWorld.m_8055_(ePos.m_6630_(y)).m_60734_();
                    if (b != Blocks.f_50182_) continue;
                    sWorld.m_46597_(ePos.m_6630_(y), Blocks.f_50701_.m_49966_());
                    break;
                }
            }
            MyConfig.debugMsg(1, ePos, key + " grow mushroom.");
        }
    }

    private long helperLongRandomSeed(BlockPos ePos) {
        return (long)Math.abs(ePos.m_123341_() * 31) + (long)Math.abs(ePos.m_123343_() * 11) + (long)Math.abs(ePos.m_123342_() * 7);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boundY) {
        return this.helperCountBlocksOrthogonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.m_8055_(bPos.m_6630_(j).m_142385_(1)).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142386_(1)).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142390_(1)).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142383_(1)).m_60734_() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, boxSize);
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.m_123341_() - boxSize;
        int maxX = bPos.m_123341_() + boxSize;
        int minZ = bPos.m_123343_() - boxSize;
        int maxZ = bPos.m_123343_() + boxSize;
        int minY = bPos.m_123342_() - ySize;
        int maxY = bPos.m_123342_() + ySize;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    Block b = w.m_8055_(new BlockPos(dx, dy, dz)).m_60734_();
                    MyConfig.debugMsg(2, "dx:" + dx + ", dz:" + dz + ", dy:" + dy + "  Block:" + b.getRegistryName().toString() + ", count:" + count);
                    if (w.m_8055_(new BlockPos(dx, dy, dz)).m_60734_() == searchBlock) {
                        ++count;
                    }
                    if (count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getRegistryName().toString() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, 0);
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.m_123341_() - boxSize;
        int maxX = bPos.m_123341_() + boxSize;
        int minZ = bPos.m_123343_() - boxSize;
        int maxZ = bPos.m_123343_() + boxSize;
        int minY = bPos.m_123342_() - ySize;
        int maxY = bPos.m_123342_() + ySize;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    Block b = w.m_8055_(new BlockPos(dx, dy, dz)).m_60734_();
                    MyConfig.debugMsg(2, "dx:" + dx + ", dz:" + dz + ", dy:" + dy + "  Block:" + b.getRegistryName().toString() + ", count:" + count);
                    if (searchBlock.isInstance(w.m_8055_(new BlockPos(dx, dy, dz)).m_60734_())) {
                        ++count;
                    }
                    if (count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getSimpleName() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    private boolean isGoodMushroomTemperature(Entity entity) {
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        float biomeTemp = entity.f_19853_.m_46857_(ePos).m_47505_(ePos);
        MyConfig.debugMsg(1, ePos, "Mushroom Biome temp: " + biomeTemp + ".");
        if ((double)biomeTemp < MyConfig.getMushroomMinTemp()) {
            return false;
        }
        return !((double)biomeTemp > MyConfig.getMushroomMaxTemp());
    }

    private boolean mobEatPlantsAction(Entity entity, Block footBlock, Block groundBlock, String key, String regrowthType) {
        if (this.mobEatGrassOrFlower(entity, regrowthType, footBlock, groundBlock)) {
            MyConfig.debugMsg(1, MoveEntityEvent.getAdjustedBlockPos(entity), key + " ate plants.");
            return true;
        }
        return false;
    }

    private boolean isHorseTypeEatingNow(Entity entity) {
        AbstractHorse h;
        return entity instanceof AbstractHorse && (h = (AbstractHorse)entity).m_30617_();
    }

    private void mobStumbleAction(Entity entity, String key) {
        entity.f_19853_.m_46961_(MoveEntityEvent.getAdjustedBlockPos(entity), true);
        MyConfig.debugMsg(1, MoveEntityEvent.getAdjustedBlockPos(entity), key + " stumbled over torch.");
    }

    private void doVillagerRegrowthEvents(Villager ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int veX = ePos.m_123341_();
        int veY = ePos.m_123342_();
        int veZ = ePos.m_123343_();
        if (!MoveEntityEvent.isOnGround((Entity)ve)) {
            return;
        }
        if (MyConfig.aDebugLevel > 0) {
            TextComponent tName = new TextComponent("");
            float veYaw = ve.m_5675_(1.0f);
            tName = new TextComponent("Reg-" + veX + "," + veZ + ": " + veYaw);
            ve.m_6593_((Component)tName);
        } else if (ve.m_7770_() != null && ve.m_7770_().toString().contains("Reg-")) {
            ve.m_6593_(null);
        }
        if (this.vImproveFarm(ve, groundBlock, footBlock, regrowthType)) {
            MyConfig.debugMsg(1, ePos, key + " farm improved.");
        }
        if (regrowthType.contains("h")) {
            this.vClericalHealing(ve);
        }
        if (regrowthType.contains("v")) {
            this.vImproveLeaves(ve, groundBlock, key, veX, veY, veZ);
        }
        if (regrowthType.contains("c") && (footBlock instanceof TallGrassBlock || footBlock instanceof DoublePlantBlock || footBlock.m_7705_().equals("block.byg.short_grass"))) {
            ve.f_19853_.m_46961_(ePos, false);
            MyConfig.debugMsg(1, ePos, key + " grass cut.");
        }
        if (regrowthType.contains("r")) {
            MyConfig.debugMsg(1, ePos, key + " try road improve.");
            this.vImproveRoads(ve, footBlock, groundBlock, key, localBiome);
        }
        if (regrowthType.contains("w")) {
            MyConfig.debugMsg(1, ePos, " try town wall build.");
            this.vImproveWalls(ve, footBlock, groundBlock, key, regrowthType, localBiome);
            this.helperJumpAway(ve, footBlock);
        }
        if (regrowthType.contains("p")) {
            MyConfig.debugMsg(1, ePos, " try personal fence build.");
            this.vImproveFences(ve, footBlock, groundBlock, key, regrowthType, localBiome);
            this.helperJumpAway(ve, footBlock);
        }
        if (regrowthType.contains("t") && footBlock != Blocks.f_50081_ && this.vImproveLighting(ve, footBlock, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ePos, key + "-" + footBlock + ", " + groundBlock + " pitch: " + ve.m_146909_() + " lighting improved.");
        }
    }

    private void helperJumpAway(Villager ve, Block footBlock) {
        if (footBlock instanceof WallBlock || footBlock instanceof FenceBlock) {
            float veYaw = ve.m_5675_(1.0f) / 45.0f;
            int facingNdx = Math.round(veYaw);
            if (facingNdx < 0) {
                facingNdx = Math.abs(facingNdx);
            }
            double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
            double dz = (double)facingArray[facingNdx][1] / 2.0;
            ve.m_20334_(dx, 0.55, dz);
        }
    }

    private boolean mobEatGrassOrFlower(Entity entity, String regrowthType, Block footBlock, Block groundBlock) {
        BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(entity);
        if (!MoveEntityEvent.isGrassOrFlower(footBlock)) {
            return false;
        }
        if (MoveEntityEvent.isKindOfGrassBlock(groundBlock)) {
            this.mobTrodGrassBlock(entity);
        }
        entity.f_19853_.m_46961_(ePos, false);
        LivingEntity le = (LivingEntity)entity;
        this.helperChildAgeEntity(entity);
        if (le.m_21233_() > le.m_21223_() && MyConfig.aEatingHeals == 1.0) {
            MobEffectInstance ei = new MobEffectInstance(MobEffects.f_19601_, 1, 0, false, true);
            le.m_7292_(ei);
        }
        return true;
    }

    private void mobTrodGrassBlock(Entity e) {
        BlockPos ePos = new BlockPos(e.m_20185_(), e.m_20186_(), e.m_20189_());
        Level level = e.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel varW = (ServerLevel)level;
            AABB aabb = new AABB(ePos.m_142385_(2).m_6630_(2).m_142390_(2), ePos.m_142386_(2).m_6625_(2).m_142383_(2));
            ArrayList l = new ArrayList();
            varW.m_142646_().m_142137_((EntityTypeTest)e.m_6095_(), aabb, entity -> l.add(entity));
            if (l.size() >= 9) {
                varW.m_46597_(ePos.m_7495_(), Blocks.f_152481_.m_49966_());
                e.m_6469_(DamageSource.f_19310_, 0.25f);
            }
        }
    }

    private boolean isBlockGrassPathOrDirt(Block tempBlock) {
        return tempBlock == Blocks.f_152481_ || tempBlock == Blocks.f_50493_;
    }

    private void helperChildAgeEntity(Entity ent) {
        AgeableMob aEnt;
        if (ent instanceof AgeableMob && (aEnt = (AgeableMob)ent).m_6162_()) {
            aEnt.m_146762_(aEnt.m_146764_() + 30);
        }
    }

    private boolean mobGrowTallAction(Entity ent, Block footBlock, String key) {
        if (footBlock instanceof TallGrassBlock) {
            BlockPos ePos = MoveEntityEvent.getAdjustedBlockPos(ent);
            BonemealableBlock ib = (BonemealableBlock)footBlock;
            ib.m_7719_((ServerLevel)ent.f_19853_, ent.f_19853_.f_46441_, ePos, ent.f_19853_.m_8055_(ePos));
            MyConfig.debugMsg(1, ePos, key + " grew and hid in tall plant.");
            return true;
        }
        return false;
    }

    private BlockState helperBiomeRoadBlockType(Biome localBiome) {
        BlockState gateBlockType = Blocks.f_152481_.m_49966_();
        if (localBiome.m_47567_() == Biome.BiomeCategory.DESERT) {
            gateBlockType = Blocks.f_50471_.m_49966_();
        }
        return gateBlockType;
    }

    private boolean vImproveFarm(Villager ve, Block groundBlock, Block footBlock, String regrowthType) {
        if (ve.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
            return false;
        }
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        if (this.helperCountBlocksOrthogonalBB(Blocks.f_50093_, 1, ve.f_19853_, vePos.m_6625_(1), 0) > 0) {
            if (MoveEntityEvent.isNearWater((LevelReader)ve.f_19853_, vePos.m_6625_(1)) && groundBlock instanceof GrassBlock) {
                ve.f_19853_.m_46597_(vePos.m_7495_(), Blocks.f_50093_.m_49966_());
                return true;
            }
            if (!regrowthType.contains("t") || footBlock != Blocks.f_50016_) {
                return false;
            }
            if (ve.f_19853_.m_45517_(LightLayer.BLOCK, vePos) > 12) {
                return false;
            }
            int veX = vePos.m_123341_();
            int veY = vePos.m_123342_();
            int veZ = vePos.m_123343_();
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                return false;
            }
            boolean placeTorch = false;
            int waterValue = this.helperCountBlocksOrthogonalBB(Blocks.f_49990_, 1, ve.f_19853_, vePos.m_7495_(), 0);
            if (waterValue > 0 && BlockTags.f_13106_.m_8110_((Object)groundBlock) || groundBlock == Blocks.f_50471_) {
                ve.f_19853_.m_7731_(vePos, Blocks.f_50081_.m_49966_(), 3);
                lastTorchX = veX;
                lastTorchY = veY;
                lastTorchZ = veZ;
                return true;
            }
        }
        return false;
    }

    private void vClericalHealing(Villager ve) {
        if (ve.m_7141_().m_35571_() != VillagerProfession.f_35589_) {
            return;
        }
        long daytime = ve.f_19853_.m_46468_() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        Level level = ve.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel varW = (ServerLevel)level;
            int clericalLevel = ve.m_7141_().m_35576_();
            BlockPos vePos = new BlockPos(ve.m_20185_(), ve.m_20186_() + 0.99, ve.m_20189_());
            AABB aabb = new AABB(vePos.m_142385_(4).m_6630_(2).m_142390_(4), vePos.m_142386_(4).m_6625_(2).m_142383_(4));
            ArrayList l = new ArrayList();
            varW.m_142646_().m_142232_(aabb, entity -> {
                if (entity instanceof Villager || entity instanceof Player) {
                    l.add(entity);
                }
            });
            for (Entity e : l) {
                Player pe;
                int rep;
                boolean heal = true;
                LivingEntity le = (LivingEntity)e;
                if (!(le.m_21223_() < le.m_21233_())) continue;
                Entity entity2 = e;
                if (entity2 instanceof Player && (rep = ve.m_35532_(pe = (Player)entity2)) < 0) {
                    heal = false;
                }
                if (!heal) continue;
                le.m_147207_(new MobEffectInstance(MobEffects.f_19605_, clericalLevel * 51, 0), (Entity)ve);
                return;
            }
        }
    }

    private void vImproveLeaves(Villager ve, Block groundBlock, String key, int veX, int veY, int veZ) {
        float veYaw = ve.m_5675_(1.0f) / 45.0f;
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        facingNdx %= 8;
        if (groundBlock == Blocks.f_152481_) {
            ++veY;
        }
        int dx = facingArray[facingNdx][0];
        int dz = facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        BlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new BlockPos(veX + dx, veY + iY, veZ + dz);
            tempBS = ve.f_19853_.m_8055_(tmpBP);
            tempBlock = tempBS.m_60734_();
            if (tempBlock instanceof LeavesBlock && !(persistantLeaves = ((Boolean)tempBS.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof CactusBlock) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.f_19853_.m_46961_(tmpBP, false);
            destroyBlock = false;
            MyConfig.debugMsg(1, vePos, key + " cleared " + tempBlock.m_7705_().toString());
        }
    }

    private boolean vImproveLighting(Villager ve, Block footBlock, Block groundBlock, Biome localBiome) {
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int blockLightValue = ve.f_19853_.m_45517_(LightLayer.BLOCK, vePos);
        int skyLightValue = ve.f_19853_.m_45517_(LightLayer.SKY, vePos);
        if (blockLightValue > MyConfig.getTorchLightLevel()) {
            return false;
        }
        if (skyLightValue > 13) {
            return false;
        }
        if (ve.m_5803_()) {
            return false;
        }
        if (footBlock instanceof BedBlock) {
            return false;
        }
        if (MoveEntityEvent.isValidGroundBlockToPlaceTorchOn(ve, groundBlock) && footBlock instanceof AirBlock) {
            ve.f_19853_.m_7731_(vePos, Blocks.f_50081_.m_49966_(), 3);
        }
        return true;
    }

    private void vImproveRoads(Villager ve, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        if (this.vImproveRoadsFixUnfinished(ve, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ve.m_142538_(), key + " fix road.");
        }
        if (this.vImproveRoadsSmoothHeight(ve, footBlock, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, ve.m_142538_(), key + " Smooth road slope.");
        }
    }

    private boolean vImproveRoadsFixUnfinished(Villager ve, Block groundBlock, Biome localBiome) {
        Block biomeRoadBlock;
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int fixHeight = 3;
        if (Biome.BiomeCategory.TAIGA == localBiome.m_47567_()) {
            fixHeight = 5;
        }
        if ((biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).m_60734_()) == Blocks.f_50471_) {
            int skyLightValue = ve.f_19853_.m_45517_(LightLayer.SKY, vePos);
            if (skyLightValue < 13) {
                return false;
            }
            if (!ve.m_7133_().m_45527_(ve.m_142538_())) {
                return false;
            }
        }
        int veX = vePos.m_123341_();
        int veY = vePos.m_123342_();
        int veZ = vePos.m_123343_();
        if (groundBlock != biomeRoadBlock) {
            int roadBlockCount = 0;
            for (int dy = -1; dy <= fixHeight; ++dy) {
                for (int i = 0; i < 4; ++i) {
                    Block tempBlock = ve.f_19853_.m_8055_(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).m_60734_();
                    if (tempBlock != biomeRoadBlock || ++roadBlockCount <= 2) continue;
                    if (ve.f_19853_.m_8055_(ve.m_142538_()).m_60734_() instanceof SnowLayerBlock) {
                        ve.f_19853_.m_46961_(vePos, false);
                    }
                    ve.f_19853_.m_46597_(vePos.m_7495_(), biomeRoadBlock.m_49966_());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean vImproveRoadsSmoothHeight(Villager ve, Block footBlock, Block groundBlock, Biome localBiome) {
        Collection result;
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int skyLightValue = ve.f_19853_.m_45517_(LightLayer.SKY, vePos);
        if (skyLightValue < 14) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).m_60734_();
        if (groundBlock != biomeRoadBlock && footBlock != biomeRoadBlock) {
            return false;
        }
        BlockState smoothingBlockState = biomeRoadBlock.m_49966_();
        Block smoothingBlock = biomeRoadBlock;
        int poiDistance = 3;
        Object key = "minecraft:" + localBiome.m_47567_().toString();
        if (((String)(key = ((String)key).toLowerCase())).equals("minecraft:desert")) {
            poiDistance = 7;
            if (!ve.m_7133_().m_45527_(ve.m_142538_())) {
                return false;
            }
        }
        if (!(result = (Collection)((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> true, ve.m_142538_(), poiDistance, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new))).isEmpty()) {
            for (PoiRecord P : result) {
                int disX = Math.abs(ve.m_142538_().m_123341_() - P.m_27257_().m_123341_());
                int disZ = Math.abs(ve.m_142538_().m_123343_() - P.m_27257_().m_123343_());
                if (disX >= poiDistance || disZ >= poiDistance) continue;
                MyConfig.debugMsg(1, vePos, "Point of Interest too Close: " + P.m_27258_().toString() + ".");
                return false;
            }
        }
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
        int yAdjust = 0;
        if (smoothingBlock == Blocks.f_152481_) {
            yAdjust = 1;
        }
        int veX = vePos.m_123341_();
        int veY = vePos.m_123342_();
        int veZ = vePos.m_123343_();
        for (int dy = 1; dy < 5 + yAdjust; ++dy) {
            for (int i = 0; i < 4; ++i) {
                Block tempBlock = ve.f_19853_.m_8055_(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).m_60734_();
                if (tempBlock != smoothingBlock) continue;
                if (ve.f_19853_.m_8055_(new BlockPos(veX, veY, veZ)).m_60734_() instanceof SnowLayerBlock) {
                    ve.f_19853_.m_46961_(vePos, false);
                }
                ve.f_19853_.m_46597_(new BlockPos(veX, veY, veZ), smoothingBlockState);
                ve.m_20334_(0.0, 0.4, 0.0);
                return true;
            }
        }
        return false;
    }

    private boolean vImproveWallForMeetingPlace(Villager ve, String regrowthActions, BlockPos villageMeetingPlaceBlockPos, Block groundBlock, Block footBlock, Biome localBiome) {
        int absvz;
        int absvx;
        int wallPerimeter;
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + localBiome.m_47567_().toString();
        key = ((String)key).toLowerCase();
        MyConfig.debugMsg(2, vePos, (String)key + " wall improvement.");
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
        MyConfig.debugMsg(1, vePos, (String)key + " biome for wall improvement.");
        if (currentWallBiomeDataItem == null) {
            MyConfig.debugMsg(2, vePos, "wallbiome data null.");
            key = "minecraft:" + localBiome.m_47567_().toString().toLowerCase();
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
            if (currentWallBiomeDataItem == null) {
                currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
            }
        }
        if ((wallPerimeter = currentWallBiomeDataItem.getWallDiameter()) < 32) {
            wallPerimeter = 32;
        }
        if (wallPerimeter > 80) {
            wallPerimeter = 80;
        }
        if (MoveEntityEvent.isOnWallPerimeter(wallPerimeter = wallPerimeter / 2 - 1, absvx = (int)Math.abs(ve.m_20185_() - (double)villageMeetingPlaceBlockPos.m_123341_()), absvz = (int)Math.abs(ve.m_20189_() - (double)villageMeetingPlaceBlockPos.m_123343_()))) {
            MyConfig.debugMsg(2, ve.m_142538_(), "villager on wall perimeter: " + wallPerimeter);
            Collection result = ((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> t == PoiType.f_27347_, ve.m_142538_(), 41, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (PoiRecord P : result) {
                    if (villageMeetingPlaceBlockPos.m_123341_() == P.m_27257_().m_123341_() && villageMeetingPlaceBlockPos.m_123342_() == P.m_27257_().m_123342_() && villageMeetingPlaceBlockPos.m_123343_() == P.m_27257_().m_123343_()) continue;
                    int disX = Math.abs(ve.m_142538_().m_123341_() - P.m_27257_().m_123341_());
                    int disZ = Math.abs(ve.m_142538_().m_123343_() - P.m_27257_().m_123343_());
                    if (disX >= wallPerimeter || disZ >= wallPerimeter) continue;
                    buildWall = false;
                    break;
                }
            }
            if (buildWall) {
                MyConfig.setaDebugLevel(2);
                BlockState wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState();
                if (wallTypeBlockState == null) {
                    wallTypeBlockState = Blocks.f_50274_.m_49966_();
                }
                BlockState wallBlock = wallTypeBlockState;
                int wallTorchSpacing = (wallPerimeter + 1) / 4;
                BlockState gateBlockType = this.helperBiomeRoadBlockType(localBiome);
                if (this.helperPlaceOneWallPiece(ve, regrowthActions, wallPerimeter, wallTorchSpacing, gateBlockType, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                    if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, ve.f_19853_.m_8055_(vePos).m_60734_())) {
                        ve.f_19853_.m_46597_(vePos.m_7494_(), Blocks.f_50081_.m_49966_());
                    }
                    MyConfig.setaDebugLevel(0);
                    return true;
                }
            }
        }
        MyConfig.setaDebugLevel(0);
        return false;
    }

    private boolean vImproveHomeFence(Villager ve, BlockPos vHomePos, String regrowthActions, Block groundBlock, Block footBlock, Biome localBiome) {
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + localBiome.m_47567_().toString();
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem == null && (currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = "minecraft:" + localBiome.m_47567_().toString().toLowerCase()))) == null) {
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
        }
        int homeFenceDiameter = currentWallBiomeDataItem.getWallDiameter();
        if ((homeFenceDiameter /= 4) < 7) {
            homeFenceDiameter = 7;
        }
        if (homeFenceDiameter > 16) {
            homeFenceDiameter = 16;
        }
        int wallTorchSpacing = homeFenceDiameter / 4;
        homeFenceDiameter = homeFenceDiameter / 2 - 1;
        int absvx = (int)Math.abs(ve.m_20185_() - (double)vHomePos.m_123341_());
        int absvz = (int)Math.abs(ve.m_20189_() - (double)vHomePos.m_123343_());
        Collection result = ((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> t == PoiType.f_27346_, vePos, 17, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new));
        boolean buildWall = true;
        if (!result.isEmpty()) {
            for (PoiRecord P : result) {
                if (vHomePos.m_123341_() == P.m_27257_().m_123341_() && vHomePos.m_123342_() == P.m_27257_().m_123342_() && vHomePos.m_123343_() == P.m_27257_().m_123343_()) continue;
                int disX = Math.abs(vePos.m_123341_() - P.m_27257_().m_123341_());
                int disZ = Math.abs(vePos.m_123343_() - P.m_27257_().m_123343_());
                MyConfig.debugMsg(1, P.m_27257_(), "extra Point of Interest Found.");
                if (disX >= homeFenceDiameter || disZ >= homeFenceDiameter) continue;
                buildWall = false;
                break;
            }
        } else if (result.isEmpty()) {
            buildWall = true;
        }
        if (buildWall) {
            BlockState fenceBlockState = currentWallBiomeDataItem.getFenceBlockState();
            if (fenceBlockState == null) {
                fenceBlockState = Blocks.f_50132_.m_49966_();
            }
            BlockState wallBlock = fenceBlockState;
            BlockState gateBlockType = this.helperBiomeRoadBlockType(localBiome);
            boolean buildCenterGate = true;
            if (this.helperPlaceOneWallPiece(ve, regrowthActions, homeFenceDiameter, wallTorchSpacing, gateBlockType, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                if (regrowthActions.contains("t") && MoveEntityEvent.isValidTorchLocation(homeFenceDiameter, wallTorchSpacing, absvx, absvz, ve.f_19853_.m_8055_(vePos).m_60734_())) {
                    ve.f_19853_.m_46597_(vePos.m_7494_(), Blocks.f_50081_.m_49966_());
                }
                return true;
            }
        }
        return false;
    }

    private void vImproveWalls(Villager ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        if (groundBlock instanceof AirBlock) {
            return;
        }
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        Brain vb = ve.m_6274_();
        Optional vMeetingPlace = vb.m_21952_(MemoryModuleType.f_26362_);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (MoveEntityEvent.isOkayToBuildWallHere(ve, footBlock, groundBlock)) {
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos gVMPPos = gVMP.m_122646_();
            long chunkAge = ve.f_19853_.m_46745_(gVMPPos).m_6319_();
            if (chunkAge < 1200L) {
                ve.f_19853_.m_7731_(gVMPPos.m_6630_(1), Blocks.f_50274_.m_49966_(), 3);
            }
            if (!(ve.f_19853_.m_8055_(gVMPPos.m_6630_(1)).m_60734_() instanceof WallBlock)) {
                return;
            }
            if (regrowthType.contains("w")) {
                MyConfig.debugMsg(1, vePos, "Checking Improve Wall.");
                if (this.vImproveWallForMeetingPlace(ve, regrowthType, gVMPPos, groundBlock, footBlock, localBiome)) {
                    MyConfig.debugMsg(1, vePos, "Meeting Wall Improved.");
                }
            }
        }
    }

    private void vImproveFences(Villager ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos ePos = ve.m_142538_();
        Brain vb = ve.m_6274_();
        Optional vMeetingPlace = vb.m_21952_(MemoryModuleType.f_26362_);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (MoveEntityEvent.isOkayToBuildWallHere(ve, footBlock, groundBlock)) {
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos villageMeetingPlaceBlockPos = gVMP.m_122646_();
            if (!(ve.f_19853_.m_8055_(villageMeetingPlaceBlockPos.m_6630_(1)).m_60734_() instanceof WallBlock)) {
                return;
            }
            if (regrowthType.contains("p")) {
                MyConfig.debugMsg(1, ePos, "Checking Improve Fence.");
                Optional villagerHome = vb.m_21952_(MemoryModuleType.f_26359_);
                if (!villagerHome.isPresent()) {
                    return;
                }
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.m_122646_();
                if (MoveEntityEvent.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((GlobalPos)vMeetingPlace.get()).m_122646_(), localBiome)) {
                    MyConfig.debugMsg(1, ePos, "Outside meeting place wall.");
                    if (this.vImproveHomeFence(ve, villagerHomePos, regrowthType, groundBlock, footBlock, localBiome)) {
                        MyConfig.debugMsg(1, ePos, "Home Fence Improved.");
                    }
                }
            }
        }
    }

    private static boolean isFootBlockOkayToBuildIn(Block footBlock) {
        return footBlock instanceof AirBlock || MoveEntityEvent.isGrassOrFlower(footBlock);
    }

    private static boolean isGrassOrFlower(Block footBlock) {
        block11: {
            if (footBlock instanceof TallGrassBlock) {
                return true;
            }
            if (footBlock instanceof FlowerBlock) {
                return true;
            }
            if (footBlock instanceof DoublePlantBlock) {
                return true;
            }
            if (footBlock == Blocks.f_50035_) {
                return true;
            }
            if (footBlock == Blocks.f_50360_) {
                return true;
            }
            try {
                if (BlockTags.f_13041_.m_8110_((Object)footBlock)) {
                    return true;
                }
                if (BlockTags.f_13040_.m_8110_((Object)footBlock)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (MyConfig.aDebugLevel <= 0) break block11;
                System.out.println("Tag Exception 1009-1014:" + footBlock.m_7705_() + ".");
            }
        }
        if (footBlock.m_7705_() == "block.byg.short_grass") {
            return true;
        }
        if (MyConfig.aDebugLevel > 0) {
            System.out.println("Not grass or Flower:" + footBlock.m_7705_() + ".");
        }
        return false;
    }

    private static boolean isImpossibleRegrowthEvent(Block footBlock, String regrowthType) {
        if (regrowthType.equals("eat") && footBlock instanceof AirBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof FlowerBlock) {
            return true;
        }
        return regrowthType.equals("tall") && !(footBlock instanceof TallGrassBlock);
    }

    private static boolean isOkayToBuildWallHere(Villager ve, Block footBlock, Block groundBlock) {
        BlockPos ePos = ve.m_142538_();
        boolean okayToBuildWalls = true;
        if (!MoveEntityEvent.isOnGround((Entity)ve)) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isFootBlockOkayToBuildIn(footBlock)) {
            okayToBuildWalls = false;
        }
        if (!MoveEntityEvent.isValidGroundBlockToBuildWallOn(ve, groundBlock)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private static boolean isOnGround(Entity e) {
        return e.m_20096_();
    }

    private static boolean isOnWallPerimeter(int wallPerimeter, int absvx, int absvz) {
        boolean scratch = false;
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            scratch = true;
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            scratch = true;
        }
        return scratch;
    }

    private static boolean isOutsideMeetingPlaceWall(Villager ve, Optional<GlobalPos> vMeetingPlace, BlockPos meetingPlacePos, Biome localBiome) {
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + localBiome.m_47567_().toString();
        int wallDiameter = 64;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem != null) {
            wallDiameter = currentWallBiomeDataItem.getWallDiameter();
        }
        wallDiameter = wallDiameter / 2 - 1;
        int absVMpX = Math.abs(vePos.m_123341_() - meetingPlacePos.m_123341_());
        int absVMpZ = Math.abs(vePos.m_123343_() - meetingPlacePos.m_123343_());
        if (absVMpX > wallDiameter + 1) {
            return true;
        }
        return absVMpZ > wallDiameter + 1;
    }

    private static boolean isValidGroundBlockToPlaceTorchOn(Villager ve, Block groundBlock) {
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private static boolean isValidGroundBlockToBuildWallOn(Villager ve, Block groundBlock) {
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        int blockSkyLightValue = ve.f_19853_.m_45517_(LightLayer.SKY, vePos);
        if (blockSkyLightValue < 13) {
            return false;
        }
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private static boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof WallBlock) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof FenceBlock) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean helperPlaceOneWallPiece(Villager ve, String regrowthType, int wallPerimeter, int wallTorchSpacing, BlockState gateBlockType, BlockState wallType, int absvx, int absvz, Block groundBlock, Block footBlock) {
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            return this.helperPlaceWallPiece(ve, gateBlockType, wallType, absvz);
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            return this.helperPlaceWallPiece(ve, gateBlockType, wallType, absvx);
        }
        return false;
    }

    private boolean helperPlaceWallPiece(Villager ve, BlockState gateBlockType, BlockState wallType, int absva) {
        BlockPos vePos = MoveEntityEvent.getAdjustedBlockPos((Entity)ve);
        Block b = ve.f_19853_.m_8055_(vePos).m_60734_();
        if (b instanceof SnowLayerBlock) {
            ve.f_19853_.m_46961_(vePos, false);
        }
        if (b instanceof SaplingBlock || b instanceof TallGrassBlock || b instanceof FlowerBlock || b instanceof DoublePlantBlock) {
            ve.f_19853_.m_46961_(vePos, true);
        }
        if (absva == 0) {
            ve.f_19853_.m_46597_(vePos.m_7495_(), gateBlockType);
            return true;
        }
        if (ve.f_19853_.m_46597_(vePos, wallType)) {
            return true;
        }
        MyConfig.debugMsg(1, ve.m_142538_(), "Building Wall Fail: SetBlockAndUpdate Time End = " + ve.f_19853_.m_46467_());
        return false;
    }
}

