/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class RegrowthEntitiesManager {
    public static Hashtable<String, RegrowthMobItem> regrowthMobHashtable = new Hashtable();

    public static RegrowthMobItem getRegrowthMobInfo(String key) {
        String iKey = key;
        if (regrowthMobHashtable.isEmpty()) {
            RegrowthEntitiesManager.regrowthMobInit();
        }
        RegrowthMobItem r = regrowthMobHashtable.get(iKey);
        return r;
    }

    public static String getRegrowthHashAsString() {
        Object returnString = "";
        for (String key : regrowthMobHashtable.keySet()) {
            String regrowthType = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthAction;
            double percentage = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthEventSeconds;
            String tempString = key + "," + regrowthType + "," + percentage + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void regrowthMobInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        int i = 0;
        String regrowthMobLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultRegrowthMobs6464, ";");
        while (st6464.hasMoreElements()) {
            regrowthMobLine6464 = st6464.nextToken().trim();
            if (regrowthMobLine6464.isEmpty()) continue;
            dTL6464.add(regrowthMobLine6464);
            ++i;
        }
        MyConfig.defaultRegrowthMobs = dTL6464.toArray(new String[i]);
        regrowthMobHashtable.clear();
        for (i = 0; i < MyConfig.defaultRegrowthMobs.length; ++i) {
            try {
                String modAndEntity;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultRegrowthMobs[i], ",");
                String key = modAndEntity = st.nextToken();
                String regrowthType = st.nextToken();
                String secondsString = st.nextToken();
                double seconds = Double.parseDouble(secondsString.trim());
                if (seconds <= 1.0) {
                    seconds = 1.0;
                }
                regrowthMobHashtable.put(key, new RegrowthMobItem(regrowthType, seconds));
                if (modAndEntity.contentEquals("hbm:default") || ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(modAndEntity))) continue;
                System.out.println("Regrowth Debug: Mob: " + modAndEntity + " not in Forge Entity Type Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Mob Config : " + MyConfig.defaultRegrowthMobs[i]);
            }
        }
    }

    public static class RegrowthMobItem {
        double regrowthEventSeconds;
        String regrowthAction;

        public RegrowthMobItem(String regrowthType, double regrowthEventSeconds) {
            this.regrowthAction = regrowthType;
            this.regrowthEventSeconds = regrowthEventSeconds;
        }

        public String getRegrowthActions() {
            return this.regrowthAction.toLowerCase();
        }

        public double getRegrowthEventSeconds() {
            return this.regrowthEventSeconds;
        }
    }
}

