/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class WallBiomeDataManager {
    private static Hashtable<String, WallBiomeDataItem> wallBiomeDataHashtable = new Hashtable();

    public static WallBiomeDataItem getWallBiomeDataItem(String key) {
        WallBiomeDataItem r;
        String iKey = key;
        if (wallBiomeDataHashtable.isEmpty()) {
            WallBiomeDataManager.wallBiomeDataInit();
        }
        if ((r = wallBiomeDataHashtable.get(iKey)) == null) {
            if (MyConfig.aDebugLevel > 0) {
                System.out.println("Error!  Villager in unknown Biome:" + key + ".");
            }
            r = wallBiomeDataHashtable.get("minecraft:plains");
        }
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222 WallBiomeDataItem: " + iKey + " wall=" + r.getWallBlockState().m_60734_().toString() + "fence=" + r.getFenceBlockState().m_60734_().toString() + ".");
        }
        return r;
    }

    public static String getWallBiomeDataHashAsString() {
        Object returnString = "";
        for (String key : wallBiomeDataHashtable.keySet()) {
            int wallSize = WallBiomeDataManager.wallBiomeDataHashtable.get((Object)key).wallSize;
            BlockState wallTypeBlockState = wallBiomeDataHashtable.get(key).getWallBlockState();
            String tempString = key + "," + wallSize + "," + wallTypeBlockState.toString() + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void wallBiomeDataInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        List walls = new ArrayList();
        List fences = new ArrayList();
        try {
            walls = BlockTags.f_13032_.m_6497_();
            System.out.println("succeeded in loading walls all tags");
        }
        catch (Exception e) {
            System.out.println("failed to get walls all tags ");
            return;
        }
        try {
            fences = BlockTags.f_13039_.m_6497_();
            System.out.println("succeeded in loading fences all tags");
        }
        catch (Exception e) {
            System.out.println("failed to load fences all tags");
            return;
        }
        int i = 0;
        String wallBiomeDataLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultWallBiomeData6464, ";");
        while (st6464.hasMoreElements()) {
            wallBiomeDataLine6464 = st6464.nextToken().trim();
            if (wallBiomeDataLine6464.isEmpty()) continue;
            dTL6464.add(wallBiomeDataLine6464);
            ++i;
        }
        MyConfig.defaultWallBiomeData = dTL6464.toArray(new String[i]);
        wallBiomeDataHashtable.clear();
        for (i = 0; i < MyConfig.defaultWallBiomeData.length; ++i) {
            try {
                String modAndBiome;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallBiomeData[i], ",");
                String key = modAndBiome = st.nextToken();
                String wallSizeString = st.nextToken();
                String wallBlockString = st.nextToken();
                String fenceBlockString = st.nextToken();
                int wallSize = Integer.parseInt(wallSizeString.trim());
                if (wallSize <= 32) {
                    wallSize = 32;
                }
                if (wallSize > 80) {
                    wallSize = 80;
                }
                BlockState wallBlockState = null;
                for (int v = 0; v < walls.size(); ++v) {
                    String wbs = ((Block)walls.get(v)).getRegistryName().toString();
                    if (!wbs.equals(wallBlockString)) continue;
                    wallBlockState = ((Block)walls.get(v)).m_49966_();
                    break;
                }
                if (wallBlockState == null) {
                    wallBlockState = Blocks.f_50274_.m_49966_();
                }
                BlockState fenceBlockState = null;
                for (int v = 0; v < fences.size(); ++v) {
                    String fbs = ((Block)fences.get(v)).getRegistryName().toString();
                    if (!fbs.equals(fenceBlockString)) continue;
                    fenceBlockState = ((Block)fences.get(v)).m_49966_();
                    break;
                }
                if (fenceBlockState == null) {
                    fenceBlockState = Blocks.f_50132_.m_49966_();
                }
                wallBiomeDataHashtable.put(key, new WallBiomeDataItem(wallSize, wallBlockState, fenceBlockState));
                if (modAndBiome.contentEquals("Regrowth:default") || modAndBiome.contentEquals("Regrowth:minimum") || modAndBiome.contentEquals("minecraft:icy") || modAndBiome.contentEquals("minecraft:extreme_hills") || modAndBiome.contentEquals("minecraft:mesa") || modAndBiome.contentEquals("minecraft:nether") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(modAndBiome))) continue;
                System.out.println("Regrowth Debug: Wall Biome Data: " + key + " not in Forge Entity Type Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Biome Data Config : " + MyConfig.defaultWallBiomeData[i]);
            }
        }
    }

    public static class WallBiomeDataItem {
        int wallSize;
        BlockState wallBlockState;
        BlockState fenceBlockState;

        public WallBiomeDataItem(int wallSize, BlockState wallBlockState, BlockState fenceBlockState) {
            this.wallSize = wallSize;
            this.wallBlockState = wallBlockState;
            this.fenceBlockState = fenceBlockState;
        }

        public int getWallDiameter() {
            return this.wallSize;
        }

        public BlockState getWallBlockState() {
            return this.wallBlockState;
        }

        public BlockState getFenceBlockState() {
            return this.fenceBlockState;
        }
    }
}

