/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import com.mactso.regrowth.utility.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoveEntityEvent {
    private Random moveRand = new Random();
    private final Block[] coralPlants = new Block[]{Blocks.f_50038_, Blocks.f_50037_, Blocks.f_50567_, Blocks.f_50553_, Blocks.f_50554_, Blocks.f_50555_, Blocks.f_50556_, Blocks.f_50552_, Blocks.f_50553_, Blocks.f_50554_, Blocks.f_50555_, Blocks.f_50556_, Blocks.f_50552_};
    private final Block[] coralfans = new Block[]{Blocks.f_50563_, Blocks.f_50564_, Blocks.f_50565_, Blocks.f_50566_, Blocks.f_50562_};
    private final Rotation[] coralfanrotations = new Rotation[]{Rotation.CLOCKWISE_180, Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.NONE};
    private int[] dx = new int[]{1, 0, -1, 0};
    private int[] dz = new int[]{0, 1, 0, -1};
    private int CHECKS_PER_SECOND = 10;
    private int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    private int lastTorchX = 0;
    private int lastTorchY = 0;
    private int lastTorchZ = 0;
    static final int WALL_CENTER = 0;
    static final int FENCE_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;
    static final String ACTION_GROW = "grow";
    static final String ACTION_EAT = "eat";
    static final String ACTION_BOTH = "both";
    static final String ACTION_TALL = "tall";
    static final String ACTION_MUSHROOM = "mushroom";
    static final String ACTION_STUMBLE = "stumble";
    static final String ACTION_REFOREST = "reforest";
    static final String ACTION_CORAL = "coral";
    private BlockState footBlockState;
    private BlockState groundBlockState;
    private Block footBlock;
    private Block groundBlock;
    private Biome localBiome;
    private boolean isRoadPiece = false;
    private Biome.BiomeCategory biomeCategory;
    BlockPos adjustedPos;

    @SubscribeEvent
    public void handleTrampleEvents(BlockEvent.FarmlandTrampleEvent event) {
        BlockPos pos = event.getEntity().m_142538_();
        MyConfig.debugMsg(1, pos, "Enter FarmlandTrampleEvent");
        if (event.isCancelable()) {
            Entity entity = event.getEntity();
            if (entity instanceof Villager) {
                Villager ve = (Villager)entity;
                if (ve.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
                    MyConfig.debugMsg(2, pos, "Villager Not A Farmer");
                    return;
                }
                if (ve.m_7141_().m_35576_() >= 3) {
                    event.setCanceled(true);
                    MyConfig.debugMsg(2, pos, "Farmer under level 3.");
                    return;
                }
            }
            if ((entity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)entity;
                if (!spe.m_7500_()) {
                    return;
                }
                MyConfig.debugMsg(2, pos, "FarmlandTrampleCancelled");
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleEntityMoveEvents(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if ((long)(entity.m_142049_() % 2) == entity.f_19853_.m_46467_() % 2L) {
            return;
        }
        if (entity.m_142538_() == null) {
            return;
        }
        String registryNameAsString = this.helperGetRegistryNameAsString(entity);
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            Villager ve;
            ServerLevel sLevel = (ServerLevel)level;
            this.adjustedPos = this.getAdjustedBlockPos(entity);
            this.footBlockState = this.getAdjustedFootBlockState(entity);
            this.footBlock = this.footBlockState.m_60734_();
            if (this.footBlock instanceof WoolCarpetBlock) {
                return;
            }
            this.groundBlockState = this.getAdjustedGroundBlockState(entity);
            this.groundBlock = this.groundBlockState.m_60734_();
            if (this.groundBlockState.m_60795_()) {
                return;
            }
            this.localBiome = sLevel.m_46857_(this.adjustedPos);
            this.biomeCategory = this.localBiome.m_47567_();
            String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
            if (this.isImpossibleRegrowthEvent(regrowthActions)) {
                return;
            }
            double regrowthEventOdds = 1.0 / (currentRegrowthMobItem.getRegrowthEventSeconds() * (double)this.CHECKS_PER_SECOND);
            if (this.isHorseTypeEatingNow(entity)) {
                regrowthEventOdds *= 20.0;
            }
            double randomD100Roll = entity.f_19853_.f_46441_.nextDouble();
            boolean debugvalue = false;
            long chunkAge = entity.f_19853_.m_46745_(entity.m_142538_()).m_6319_();
            if (chunkAge < 480000L && entity instanceof Villager) {
                ve = (Villager)entity;
                if (ve.f_19853_.m_46467_() % 12L == 0L) {
                    if (regrowthActions.contains("r")) {
                        this.vImproveRoads(ve, "preRoad");
                    }
                    if (regrowthActions.contains("w")) {
                        this.vImproveVillageWall(ve, regrowthActions);
                    }
                }
            }
            if (randomD100Roll <= regrowthEventOdds + (double)debugvalue) {
                if (entity instanceof Villager) {
                    ve = (Villager)entity;
                    this.improvePowderedSnow(entity);
                    if (ve.m_20096_() && !(this.footBlock instanceof BedBlock)) {
                        this.doVillagerRegrowthEvents(ve, registryNameAsString, regrowthActions);
                    }
                } else {
                    this.doMobRegrowthEvents(entity, registryNameAsString, regrowthActions);
                }
            }
        }
    }

    private String helperGetRegistryNameAsString(Entity entity) {
        EntityType tempType = entity.m_6095_();
        ResourceLocation registryName = tempType.getRegistryName();
        String registryNameAsString = registryName.toString();
        return registryNameAsString;
    }

    private BlockState getAdjustedFootBlockState(Entity e) {
        if (e.m_20186_() == (double)e.m_142538_().m_123342_()) {
            return e.f_19853_.m_8055_(e.m_142538_());
        }
        return e.f_19853_.m_8055_(e.m_142538_().m_7494_());
    }

    private int getAdjustedY(Entity e) {
        if (e.m_20186_() == (double)e.m_142538_().m_123342_()) {
            return 1;
        }
        return 0;
    }

    private BlockState getAdjustedGroundBlockState(Entity e) {
        return e.f_19853_.m_8055_(e.m_142538_().m_6625_(this.getAdjustedY(e)));
    }

    private BlockPos getAdjustedBlockPos(Entity e) {
        if (e.m_20186_() == (double)e.m_142538_().m_123342_()) {
            return e.m_142538_();
        }
        return e.m_142538_().m_7494_();
    }

    private void improvePowderedSnow(Entity entity) {
        Level sLevel = entity.f_19853_;
        if (entity.f_146808_) {
            int hp = 0;
            if (sLevel.m_8055_(entity.m_142538_().m_6630_(2)).m_60734_() == Blocks.f_152499_) {
                entity.f_19853_.m_46961_(entity.m_142538_().m_6630_(2), false);
                hp = 2;
            }
            if (sLevel.m_8055_(entity.m_142538_().m_7494_()).m_60734_() == Blocks.f_152499_) {
                entity.f_19853_.m_46961_(entity.m_142538_().m_7494_(), false);
                hp += 2;
            }
            if (sLevel.m_8055_(entity.m_142538_()).m_60734_() == Blocks.f_152499_) {
                BlockState SnowLayer = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(2 + hp));
                entity.f_19853_.m_46597_(entity.m_142538_(), SnowLayer);
            }
        }
    }

    private void doMobRegrowthEvents(Entity entity, String key, String regrowthType) {
        if (regrowthType.equals(ACTION_STUMBLE)) {
            if (this.footBlock instanceof TorchBlock || this.footBlock instanceof WallTorchBlock) {
                this.mobStumbleAction(entity, key);
            }
            return;
        }
        if (regrowthType.equals(ACTION_REFOREST)) {
            this.mobReforestAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_MUSHROOM)) {
            this.mobGrowMushroomAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_CORAL)) {
            this.mobGrowCoralAction(entity, key);
            return;
        }
        if (!this.isKindOfGrassBlock(this.groundBlockState)) {
            return;
        }
        if (regrowthType.equals(ACTION_TALL)) {
            this.mobGrowTallAction(entity, key);
            return;
        }
        if (regrowthType.equals(ACTION_BOTH)) {
            regrowthType = entity.f_19853_.f_46441_.nextDouble() * 100.0 > 85.0 ? ACTION_GROW : ACTION_EAT;
        }
        if (regrowthType.contentEquals(ACTION_EAT)) {
            this.mobEatPlantsAction(entity, key, regrowthType);
            return;
        }
        if (regrowthType.equals(ACTION_GROW)) {
            this.mobGrowPlantsAction(entity, key);
            return;
        }
    }

    private boolean mobGrowCoralAction(Entity e, String key) {
        Level level = e.f_19853_;
        int sealevel = level.m_5736_();
        Random rand = level.m_5822_();
        this.moveRand.setSeed(e.m_146904_() * 1151 + e.m_146903_() * 51 + e.m_146907_() * 31);
        double docoralplant = this.moveRand.nextDouble();
        docoralplant = this.moveRand.nextDouble();
        double docoralfan = this.moveRand.nextDouble();
        int coralfanDirection = this.moveRand.nextInt(4);
        int minCoraldepth = sealevel - 4 + this.moveRand.nextInt(2);
        int maxCoraldepth = sealevel - 16;
        if (e.m_146904_() > minCoraldepth) {
            return false;
        }
        if (e.m_146904_() < maxCoraldepth) {
            return false;
        }
        BlockPos pos = e.m_142538_();
        if (level.m_8055_(pos.m_6625_(0)).m_60734_() != Blocks.f_49990_) {
            return false;
        }
        if (level.m_8055_(pos.m_6625_(1)).m_60734_() != Blocks.f_49990_) {
            return false;
        }
        if (level.m_8055_(pos.m_6625_(2)).m_60734_() instanceof CoralBlock) {
            MyConfig.debugMsg(2, pos, "Coral double:" + docoralplant);
            MyConfig.debugMsg(2, pos, "Coral fan double:" + docoralfan);
            MyConfig.debugMsg(2, pos, "Coral plant opportunity:" + e.m_6095_().getRegistryName().toString() + " .");
            if (docoralfan < 0.3) {
                Direction d = Direction.m_122407_((int)coralfanDirection);
                BlockPos fanPos = e.m_142538_().m_6625_(2).m_142300_(d);
                if (level.m_8055_(fanPos).m_60734_() == Blocks.f_49990_) {
                    level.m_46597_(fanPos, (BlockState)this.coralfans[rand.nextInt(this.coralfans.length)].m_49966_().m_61124_((Property)CoralWallFanBlock.f_49192_, (Comparable)d));
                }
            }
            int count = this.countCoral(e);
            MyConfig.debugMsg(2, pos, "CORAL count = :" + count + ", " + e.m_6095_().getRegistryName().toString() + " .");
            if (count > 5) {
                return false;
            }
            BlockState theCoralBlock = level.m_8055_(pos.m_6625_(2));
            if (count < 6 && e.m_146904_() == minCoraldepth) {
                if (docoralplant < 0.3) {
                    return false;
                }
                MyConfig.debugMsg(2, pos, "CORAL Plant grows over Coral Block:" + e.m_6095_().getRegistryName().toString() + " .");
                level.m_46597_(pos.m_6625_(1), this.coralPlants[rand.nextInt(this.coralPlants.length)].m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_12537_, SoundSource.AMBIENT, 0.9f, 1.4f);
                return true;
            }
            if (e.m_146904_() < minCoraldepth) {
                int ew = rand.nextInt(3) - 1;
                int ns = rand.nextInt(3) - 1;
                if (level.m_8055_(pos.m_6625_(1).m_142385_(ew).m_142390_(ns)).m_60734_() != Blocks.f_49990_) {
                    return false;
                }
                MyConfig.debugMsg(2, pos, "CORAL Block grows over Coral Block:" + e.m_6095_().getRegistryName().toString() + " .");
                level.m_46597_(pos.m_6625_(1).m_142385_(ew).m_142390_(ns), theCoralBlock);
                level.m_5594_(null, pos, SoundEvents.f_11756_, SoundSource.AMBIENT, 0.9f, 1.4f);
                MyConfig.debugMsg(2, pos, "CORAL:" + e.m_6095_().getRegistryName().toString() + " new block set at near " + pos.m_6625_(1) + " .");
            }
        }
        return true;
    }

    private int countCoral(Entity e) {
        int c = 0;
        for (int ud = -1; ud <= 0; ++ud) {
            for (int ew = -1; ew <= 1; ++ew) {
                for (int ns = -1; ns <= 1; ++ns) {
                    if (!(e.f_19853_.m_8055_(e.m_142538_().m_6625_(1).m_142385_(ew).m_142390_(ns)).m_60734_() instanceof CoralBlock)) continue;
                    ++c;
                }
            }
        }
        return c;
    }

    private boolean mobGrowPlantsAction(Entity entity, String key) {
        if (this.footBlockState.m_60795_()) {
            if (!(this.groundBlock instanceof BonemealableBlock)) {
                return false;
            }
            BlockPos bpos = entity.m_142538_();
            if (bpos == null) {
                MyConfig.debugMsg(1, "ERROR:" + key + "grow plant null position.");
                return false;
            }
            BonemealableBlock ib = (BonemealableBlock)this.groundBlock;
            MyConfig.debugMsg(1, entity.m_142538_(), key + " growable plant found.");
            try {
                ServerLevel serverworld = (ServerLevel)entity.f_19853_;
                BlockState bs = entity.f_19853_.m_8055_(bpos);
                ib.m_7719_(serverworld, entity.f_19853_.f_46441_, bpos, bs);
                MyConfig.debugMsg(1, bpos, key + " grew plant.");
            }
            catch (Exception e) {
                MyConfig.debugMsg(1, bpos, key + " caught grow attempt exception.");
            }
        }
        return true;
    }

    private boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!level.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private boolean isKindOfGrassBlock(BlockState groundBlockState) {
        if (groundBlockState.m_60734_() instanceof GrassBlock) {
            return true;
        }
        return groundBlockState.m_60734_().m_7705_().equals("block.byg.meadow_grass_block");
    }

    private boolean isBlockGrassOrDirt(BlockState tempBlockState) {
        return this.isKindOfGrassBlock(tempBlockState) || tempBlockState.m_60734_() == Blocks.f_50493_;
    }

    private BlockState helperSaplingState(Level world, BlockPos pos, Biome localBiome, BlockState sapling) {
        sapling = Blocks.f_50746_.m_49966_();
        ResourceKey k = Registry.f_122885_;
        String biomeName = world.m_5962_().m_175515_(k).m_7981_((Object)localBiome).toString();
        if (biomeName.contains("birch")) {
            sapling = Blocks.f_50748_.m_49966_();
        }
        if (biomeName.contains("taiga")) {
            sapling = Blocks.f_50747_.m_49966_();
        }
        if (biomeName.contains("jungle")) {
            sapling = Blocks.f_50749_.m_49966_();
        }
        if (biomeName.contains("savanna")) {
            sapling = Blocks.f_50750_.m_49966_();
        }
        if (biomeName.contains("desert")) {
            sapling = Blocks.f_50750_.m_49966_();
        }
        return sapling;
    }

    private void mobReforestAction(Entity entity, String key) {
        if (this.footBlock != Blocks.f_50016_) {
            return;
        }
        if (!this.isBlockGrassOrDirt(this.groundBlockState)) {
            return;
        }
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        double sinY = Math.sin((double)((ePos.m_123342_() + 64) % 256) / 256.0);
        if (entity.f_19853_.f_46441_.nextDouble() > Math.abs(sinY)) {
            return;
        }
        BlockState sapling = null;
        sapling = this.helperSaplingState(entity.f_19853_, ePos, this.localBiome, sapling);
        int hval = 5;
        int yval = 0;
        int yrange = 0;
        if (this.helperCountBlocksBB(SaplingBlock.class, 1, entity.f_19853_, ePos, hval, yrange) > 0) {
            return;
        }
        int leafCount = 0;
        yval = 4;
        yrange = 0;
        hval = 4;
        if (sapling == Blocks.f_50750_.m_49966_()) {
            yval = 5;
            hval = 7;
        }
        if ((leafCount = this.helperCountBlocksBB(LeavesBlock.class, 1, entity.f_19853_, ePos.m_6630_(yval), hval, yrange)) > 0) {
            return;
        }
        entity.f_19853_.m_46597_(ePos, sapling);
        MyConfig.debugMsg(1, ePos, key + " planted sapling.");
    }

    private void mobGrowMushroomAction(Entity entity, String key) {
        int huge;
        ServerLevel sWorld = (ServerLevel)entity.f_19853_;
        BlockPos ePos = entity.m_142538_();
        if (sWorld.m_8055_(ePos).m_60734_() instanceof MushroomBlock) {
            return;
        }
        if (sWorld.m_45527_(ePos)) {
            return;
        }
        if (!this.isGoodMushroomTemperature(entity)) {
            return;
        }
        Random mushRand = new Random(this.helperLongRandomSeed(entity.m_142538_()));
        double fertilityDouble = mushRand.nextDouble();
        fertilityDouble = mushRand.nextDouble();
        if (fertilityDouble < 0.75) {
            MyConfig.debugMsg(1, ePos, key + " Mushroom fertility (" + fertilityDouble + ") non-growing spot.");
            return;
        }
        int smallMushroomCount = this.helperCountBlocksBB(MushroomBlock.class, 4, (Level)sWorld, ePos, 4, 1);
        if (smallMushroomCount > 3) {
            MyConfig.debugMsg(1, ePos, key + " smallMushroomCount (" + smallMushroomCount + ") mushroom too crowded.");
            return;
        }
        if (this.groundBlock == Blocks.f_50181_) {
            sWorld.m_46597_(ePos, Blocks.f_50073_.m_49966_());
            return;
        }
        if (this.groundBlock == Blocks.f_50180_) {
            sWorld.m_46597_(ePos, Blocks.f_50072_.m_49966_());
            return;
        }
        int hugeMushroomCount = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (Level)sWorld, ePos, 1, 1);
        if (hugeMushroomCount <= 0 && (huge = this.helperCountBlocksBB(HugeMushroomBlock.class, 1, (Level)sWorld, ePos, MyConfig.getMushroomDensity(), 1)) > 0) {
            MyConfig.debugMsg(1, ePos, key + " huge (" + huge + ") mushroom too crowded.");
            return;
        }
        boolean growMushroom = false;
        if (BlockTags.f_13061_ == null) {
            MyConfig.debugMsg(0, "BlockTags.BASE_STONE_OVERWORLD missing.");
            if (this.groundBlock == Blocks.f_50069_ || this.groundBlock == Blocks.f_50228_ || this.groundBlock == Blocks.f_50334_ || this.groundBlock == Blocks.f_50122_) {
                growMushroom = true;
            }
        } else {
            if (!this.groundBlockState.m_60620_((Tag)BlockTags.f_13061_)) {
                return;
            }
            growMushroom = true;
        }
        if (sWorld.m_45914_((double)ePos.m_123341_(), (double)ePos.m_123342_(), (double)ePos.m_123343_(), 12.0)) {
            growMushroom = false;
        }
        if (growMushroom) {
            double vx = entity.m_20182_().m_7096_() - ((double)ePos.m_123341_() + 0.5);
            double vz = entity.m_20182_().m_7094_() - ((double)ePos.m_123343_() + 0.5);
            Vec3 vM = new Vec3(vx, 0.0, vz).m_82541_().m_82490_(1.0).m_82520_(0.0, 0.5, 0.0);
            entity.m_20256_(entity.m_20184_().m_82549_(vM));
            if (fertilityDouble > 0.9) {
                sWorld.m_46597_(ePos.m_7495_(), Blocks.f_50195_.m_49966_());
            }
            Block theBlock = null;
            theBlock = sWorld.f_46441_.nextDouble() * 100.0 > 75.0 ? Blocks.f_50073_ : Blocks.f_50072_;
            sWorld.m_46597_(ePos, theBlock.m_49966_());
            MushroomBlock mb = (MushroomBlock)theBlock;
            try {
                mb.m_54859_(sWorld, ePos, theBlock.m_49966_(), sWorld.f_46441_);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (theBlock == Blocks.f_50073_) {
                for (int y = 9; y > 3; --y) {
                    Block b = sWorld.m_8055_(ePos.m_6630_(y)).m_60734_();
                    if (b != Blocks.f_50182_) continue;
                    sWorld.m_46597_(ePos.m_6630_(y), Blocks.f_50701_.m_49966_());
                    break;
                }
            }
            MyConfig.debugMsg(1, ePos, key + " grow mushroom.");
        }
    }

    private long helperLongRandomSeed(BlockPos ePos) {
        return (long)Math.abs(ePos.m_123341_() * 31) + (long)Math.abs(ePos.m_123343_() * 11) + (long)Math.abs(ePos.m_123342_() * 7);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boundY) {
        return this.helperCountBlocksOrthogonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public int helperCountBlocksOrthogonalBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.m_8055_(bPos.m_6630_(j).m_142126_()).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142125_()).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142127_()).m_60734_() == searchBlock) {
                ++count;
            }
            if (w.m_8055_(bPos.m_6630_(j).m_142128_()).m_60734_() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, boxSize);
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.m_123341_() - boxSize;
        int maxX = bPos.m_123341_() + boxSize;
        int minZ = bPos.m_123343_() - boxSize;
        int maxZ = bPos.m_123343_() + boxSize;
        int minY = bPos.m_123342_() - ySize;
        int maxY = bPos.m_123342_() + ySize;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.m_122178_(dx, dy, dz);
                    if (w.m_8055_((BlockPos)mPos).m_60734_() != searchBlock || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getRegistryName().toString() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, 0);
    }

    public int helperCountBlocksBB(Class<? extends Block> searchBlock, int maxCount, Level w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.m_123341_() - boxSize;
        int maxX = bPos.m_123341_() + boxSize;
        int minZ = bPos.m_123343_() - boxSize;
        int maxZ = bPos.m_123343_() + boxSize;
        int minY = bPos.m_123342_() - ySize;
        int maxY = bPos.m_123342_() + ySize;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    mPos.m_122178_(dx, dy, dz);
                    if (!searchBlock.isInstance(w.m_8055_((BlockPos)mPos).m_60734_()) || ++count < maxCount) continue;
                    return count;
                }
            }
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getSimpleName() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    private boolean isGoodMushroomTemperature(Entity entity) {
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        float biomeTemp = entity.f_19853_.m_46857_(ePos).m_47554_();
        MyConfig.debugMsg(1, ePos, "Mushroom Biome temp: " + biomeTemp + ".");
        if ((double)biomeTemp < MyConfig.getMushroomMinTemp()) {
            return false;
        }
        return !((double)biomeTemp > MyConfig.getMushroomMaxTemp());
    }

    private boolean mobEatPlantsAction(Entity entity, String key, String regrowthType) {
        if (this.mobEatGrassOrFlower(entity, regrowthType)) {
            MyConfig.debugMsg(1, this.getAdjustedBlockPos(entity), key + " ate plants.");
            return true;
        }
        return false;
    }

    private boolean isHorseTypeEatingNow(Entity entity) {
        AbstractHorse h;
        return entity instanceof AbstractHorse && (h = (AbstractHorse)entity).m_30617_();
    }

    private void mobStumbleAction(Entity entity, String key) {
        entity.f_19853_.m_46961_(this.getAdjustedBlockPos(entity), true);
        MyConfig.debugMsg(1, this.getAdjustedBlockPos(entity), key + " stumbled over torch.");
    }

    private void doVillagerRegrowthEvents(Villager ve, String debugKey, String regrowthActions) {
        if (!ve.m_20096_()) {
            return;
        }
        if (this.groundBlockState.m_60734_() instanceof TorchBlock) {
            return;
        }
        if (this.groundBlockState.m_60734_() instanceof WallTorchBlock) {
            return;
        }
        if (MyConfig.aDebugLevel > 0) {
            TextComponent tName = new TextComponent("");
            float veYaw = ve.m_5675_(1.0f);
            tName = new TextComponent("Reg-" + ve.m_20185_() + "," + ve.m_20189_() + ": " + veYaw);
            ve.m_6593_((Component)tName);
        } else if (ve.m_7770_() != null && ve.m_7770_().toString().contains("Reg-")) {
            ve.m_6593_(null);
        }
        if (this.vImproveFarm(ve, regrowthActions)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugKey + " farm improved.");
        }
        if (regrowthActions.contains("h")) {
            this.vClericalHealing(ve);
            this.vToolMasterHealing(ve);
        }
        this.vBeeKeeperFlowers(ve);
        if (regrowthActions.contains("v")) {
            this.vImproveLeaves(ve, debugKey);
        }
        if (regrowthActions.contains("c") && (this.footBlock instanceof TallGrassBlock || this.footBlock instanceof DoublePlantBlock || this.footBlock.m_7705_().equals("block.byg.short_grass"))) {
            ve.f_19853_.m_46961_(ve.m_142538_(), false);
            MyConfig.debugMsg(1, ve.m_142538_(), debugKey + " grass cut.");
        }
        if (regrowthActions.contains("r")) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugKey + " try road improve.");
            this.vImproveRoads(ve, debugKey);
        }
        if (regrowthActions.contains("w")) {
            MyConfig.debugMsg(1, ve.m_142538_(), " try town wall build.");
            this.vImproveWalls(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("p")) {
            MyConfig.debugMsg(1, ve.m_142538_(), " try personal fence build.");
            this.vImproveFences(ve, debugKey, regrowthActions);
        }
        if (regrowthActions.contains("t") && this.footBlock != Blocks.f_50081_ && this.vImproveLighting(ve)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugKey + "-" + this.footBlock + ", " + this.groundBlock + " pitch: " + ve.m_146909_() + " lighting improved.");
        }
    }

    private void helperJumpAway(Entity e) {
        Block postActionFootBlock = this.getAdjustedFootBlockState(e).m_60734_();
        if (postActionFootBlock == Blocks.f_152481_) {
            e.m_20334_(0.0, 0.33, 0.0);
            return;
        }
        if (postActionFootBlock instanceof WallBlock || postActionFootBlock instanceof FenceBlock) {
            float veYaw = e.m_5675_(1.0f) / 45.0f;
            int facingNdx = Math.round(veYaw);
            if (facingNdx < 0) {
                facingNdx = Math.abs(facingNdx);
            }
            double dx = (double)this.facingArray[facingNdx %= 8][0] / 2.0;
            double dz = (double)this.facingArray[facingNdx][1] / 2.0;
            e.m_20334_(dx, 0.55, dz);
        }
    }

    private boolean mobEatGrassOrFlower(Entity entity, String regrowthType) {
        BlockPos ePos = this.getAdjustedBlockPos(entity);
        if (!this.isGrassOrFlower(this.footBlockState)) {
            return false;
        }
        if (this.isKindOfGrassBlock(this.groundBlockState)) {
            this.mobTrodGrassBlock(entity);
        }
        entity.f_19853_.m_46961_(ePos, false);
        LivingEntity le = (LivingEntity)entity;
        this.helperChildAgeEntity(entity);
        if (le.m_21233_() > le.m_21223_() && MyConfig.aEatingHeals == 1.0) {
            MobEffectInstance ei = new MobEffectInstance(MobEffects.f_19601_, 1, 0, false, true);
            le.m_7292_(ei);
        }
        return true;
    }

    private void mobTrodGrassBlock(Entity e) {
        BlockPos ePos = new BlockPos(e.m_20185_(), e.m_20186_(), e.m_20189_());
        Level level = e.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel varLevel = (ServerLevel)level;
            AABB aabb = new AABB(ePos.m_142385_(2).m_6630_(2).m_142390_(2), ePos.m_142386_(2).m_6625_(2).m_142383_(2));
            ArrayList l = new ArrayList();
            varLevel.m_142646_().m_142137_((EntityTypeTest)e.m_6095_(), aabb, entity -> l.add(entity));
            if (l.size() >= 9) {
                varLevel.m_46597_(ePos.m_7495_(), Blocks.f_152481_.m_49966_());
                e.m_6469_(DamageSource.f_19310_, 0.25f);
            }
        }
    }

    private boolean isBlockGrassPathOrDirt(Block tempBlock) {
        return tempBlock == Blocks.f_152481_ || tempBlock == Blocks.f_50493_;
    }

    private void helperChildAgeEntity(Entity ent) {
        AgeableMob aEnt;
        if (ent instanceof AgeableMob && (aEnt = (AgeableMob)ent).m_6162_()) {
            aEnt.m_146762_(aEnt.m_146764_() + 30);
        }
    }

    private boolean mobGrowTallAction(Entity ent, String key) {
        if (this.footBlock instanceof TallGrassBlock && this.footBlock instanceof BonemealableBlock) {
            BlockPos ePos = this.getAdjustedBlockPos(ent);
            if (this.footBlock.getRegistryName().m_135827_() != "byg") {
                try {
                    BonemealableBlock ib = (BonemealableBlock)this.footBlock;
                    ib.m_7719_((ServerLevel)ent.f_19853_, ent.f_19853_.f_46441_, ePos, ent.f_19853_.m_8055_(ePos));
                    MyConfig.debugMsg(1, ePos, key + " grew and hid in tall plant.");
                    return false;
                }
                catch (Exception e) {
                    MyConfig.debugMsg(1, ePos, key + " caught grow attempt exception.");
                    return false;
                }
            }
        }
        return false;
    }

    private BlockState helperBiomeRoadBlockType(Biome localBiome) {
        BlockState gateBlockType = Blocks.f_152481_.m_49966_();
        if (this.biomeCategory == Biome.BiomeCategory.DESERT) {
            gateBlockType = Blocks.f_50744_.m_49966_();
        }
        return gateBlockType;
    }

    private boolean vImproveFarm(Villager ve, String regrowthType) {
        if (ve.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
            return false;
        }
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        Block groundBlock = this.groundBlockState.m_60734_();
        Block footBlock = this.footBlockState.m_60734_();
        if (this.helperCountBlocksOrthogonalBB(Blocks.f_50093_, 1, ve.f_19853_, vePos.m_6625_(1), 0) > 0) {
            if (this.isNearWater((LevelReader)ve.f_19853_, vePos.m_6625_(1)) && groundBlock instanceof GrassBlock) {
                ve.f_19853_.m_46597_(vePos.m_7495_(), Blocks.f_50093_.m_49966_());
                return true;
            }
            if (!regrowthType.contains("t") || footBlock != Blocks.f_50016_) {
                return false;
            }
            if (ve.f_19853_.m_45517_(LightLayer.BLOCK, vePos) > 12) {
                return false;
            }
            int veX = vePos.m_123341_();
            int veY = vePos.m_123342_();
            int veZ = vePos.m_123343_();
            if (this.lastTorchX == veX && this.lastTorchY == veY && this.lastTorchZ == veZ) {
                return false;
            }
            int waterValue = this.helperCountBlocksOrthogonalBB(Blocks.f_49990_, 1, ve.f_19853_, vePos.m_7495_(), 0);
            if (waterValue > 0 && this.groundBlockState.m_60620_((Tag)BlockTags.f_13106_) || groundBlock == Blocks.f_50471_) {
                ve.f_19853_.m_7731_(vePos, Blocks.f_50081_.m_49966_(), 3);
                this.lastTorchX = veX;
                this.lastTorchY = veY;
                this.lastTorchZ = veZ;
                return true;
            }
        }
        return false;
    }

    private void vBeeKeeperFlowers(Villager ve) {
        if (!ve.m_7141_().m_35571_().m_150028_().contains("beekeeper")) {
            return;
        }
        if (ve.m_20185_() % 6.0 == 0.0 && ve.m_20189_() % 7.0 == 0.0 && this.isBlockGrassOrDirt(this.groundBlockState) && this.helperCountBlocksOrthogonalBB(Blocks.f_152481_, 1, ve.f_19853_, ve.m_142538_().m_7495_(), 0) == 1) {
            BlockState flowerBlockState = Blocks.f_50115_.m_49966_();
            ve.f_19853_.m_46597_(this.adjustedPos, flowerBlockState);
        }
    }

    private void vToolMasterHealing(Villager ve) {
        if (ve.m_7141_().m_35571_() != VillagerProfession.f_35598_) {
            return;
        }
        long daytime = ve.f_19853_.m_46468_() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        Level level = ve.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel varW = (ServerLevel)level;
            int villagerLevel = ve.m_7141_().m_35576_();
            if (villagerLevel < 1) {
                return;
            }
            BlockPos vePos = new BlockPos(ve.m_20185_(), ve.m_20186_() + 0.99, ve.m_20189_());
            AABB aabb = new AABB(vePos.m_142385_(6).m_6630_(3).m_142390_(6), vePos.m_142386_(6).m_6625_(2).m_142383_(6));
            ArrayList l = new ArrayList();
            varW.m_142646_().m_142232_(aabb, entity -> {
                if (entity instanceof IronGolem) {
                    l.add(entity);
                }
            });
            for (Entity e : l) {
                boolean heal = true;
                LivingEntity le = (LivingEntity)e;
                if (!(le.m_21223_() < le.m_21233_()) || !heal) continue;
                le.m_147207_(new MobEffectInstance(MobEffects.f_19605_, villagerLevel * 51, 0), (Entity)ve);
                ve.m_147207_(new MobEffectInstance(MobEffects.f_19605_, villagerLevel * 11, 0), (Entity)ve);
                ve.f_19853_.m_5594_(null, vePos, SoundEvents.f_12574_, SoundSource.NEUTRAL, 0.5f, 0.5f);
                return;
            }
        }
    }

    private void vClericalHealing(Villager ve) {
        if (ve.m_7141_().m_35571_() != VillagerProfession.f_35589_) {
            return;
        }
        long daytime = ve.f_19853_.m_46468_() % 24000L;
        if (daytime < 9000L || daytime > 11000L) {
            return;
        }
        Level level = ve.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel varW = (ServerLevel)level;
            int clericalLevel = ve.m_7141_().m_35576_();
            BlockPos vePos = new BlockPos(ve.m_20185_(), ve.m_20186_() + 0.99, ve.m_20189_());
            AABB aabb = new AABB(vePos.m_142385_(4).m_6630_(2).m_142390_(4), vePos.m_142386_(4).m_6625_(2).m_142383_(4));
            ArrayList l = new ArrayList();
            varW.m_142646_().m_142232_(aabb, entity -> {
                if (entity instanceof Villager || entity instanceof Player) {
                    l.add(entity);
                }
            });
            for (Entity e : l) {
                Player pe;
                int rep;
                boolean heal = true;
                LivingEntity le = (LivingEntity)e;
                if (!(le.m_21223_() < le.m_21233_())) continue;
                if (e instanceof Player && (rep = ve.m_35532_(pe = (Player)e)) < 0) {
                    heal = false;
                }
                if (!heal) continue;
                le.m_147207_(new MobEffectInstance(MobEffects.f_19605_, clericalLevel * 51, 0), (Entity)ve);
                ve.f_19853_.m_5594_(null, vePos, SoundEvents.f_144050_, SoundSource.NEUTRAL, 1.2f, 1.52f);
                return;
            }
        }
    }

    private void vImproveLeaves(Villager ve, String key) {
        float veYaw = ve.m_5675_(1.0f) / 45.0f;
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        int dx = this.facingArray[facingNdx %= 8][0];
        int dz = this.facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        BlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new BlockPos(vePos.m_123341_() + dx, vePos.m_123342_() + iY, vePos.m_123343_() + dz);
            tempBS = ve.f_19853_.m_8055_(tmpBP);
            tempBlock = tempBS.m_60734_();
            if (tempBlock instanceof LeavesBlock && !(persistantLeaves = ((Boolean)tempBS.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof CactusBlock) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.f_19853_.m_46961_(tmpBP, false);
            destroyBlock = false;
            MyConfig.debugMsg(1, vePos, key + " cleared " + tempBlock.m_7705_().toString());
        }
    }

    private boolean vImproveLighting(Villager ve) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        int blockLightValue = ve.f_19853_.m_45517_(LightLayer.BLOCK, vePos);
        int skyLightValue = ve.f_19853_.m_45517_(LightLayer.SKY, vePos);
        if (blockLightValue > MyConfig.getTorchLightLevel()) {
            return false;
        }
        if (skyLightValue > 13) {
            return false;
        }
        if (ve.m_5803_()) {
            return false;
        }
        if (this.footBlockState.m_60734_() instanceof BedBlock) {
            return false;
        }
        if (this.isValidGroundBlockToPlaceTorchOn(ve) && this.footBlockState.m_60795_()) {
            ve.f_19853_.m_7731_(vePos, Blocks.f_50081_.m_49966_(), 3);
        }
        return true;
    }

    private void vImproveRoads(Villager ve, String debugkey) {
        this.isRoadPiece = false;
        if (this.vImproveRoadsClearSnow((Entity)ve)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugkey + " clear snow on road.");
        }
        if (this.vImproveRoadsFixPatches((Entity)ve)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugkey + " fix patches on road.");
        }
        if (this.vImproveRoadsFixPotholes((Entity)ve)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugkey + " fix potholes in road.");
        }
        if (this.vImproveRoadsSmoothHeight(ve)) {
            MyConfig.debugMsg(1, ve.m_142538_(), debugkey + " Smooth road slope.");
        }
    }

    private boolean vImproveRoadsClearSnow(Entity e) {
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(this.localBiome).m_60734_();
        if (this.groundBlock != biomeRoadBlock) {
            return false;
        }
        if (this.footBlock instanceof SnowLayerBlock) {
            e.f_19853_.m_46961_(this.adjustedPos, false);
            this.footBlockState = Blocks.f_50016_.m_49966_();
            this.footBlock = this.footBlockState.m_60734_();
            return true;
        }
        return false;
    }

    private boolean vImproveRoadsFixPatches(Entity e) {
        if (!e.f_19853_.m_45527_(e.m_142538_())) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(this.localBiome).m_60734_();
        if (this.groundBlock == biomeRoadBlock) {
            return false;
        }
        int roadY = 0;
        int roadBlocks = 0;
        BlockPos vePos = this.getAdjustedBlockPos(e);
        for (int i = 0; i < 4; ++i) {
            roadY = e.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, vePos.m_123341_() + this.dx[i], vePos.m_123343_() + this.dz[i]) - 1;
            Block tempBlock = e.f_19853_.m_8055_(new BlockPos(vePos.m_123341_() + this.dx[i], roadY, vePos.m_123343_() + this.dz[i])).m_60734_();
            if (tempBlock != biomeRoadBlock || ++roadBlocks < 3) continue;
            if (this.footBlock instanceof SnowLayerBlock) {
                e.f_19853_.m_46961_(this.adjustedPos, false);
                this.footBlockState = Blocks.f_50016_.m_49966_();
                this.footBlock = this.footBlockState.m_60734_();
            }
            e.f_19853_.m_46597_(this.adjustedPos.m_7495_(), biomeRoadBlock.m_49966_());
            return true;
        }
        return false;
    }

    private boolean vImproveRoadsFixPotholes(Entity e) {
        if (!e.f_19853_.m_45527_(e.m_142538_())) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(this.localBiome).m_60734_();
        if (this.groundBlock == biomeRoadBlock && this.footBlock instanceof SnowLayerBlock) {
            e.f_19853_.m_46961_(this.getAdjustedBlockPos(e), false);
        }
        BlockPos vePos = e.m_142538_();
        int veX = vePos.m_123341_();
        int veY = vePos.m_123342_();
        int veZ = vePos.m_123343_();
        int roadY = 0;
        int higherRoadBlocks = 0;
        for (int i = 0; i < 4; ++i) {
            roadY = e.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, veX + this.dx[i], veZ + this.dz[i]) - 1;
            Block tempBlock = e.f_19853_.m_8055_(new BlockPos(veX + this.dx[i], roadY, veZ + this.dz[i])).m_60734_();
            if (tempBlock != biomeRoadBlock || roadY <= veY) continue;
            ++higherRoadBlocks;
        }
        if (higherRoadBlocks == 4) {
            e.f_19853_.m_46597_(this.adjustedPos, biomeRoadBlock.m_49966_());
            return true;
        }
        return false;
    }

    private boolean vImproveRoadsSmoothHeight(Villager ve) {
        if (!ve.m_20096_()) {
            return false;
        }
        if (ve.m_6162_()) {
            return false;
        }
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        if (!ve.f_19853_.m_45527_(ve.m_142538_())) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(this.localBiome).m_60734_();
        if (biomeRoadBlock == Blocks.f_50471_ && !this.isRoadPiece) {
            return false;
        }
        if (this.groundBlockState.m_60734_() != biomeRoadBlock && this.footBlockState.m_60734_() != biomeRoadBlock) {
            return false;
        }
        BlockState biomeRoadBlockState = biomeRoadBlock.m_49966_();
        int poiDistance = 3;
        if (this.biomeCategory == Biome.BiomeCategory.DESERT) {
            poiDistance = 7;
        }
        if (this.isNearbyPoi(ve, this.localBiome, vePos, poiDistance)) {
            return false;
        }
        int veX = vePos.m_123341_();
        int veY = vePos.m_123342_();
        int veZ = vePos.m_123343_();
        int roadY = 0;
        for (int i = 0; i < 4; ++i) {
            Block tempBlock;
            roadY = ve.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, veX + this.dx[i], veZ + this.dz[i]) - 1;
            if (roadY <= veY || (tempBlock = ve.f_19853_.m_8055_(new BlockPos(veX + this.dx[i], roadY, veZ + this.dz[i])).m_60734_()) != biomeRoadBlock) continue;
            ve.f_19853_.m_46597_(new BlockPos(veX, veY, veZ), biomeRoadBlockState);
            ve.m_20334_(0.0, 0.4, 0.0);
            return true;
        }
        return false;
    }

    private boolean isNearbyPoi(Villager ve, Biome localBiome, BlockPos vePos, int poiDistance) {
        Collection result = ((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> true, ve.m_142538_(), poiDistance, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new));
        if (!result.isEmpty()) {
            for (PoiRecord P : result) {
                int disX = Math.abs(ve.m_142538_().m_123341_() - P.m_27257_().m_123341_());
                int disZ = Math.abs(ve.m_142538_().m_123343_() - P.m_27257_().m_123343_());
                if (disX >= poiDistance || disZ >= poiDistance) continue;
                MyConfig.debugMsg(1, vePos, "Point of Interest too Close: " + P.m_27258_().toString() + ".");
                return true;
            }
        }
        return false;
    }

    private boolean vImproveVillageWall(Villager ve, String regrowthActions) {
        if (!ve.m_6274_().m_21952_(MemoryModuleType.f_26362_).isPresent()) {
            return false;
        }
        if (!this.isOkayToBuildWallHere(ve)) {
            return false;
        }
        BlockPos gVMPPos = ((GlobalPos)ve.m_6274_().m_21952_(MemoryModuleType.f_26362_).get()).m_122646_();
        if (MyConfig.playerWallControlBlock != Blocks.f_50016_) {
            if (ve.f_19853_.m_46745_(gVMPPos).m_6319_() < 200L) {
                ve.f_19853_.m_7731_(gVMPPos.m_6630_(1), MyConfig.playerWallControlBlock.m_49966_(), 3);
            }
            if (ve.f_19853_.m_8055_(gVMPPos.m_6630_(1)).m_60734_() != MyConfig.playerWallControlBlock) {
                return false;
            }
        }
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + this.biomeCategory.toString();
        key = ((String)key).toLowerCase();
        MyConfig.debugMsg(2, vePos, (String)key + " wall improvement.");
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)key);
        MyConfig.debugMsg(1, vePos, (String)key + " biome for wall improvement. ");
        int wallRadius = currentWallBiomeDataItem.getWallDiameter();
        wallRadius = wallRadius / 2 - 1;
        if (this.isOnWallPerimeter((Entity)ve, wallRadius, gVMPPos)) {
            MyConfig.debugMsg(2, ve.m_142538_(), "villager on wall perimeter: " + wallRadius);
            Collection result = ((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> t == PoiType.f_27347_, ve.m_142538_(), 41, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (PoiRecord P : result) {
                    if (gVMPPos.m_123341_() == P.m_27257_().m_123341_() && gVMPPos.m_123342_() == P.m_27257_().m_123342_() && gVMPPos.m_123343_() == P.m_27257_().m_123343_()) continue;
                    int disX = Math.abs(ve.m_142538_().m_123341_() - P.m_27257_().m_123341_());
                    int disZ = Math.abs(ve.m_142538_().m_123343_() - P.m_27257_().m_123343_());
                    if (disX >= wallRadius || disZ >= wallRadius) continue;
                    buildWall = false;
                    break;
                }
            }
            if (buildWall) {
                BlockState wallTypeBlockState;
                BlockState wallBlock = wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState();
                int wallTorchSpacing = (wallRadius + 1) / 4;
                BlockState gateBlockType = this.helperBiomeRoadBlockType(this.localBiome);
                if (this.helperPlaceOneWallPiece((Entity)ve, wallRadius, wallTorchSpacing, gateBlockType, wallBlock, gVMPPos)) {
                    int absvz;
                    int absvx;
                    if (regrowthActions.contains("t") && this.isValidTorchLocation(wallRadius, wallTorchSpacing, absvx = (int)Math.abs(ve.m_20185_() - (double)gVMPPos.m_123341_()), absvz = (int)Math.abs(ve.m_20189_() - (double)gVMPPos.m_123343_()), ve.f_19853_.m_8055_(vePos).m_60734_())) {
                        ve.f_19853_.m_46597_(vePos.m_7494_(), Blocks.f_50081_.m_49966_());
                    }
                    this.helperJumpAway((Entity)ve);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean vImproveHomeFence(Villager ve, BlockPos vHomePos, String regrowthActions) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + this.biomeCategory.toString();
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem == null && (currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = "minecraft:" + this.biomeCategory.toString().toLowerCase()))) == null) {
            currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
        }
        int homeFenceDiameter = currentWallBiomeDataItem.getWallDiameter();
        int wallTorchSpacing = (homeFenceDiameter /= 4) / 4;
        homeFenceDiameter = homeFenceDiameter / 2 - 1;
        int absvx = (int)Math.abs(ve.m_20185_() - (double)vHomePos.m_123341_());
        int absvz = (int)Math.abs(ve.m_20189_() - (double)vHomePos.m_123343_());
        Collection result = ((ServerLevel)ve.f_19853_).m_8904_().m_27166_(t -> t == PoiType.f_27346_, vePos, 17, PoiManager.Occupancy.ANY).collect(Collectors.toCollection(ArrayList::new));
        boolean buildFence = true;
        if (!result.isEmpty()) {
            for (PoiRecord P : result) {
                if (vHomePos.m_123341_() == P.m_27257_().m_123341_() && vHomePos.m_123342_() == P.m_27257_().m_123342_() && vHomePos.m_123343_() == P.m_27257_().m_123343_()) continue;
                int disX = Math.abs(vePos.m_123341_() - P.m_27257_().m_123341_());
                int disZ = Math.abs(vePos.m_123343_() - P.m_27257_().m_123343_());
                MyConfig.debugMsg(1, P.m_27257_(), "extra Point of Interest Found.");
                if (disX >= homeFenceDiameter || disZ >= homeFenceDiameter) continue;
                buildFence = false;
                break;
            }
        } else if (result.isEmpty()) {
            buildFence = true;
        }
        if (buildFence) {
            BlockState fenceBlockState = currentWallBiomeDataItem.getFenceBlockState();
            BlockState gateBlockType = this.helperBiomeRoadBlockType(this.localBiome);
            if (this.helperPlaceOneWallPiece((Entity)ve, homeFenceDiameter, wallTorchSpacing, gateBlockType, fenceBlockState, vHomePos)) {
                if (regrowthActions.contains("t") && this.isValidTorchLocation(homeFenceDiameter, wallTorchSpacing, absvx, absvz, ve.f_19853_.m_8055_(vePos).m_60734_())) {
                    ve.f_19853_.m_46597_(vePos.m_7494_(), Blocks.f_50081_.m_49966_());
                }
                this.helperJumpAway((Entity)ve);
                return true;
            }
        }
        return false;
    }

    private void vImproveWalls(Villager ve, String key, String regrowthType) {
        if (this.groundBlockState.m_60795_()) {
            return;
        }
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        if (!ve.m_6274_().m_21952_(MemoryModuleType.f_26362_).isPresent()) {
            return;
        }
        MyConfig.debugMsg(1, vePos, "Checking Improve Wall.");
        if (this.vImproveVillageWall(ve, regrowthType)) {
            MyConfig.debugMsg(1, vePos, "Meeting Wall Improved.");
        }
    }

    private void vImproveFences(Villager ve, String key, String regrowthType) {
        BlockPos ePos = ve.m_142538_();
        Brain vb = ve.m_6274_();
        Optional vMeetingPlace = vb.m_21952_(MemoryModuleType.f_26362_);
        if (!vMeetingPlace.isPresent()) {
            return;
        }
        if (this.isOkayToBuildWallHere(ve)) {
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos villageMeetingPlaceBlockPos = gVMP.m_122646_();
            if (!(ve.f_19853_.m_8055_(villageMeetingPlaceBlockPos.m_6630_(1)).m_60734_() instanceof WallBlock)) {
                return;
            }
            if (regrowthType.contains("p")) {
                MyConfig.debugMsg(1, ePos, "Checking Improve Fence.");
                Optional villagerHome = vb.m_21952_(MemoryModuleType.f_26359_);
                if (!villagerHome.isPresent()) {
                    return;
                }
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.m_122646_();
                if (this.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((GlobalPos)vMeetingPlace.get()).m_122646_(), this.localBiome)) {
                    MyConfig.debugMsg(1, ePos, "Outside meeting place wall.");
                    if (this.vImproveHomeFence(ve, villagerHomePos, regrowthType)) {
                        MyConfig.debugMsg(1, ePos, "Home Fence Improved.");
                    }
                }
            }
        }
    }

    private boolean isFootBlockOkayToBuildIn(BlockState footBlockState) {
        if (footBlockState.m_60795_() || this.isGrassOrFlower(footBlockState)) {
            return true;
        }
        return footBlockState.m_60734_() instanceof SnowLayerBlock;
    }

    private boolean isGrassOrFlower(BlockState footBlockState) {
        Block footBlock;
        block11: {
            footBlock = footBlockState.m_60734_();
            if (footBlock instanceof TallGrassBlock) {
                return true;
            }
            if (footBlock instanceof FlowerBlock) {
                return true;
            }
            if (footBlock instanceof DoublePlantBlock) {
                return true;
            }
            if (footBlock == Blocks.f_50035_) {
                return true;
            }
            if (footBlock == Blocks.f_50360_) {
                return true;
            }
            try {
                if (footBlockState.m_60620_((Tag)BlockTags.f_13041_)) {
                    return true;
                }
                if (footBlockState.m_60620_((Tag)BlockTags.f_13040_)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (MyConfig.aDebugLevel <= 0) break block11;
                System.out.println("Tag Exception 1009-1014:" + footBlock.m_7705_() + ".");
            }
        }
        if (footBlock.m_7705_().equals("block.byg.short_grass")) {
            return true;
        }
        if (MyConfig.aDebugLevel > 0) {
            System.out.println("Not grass or Flower:" + footBlock.m_7705_() + ".");
        }
        return false;
    }

    private boolean isImpossibleRegrowthEvent(String regrowthType) {
        if (regrowthType.equals(ACTION_EAT) && this.footBlockState.m_60795_()) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && this.footBlockState.m_60734_() instanceof TallGrassBlock) {
            return true;
        }
        if (regrowthType.equals(ACTION_GROW) && this.footBlockState.m_60734_() instanceof FlowerBlock) {
            return true;
        }
        return regrowthType.equals(ACTION_TALL) && !(this.footBlockState.m_60734_() instanceof TallGrassBlock);
    }

    private boolean isOkayToBuildWallHere(Villager ve) {
        boolean okayToBuildWalls = true;
        if (!this.isOnGround((Entity)ve)) {
            okayToBuildWalls = false;
        }
        if (!this.isFootBlockOkayToBuildIn(this.footBlockState)) {
            okayToBuildWalls = false;
        }
        if (!this.isValidGroundBlockToBuildWallOn((Entity)ve)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private boolean isOnGround(Entity e) {
        return e.m_20096_();
    }

    private boolean isOnWallPerimeter(Entity e, int wallRadius, BlockPos gVMPPos) {
        boolean onPerimeter = false;
        int absvx = (int)Math.abs(e.m_20185_() - (double)gVMPPos.m_123341_());
        int absvz = (int)Math.abs(e.m_20189_() - (double)gVMPPos.m_123343_());
        if (absvx == wallRadius && absvz <= wallRadius) {
            onPerimeter = true;
        }
        if (absvz == wallRadius && absvx <= wallRadius) {
            onPerimeter = true;
        }
        return onPerimeter;
    }

    private boolean isOutsideMeetingPlaceWall(Villager ve, Optional<GlobalPos> vMeetingPlace, BlockPos meetingPlacePos, Biome localBiome) {
        BlockPos vePos = this.getAdjustedBlockPos((Entity)ve);
        Object key = "minecraft:" + Utility.getBiomeCategory(localBiome).toString();
        int wallDiameter = 64;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem((String)(key = ((String)key).toLowerCase()));
        if (currentWallBiomeDataItem != null) {
            wallDiameter = currentWallBiomeDataItem.getWallDiameter();
        }
        wallDiameter = wallDiameter / 2 - 1;
        int absVMpX = Math.abs(vePos.m_123341_() - meetingPlacePos.m_123341_());
        int absVMpZ = Math.abs(vePos.m_123343_() - meetingPlacePos.m_123343_());
        if (absVMpX > wallDiameter + 1) {
            return true;
        }
        return absVMpZ > wallDiameter + 1;
    }

    private boolean isValidGroundBlockToPlaceTorchOn(Villager ve) {
        String key = this.groundBlockState.m_60734_().getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidGroundBlockToBuildWallOn(Entity e) {
        if (e.f_19853_.m_45517_(LightLayer.SKY, e.m_142538_()) < 13) {
            return false;
        }
        if (this.groundBlock instanceof SnowLayerBlock) {
            return false;
        }
        if (this.groundBlock instanceof TorchBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_7494_()).m_60734_() instanceof WallBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_7495_()).m_60734_() instanceof WallBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_6625_(1)).m_60734_() instanceof WallBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_6625_(2)).m_60734_() instanceof TorchBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_7494_()).m_60734_() instanceof TorchBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_7495_()).m_60734_() instanceof TorchBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_6625_(1)).m_60734_() instanceof TorchBlock) {
            return false;
        }
        if (e.f_19853_.m_8055_(e.m_142538_().m_6625_(2)).m_60734_() instanceof TorchBlock) {
            return false;
        }
        this.groundBlock = this.groundBlockState.m_60734_();
        MyConfig.debugMsg(1, e.m_142538_(), "Build Wall : gb" + this.groundBlock.toString() + ", fb:" + this.footBlock.toString());
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(this.groundBlock.getRegistryName().toString());
        return currentWallFoundationItem != null;
    }

    private boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof WallBlock) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof FenceBlock) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean helperPlaceOneWallPiece(Entity e, int wallPerimeter, int wallTorchSpacing, BlockState gateBlockType, BlockState wallType, BlockPos gVMPPos) {
        int absvx = (int)Math.abs(e.m_20185_() - (double)gVMPPos.m_123341_());
        int absvz = (int)Math.abs(e.m_20189_() - (double)gVMPPos.m_123343_());
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            return this.helperPlaceWallPiece(e, gateBlockType, wallType, absvz);
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            return this.helperPlaceWallPiece(e, gateBlockType, wallType, absvx);
        }
        return false;
    }

    private boolean helperPlaceWallPiece(Entity e, BlockState gateBlockType, BlockState wallType, int absva) {
        BlockPos vePos = this.getAdjustedBlockPos(e);
        if (this.footBlock instanceof SnowLayerBlock) {
            e.f_19853_.m_46961_(vePos, false);
        }
        if (this.footBlock instanceof SaplingBlock || this.footBlock instanceof TallGrassBlock || this.footBlock instanceof FlowerBlock || this.footBlock instanceof DoublePlantBlock) {
            e.f_19853_.m_46961_(vePos, true);
        }
        if (absva == 0) {
            e.f_19853_.m_46597_(vePos.m_7495_(), gateBlockType);
            return true;
        }
        if (e.f_19853_.m_46597_(vePos, wallType)) {
            return true;
        }
        MyConfig.debugMsg(1, e.m_142538_(), "Building Wall Fail: SetBlockAndUpdate Time End = " + e.f_19853_.m_46467_());
        return false;
    }
}

