/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class WallBiomeDataManager {
    private static Hashtable<String, WallBiomeDataItem> wallBiomeDataHashtable = new Hashtable();
    private static String defaultRegrowthMobString;
    private static String defaultRegrowthMobKey;
    private static BlockState DEFAULT_WALL_BLOCKSTATE;
    private static BlockState DEFAULT_FENCE_BLOCKSTATE;
    private static WallBiomeDataItem DEFAULT_WALL_ITEM;

    public static WallBiomeDataItem getWallBiomeDataItem(String key) {
        WallBiomeDataItem r;
        String iKey = key;
        if (wallBiomeDataHashtable.isEmpty()) {
            WallBiomeDataManager.wallBiomeDataInit();
        }
        if ((r = wallBiomeDataHashtable.get(iKey)) == null) {
            if (MyConfig.aDebugLevel > 0) {
                System.out.println("Error!  Villager in unknown Biome:" + key + ".");
            }
            r = DEFAULT_WALL_ITEM;
        }
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222 WallBiomeDataItem: " + iKey + " wall=" + r.getWallBlockState().m_60734_().toString() + "fence=" + r.getFenceBlockState().m_60734_().toString() + ".");
        }
        return r;
    }

    public static String getWallBiomeDataHashAsString() {
        Object returnString = "";
        for (String key : wallBiomeDataHashtable.keySet()) {
            int wallDiameter = WallBiomeDataManager.wallBiomeDataHashtable.get((Object)key).wallDiameter;
            BlockState wallTypeBlockState = wallBiomeDataHashtable.get(key).getWallBlockState();
            String tempString = key + "," + wallDiameter + "," + wallTypeBlockState.toString() + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void wallBiomeDataInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        Iterable walls = Registry.f_122824_.m_206058_(BlockTags.f_13032_);
        if (!walls.iterator().hasNext()) {
            System.out.println("failed to get walls all tags ");
            return;
        }
        System.out.println("succeeded in loading walls all tags");
        Iterable fences = Registry.f_122824_.m_206058_(BlockTags.f_13039_);
        if (!walls.iterator().hasNext()) {
            System.out.println("failed to get walls all tags ");
            return;
        }
        System.out.println("succeeded in loading fences all tags");
        int i = 0;
        String wallBiomeDataLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultWallBiomeData6464, ";");
        while (st6464.hasMoreElements()) {
            wallBiomeDataLine6464 = st6464.nextToken().trim();
            if (wallBiomeDataLine6464.isEmpty()) continue;
            dTL6464.add(wallBiomeDataLine6464);
            ++i;
        }
        MyConfig.defaultWallBiomeData = dTL6464.toArray(new String[i]);
        wallBiomeDataHashtable.clear();
        for (i = 0; i < MyConfig.defaultWallBiomeData.length; ++i) {
            try {
                String modAndBiome;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallBiomeData[i], ",");
                String key = modAndBiome = st.nextToken();
                String wallDiameterString = st.nextToken();
                String wallBlockString = st.nextToken();
                String fenceBlockString = st.nextToken();
                int wallDiameter = WallBiomeDataManager.validatedWallDiameter(Integer.parseInt(wallDiameterString.trim()));
                BlockState wallBlockState = DEFAULT_WALL_BLOCKSTATE;
                for (Holder w : walls) {
                    String wbs = ((Block)w.m_203334_()).getRegistryName().toString();
                    if (!wbs.equals(wallBlockString)) continue;
                    wallBlockState = ((Block)w.m_203334_()).m_49966_();
                    break;
                }
                BlockState fenceBlockState = DEFAULT_FENCE_BLOCKSTATE;
                for (Holder f : fences) {
                    String fbs = ((Block)f.m_203334_()).getRegistryName().toString();
                    if (!fbs.equals(fenceBlockString)) continue;
                    fenceBlockState = ((Block)f.m_203334_()).m_49966_();
                    break;
                }
                wallBiomeDataHashtable.put(key, new WallBiomeDataItem(wallDiameter, wallBlockState, fenceBlockState));
                if (modAndBiome.contentEquals("Regrowth:default") || modAndBiome.contentEquals("Regrowth:minimum") || modAndBiome.contentEquals("minecraft:icy") || modAndBiome.contentEquals("minecraft:extreme_hills") || modAndBiome.contentEquals("minecraft:mesa") || modAndBiome.contentEquals("minecraft:nether") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(modAndBiome))) continue;
                System.out.println("Regrowth Debug: Wall Biome Data: " + key + " not in Forge Entity Type Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Biome Data Config : " + MyConfig.defaultWallBiomeData[i]);
            }
        }
    }

    private static int validatedWallDiameter(int wallDiameter) {
        if (wallDiameter <= 24) {
            wallDiameter = 24;
        }
        if (wallDiameter > 80) {
            wallDiameter = 80;
        }
        return wallDiameter;
    }

    static {
        defaultRegrowthMobKey = defaultRegrowthMobString = "regrowth:default";
        DEFAULT_WALL_BLOCKSTATE = Blocks.f_50274_.m_49966_();
        DEFAULT_FENCE_BLOCKSTATE = Blocks.f_50132_.m_49966_();
        DEFAULT_WALL_ITEM = new WallBiomeDataItem(36, DEFAULT_WALL_BLOCKSTATE, DEFAULT_FENCE_BLOCKSTATE);
    }

    public static class WallBiomeDataItem {
        int wallDiameter;
        BlockState wallBlockState;
        BlockState fenceBlockState;

        public WallBiomeDataItem(int wallRadius, BlockState wallBlockState, BlockState fenceBlockState) {
            this.wallDiameter = wallRadius;
            this.wallBlockState = wallBlockState;
            this.fenceBlockState = fenceBlockState;
        }

        public int getWallDiameter() {
            return this.wallDiameter;
        }

        public int getWallRadius() {
            return this.wallDiameter / 2 + 1;
        }

        public BlockState getWallBlockState() {
            return this.wallBlockState;
        }

        public BlockState getFenceBlockState() {
            return this.fenceBlockState;
        }
    }
}

