/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.utility;

import com.mactso.regrowth.config.MyConfig;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility {
    public static String NONE = "none";
    public static String BEACH = "beach";
    public static String BADLANDS = "badlands";
    public static String DESERT = "desert";
    public static String EXTREME_HILLS = "extreme_hills";
    public static String ICY = "icy";
    public static String JUNGLE = "jungle";
    public static String THEEND = "the_end";
    public static String FOREST = "forest";
    public static String MESA = "mesa";
    public static String MUSHROOM = "mushroom";
    public static String MOUNTAIN = "mountain";
    public static String NETHER = "nether";
    public static String OCEAN = "ocean";
    public static String PLAINS = "plains";
    public static String RIVER = "river";
    public static String SAVANNA = "savanna";
    public static String SWAMP = "swamp";
    public static String TAIGA = "taiga";
    public static String UNDERGROUND = "underground";
    public static final int FOUR_SECONDS = 80;
    public static final int TWO_SECONDS = 40;
    public static final float Pct00 = 0.0f;
    public static final float Pct02 = 0.02f;
    public static final float Pct05 = 0.05f;
    public static final float Pct09 = 0.09f;
    public static final float Pct16 = 0.16f;
    public static final float Pct25 = 0.25f;
    public static final float Pct50 = 0.5f;
    public static final float Pct75 = 0.75f;
    public static final float Pct84 = 0.84f;
    public static final float Pct89 = 0.89f;
    public static final float Pct91 = 0.91f;
    public static final float Pct95 = 0.95f;
    public static final float Pct99 = 0.99f;
    public static final float Pct100 = 1.0f;
    private static final Logger LOGGER = LogManager.getLogger();

    public static String getMyBC(Holder<Biome> testBiome) {
        if (testBiome.m_203656_(BiomeTags.f_207590_)) {
            return DESERT;
        }
        if (testBiome.m_203656_(BiomeTags.f_207611_)) {
            return FOREST;
        }
        if (testBiome.m_203656_(BiomeTags.f_207604_)) {
            return BEACH;
        }
        if (testBiome.m_203656_(BiomeTags.f_207593_)) {
            return ICY;
        }
        if (testBiome.m_203656_(BiomeTags.f_207610_)) {
            return JUNGLE;
        }
        if (testBiome.m_203656_(BiomeTags.f_207603_)) {
            return OCEAN;
        }
        if (testBiome.m_203656_(BiomeTags.f_207602_)) {
            return OCEAN;
        }
        if (testBiome.m_203656_(BiomeTags.f_207591_)) {
            return PLAINS;
        }
        if (testBiome.m_203656_(BiomeTags.f_207605_)) {
            return RIVER;
        }
        if (testBiome.m_203656_(BiomeTags.f_215816_)) {
            return SAVANNA;
        }
        if (testBiome.m_203656_(BiomeTags.f_215815_)) {
            return SWAMP;
        }
        if (testBiome.m_203656_(BiomeTags.f_207609_)) {
            return TAIGA;
        }
        if (testBiome.m_203656_(BiomeTags.f_207607_)) {
            return BADLANDS;
        }
        if (testBiome.m_203656_(BiomeTags.f_207606_)) {
            return EXTREME_HILLS;
        }
        return NONE;
    }

    public static void debugMsg(int level, String dMsg) {
        if (MyConfig.getaDebugLevel() > level - 1) {
            LOGGER.info("L" + level + ":" + dMsg);
        }
    }

    public static void debugMsg(int level, BlockPos pos, String dMsg) {
        if (MyConfig.getaDebugLevel() > level - 1) {
            LOGGER.info("L" + level + " (" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "): " + dMsg);
        }
    }

    public static void debugMsg(int level, LivingEntity le, String dMsg) {
        if (MyConfig.getaDebugLevel() > level - 1) {
            LOGGER.info("L" + level + " (" + le.m_20183_().m_123341_() + "," + le.m_20183_().m_123342_() + "," + le.m_20183_().m_123343_() + "): " + dMsg);
        }
    }

    public static void sendBoldChat(Player p, String chatMessage, ChatFormatting textColor) {
        MutableComponent component = Component.m_237113_((String)chatMessage);
        component.m_6270_(component.m_7383_().m_131136_(Boolean.valueOf(true)));
        component.m_6270_(component.m_7383_().m_131140_(textColor));
        p.m_213846_((Component)component);
    }

    public static void sendChat(Player p, String chatMessage, ChatFormatting textColor) {
        MutableComponent component = Component.m_237113_((String)chatMessage);
        component.m_6270_(component.m_7383_().m_131140_(textColor));
        p.m_213846_((Component)component);
    }

    public static void updateEffect(LivingEntity e, int amplifier, MobEffect mobEffect, int duration) {
        MobEffectInstance ei = e.m_21124_(mobEffect);
        if (amplifier == 10) {
            amplifier = 20;
        }
        if (ei != null) {
            if (amplifier > ei.m_19564_()) {
                e.m_21195_(mobEffect);
            }
            if (amplifier == ei.m_19564_() && ei.m_19557_() > 10) {
                return;
            }
            if (ei.m_19557_() > 10) {
                return;
            }
            e.m_21195_(mobEffect);
        }
        e.m_7292_(new MobEffectInstance(mobEffect, duration, amplifier, true, true));
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier) {
        boolean isBaby = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean isBaby) {
        boolean persistant = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, persistant, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean persistant, boolean isBaby) {
        int numZP = level.f_46441_.m_188503_(range) - modifier;
        if (numZP < 0) {
            return false;
        }
        for (int i = 0; i <= numZP; ++i) {
            Mob e = (Mob)et.m_20600_(level, null, null, null, savePos.m_122012_().m_122024_(), MobSpawnType.NATURAL, true, true);
            if (persistant) {
                e.m_21530_();
            }
            e.m_6863_(isBaby);
        }
        return true;
    }

    public static boolean populateXEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int X, boolean isBaby) {
        for (int i = 0; i < X; ++i) {
            Mob e = (Mob)et.m_20600_(level, null, null, null, savePos.m_122012_().m_122024_(), MobSpawnType.NATURAL, true, true);
            e.m_6863_(isBaby);
        }
        return true;
    }

    public static void setName(ItemStack stack, String inString) {
        CompoundTag tag = stack.m_41698_("display");
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)inString));
        tag.m_128365_("Name", (Tag)list);
    }

    public static void setLore(ItemStack stack, String inString) {
        CompoundTag tag = stack.m_41698_("display");
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)inString));
        tag.m_128365_("Lore", (Tag)list);
    }

    public static boolean isNotNearWebs(BlockPos pos, ServerLevel serverLevel) {
        if (serverLevel.m_8055_(pos).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_122012_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_122019_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_122029_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        return serverLevel.m_8055_(pos.m_122024_()).m_60734_() == Blocks.f_50033_;
    }

    public static boolean isOutside(BlockPos pos, ServerLevel serverLevel) {
        return serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos) == pos;
    }

    public static void slowFlyingMotion(LivingEntity le) {
        if (le instanceof Player && le.m_21255_()) {
            Player cp = (Player)le;
            Vec3 vec = cp.m_20184_();
            Vec3 slowedVec = vec.f_82480_ > 0.0 ? vec.m_82542_(0.17, -0.75, 0.17) : vec.m_82542_(0.17, 1.001, 0.17);
            cp.m_20256_(slowedVec);
        }
    }

    public static String getResourceLocationString(ServerLevel serverLevel, BlockState blockState) {
        return Utility.getResourceLocationString(serverLevel, blockState.m_60734_());
    }

    public static String getResourceLocationString(ServerLevel serverLevel, Block block) {
        int id = Block.m_49956_((BlockState)block.m_49966_());
        Optional opt = serverLevel.m_5962_().m_6632_(Registry.f_122901_);
        String result = "BlockRegMissing";
        if (opt.isPresent()) {
            ResourceLocation rl = ((Registry)opt.get()).m_7981_((Object)block);
            result = rl.toString();
        }
        return result;
    }

    public static String getResourceLocationString(ServerLevel serverLevel, Item item) {
        int id = Item.m_41393_((Item)item);
        String result = "ItemRegMissing";
        Optional opt = serverLevel.m_5962_().m_6632_(Registry.f_122904_);
        if (opt.isPresent()) {
            ResourceLocation rl = ((Registry)opt.get()).m_7981_((Object)item);
            result = rl.toString();
        }
        return result;
    }

    public static String getResourceLocationString(Entity entity) {
        EntityType et = entity.m_6095_();
        return EntityType.m_20613_((EntityType)et).toString();
    }

    public static String GetBiomeName(Biome b) {
        return b.toString();
    }
}

