/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5458;

public class BiomeDimensionAllowDisallow {
    public static final Map<class_2960, List<Pattern>> DIMENSION_DISALLOW = new HashMap<class_2960, List<Pattern>>();
    public static final Map<class_2960, List<Pattern>> DIMENSION_ALLOW = new HashMap<class_2960, List<Pattern>>();
    public static final Map<class_2960, List<Pattern>> BIOME_ALLOW = new HashMap<class_2960, List<Pattern>>();
    public static final Map<class_2960, List<Pattern>> BIOME_DISALLOW = new HashMap<class_2960, List<Pattern>>();

    public static void setupAllowDisallowMaps() {
        RSStructures.RS_STRUCTURES.forEach((key, value) -> {
            class_2960 id = class_2378.field_16644.method_10221(key);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        RSConfiguredFeatures.RS_DUNGEONS.forEach(configuredFeature -> {
            class_2960 id = class_5458.field_25929.method_10221(configuredFeature);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        RSConfiguredFeatures.RS_WELLS.forEach(configuredFeature -> {
            class_2960 id = class_5458.field_25929.method_10221(configuredFeature);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        BiomeDimensionAllowDisallow.setupMap(DIMENSION_DISALLOW, RepurposedStructures.omegaBiomeDimConfig.disallowedDimensions, "dimension disallow");
        BiomeDimensionAllowDisallow.setupMap(DIMENSION_ALLOW, RepurposedStructures.omegaBiomeDimConfig.allowedDimensions, "dimension allow");
        BiomeDimensionAllowDisallow.setupMap(BIOME_DISALLOW, RepurposedStructures.omegaBiomeDimConfig.disallowedBiomes, "biome disallow");
        BiomeDimensionAllowDisallow.setupMap(BIOME_ALLOW, RepurposedStructures.omegaBiomeDimConfig.allowedBiomes, "biome allow");
    }

    private static void setupMap(Map<class_2960, List<Pattern>> mapToFillWithPatterns, Map<String, String> configMap, String errorMsg) {
        for (Map.Entry<String, String> configMapEntry : configMap.entrySet()) {
            List<String> parsedValues = Arrays.stream(configMapEntry.getValue().split(",")).map(String::trim).collect(Collectors.toList());
            class_2960 worldgenObjectID = new class_2960(configMapEntry.getKey());
            if (configMapEntry.getKey().equals("all")) {
                mapToFillWithPatterns.values().forEach(patternList -> parsedValues.forEach(pattern -> patternList.add(Pattern.compile(pattern))));
                continue;
            }
            if (mapToFillWithPatterns.containsKey(worldgenObjectID)) {
                parsedValues.forEach(patternList -> ((List)mapToFillWithPatterns.get(worldgenObjectID)).add(Pattern.compile(patternList)));
                continue;
            }
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)worldgenObjectID, (Object)errorMsg);
        }
    }
}

