/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.resources.BuilderAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.resources.LootContextAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.resources.LootManagerAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;

public class StructureModdedLootImporter {
    private static final Map<class_52, class_2960> REVERSED_TABLES = new HashMap<class_52, class_2960>();
    private static Set<class_2960> BLACKLISTED_LOOTTABLES;
    private static final Map<class_2960, class_2960> TABLE_IMPORTS;

    private static Map<class_2960, class_2960> createMap() {
        HashMap<class_2960, class_2960> tableMap = new HashMap<class_2960, class_2960>();
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/birch"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/crimson"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/desert"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/end"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/icy"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/jungle"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/nether"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/ocean"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/savanna"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/stone"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/dark_forest"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/swamp"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/taiga"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/warped"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/treasure"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/bridge"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/other"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/cities/nether"), new class_2960("minecraft:chests/bastion_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/badlands"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/dark_forest"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/desert"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/end"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/jungle"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/mushroom"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/nether"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/ocean"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/snow"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/swamp"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_center"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_hallway"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_shrine"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/grassy"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/stone"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/birch"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/desert"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/jungle"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/oak"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/savanna"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/snowy"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/taiga"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/badlands"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/birch"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/crimson"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/desert"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/giant_tree_taiga"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/icy"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/jungle"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/nether_brick"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/oak"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/snowy"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/taiga"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/warped"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/outposts/end"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/badlands"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/nether"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/snowy"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/icy"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/jungle"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/mushroom"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/ocean"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/giant_tree_taiga"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/flower_forest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/end"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/nether"), new class_2960("minecraft:chests/bastion_other"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_hot/large"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_hot/small"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_warm/large"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_warm/small"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portals/large_portal"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portals/small_portal"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/treasure"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/nether_bricks/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/stronghold/end_storage_room"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/stronghold/end_hallway"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/stronghold/end_library"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_storage_room"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_hallway"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_library"), new class_2960("minecraft:chests/stronghold_library"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/nether_basalt"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/nether_crimson"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/nether_soul"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/nether_warped"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/temples/nether_warped"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/nether_wasteland"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/nether_basalt"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/nether_crimson"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/nether_soul"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/nether_warped"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/nether_wasteland"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/badlands_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/birch_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/dark_forest_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/giant_taiga_house"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/jungle_house"), new class_2960("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/mountains_house"), new class_2960("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/oak_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/swamp_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_tanner"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_tanner"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        return tableMap;
    }

    public static List<class_1799> checkAndGetModifiedLoot(class_47 context, class_52 currentLootTable, List<class_1799> originalLoot) {
        class_2960 lootTableID;
        if (RepurposedStructures.RSAllConfig.RSAllowDisallowConfig.importModdedItems && (lootTableID = REVERSED_TABLES.computeIfAbsent(currentLootTable, lootTable -> ((LootManagerAccessor)context.method_299().method_8503().method_3857()).repurposedstructures_getTables().entrySet().stream().filter(entry -> lootTable.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null))) != null && lootTableID.method_12836().equals("repurposed_structures") && !StructureModdedLootImporter.isInBlacklist(lootTableID)) {
            return StructureModdedLootImporter.modifyLootTables(context, lootTableID, originalLoot);
        }
        return new ArrayList<class_1799>();
    }

    public static List<class_1799> modifyLootTables(class_47 context, class_2960 lootTableID, List<class_1799> originalLoot) {
        class_2960 tableToImportLoot = TABLE_IMPORTS.get(lootTableID);
        if (tableToImportLoot == null) {
            return originalLoot;
        }
        class_47 newContext = StructureModdedLootImporter.copyLootContextWithNewQueryID(context);
        List newlyGeneratedLoot = newContext.method_22556(tableToImportLoot).method_319(newContext);
        newlyGeneratedLoot.removeIf(itemStack -> {
            class_5321 itemKey = class_2378.field_11142.method_29113((Object)itemStack.method_7909()).orElse(null);
            return itemKey != null && itemKey.method_29177().method_12836().equals("minecraft");
        });
        originalLoot.addAll(newlyGeneratedLoot);
        return originalLoot;
    }

    private static class_47 copyLootContextWithNewQueryID(class_47 oldLootContext) {
        class_47.class_48 newContextBuilder = new class_47.class_48(oldLootContext.method_299()).method_311(oldLootContext.method_294()).method_303(oldLootContext.method_302());
        ((BuilderAccessor)newContextBuilder).repurposedstructures_setDynamicDrops(((LootContextAccessor)oldLootContext).repurposedstructures_getDynamicDrops());
        ((BuilderAccessor)newContextBuilder).repurposedstructures_setParams(((LootContextAccessor)oldLootContext).repurposedstructures_getParams());
        return newContextBuilder.method_309(class_173.field_1179);
    }

    private static boolean isInBlacklist(class_2960 lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RepurposedStructures.RSAllConfig.RSAllowDisallowConfig.blacklistedRSLoottablesFromImportingModdedItems.trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.equals("") ? new HashSet<class_2960>() : Arrays.stream(cleanedBlacklist.split(",")).map(String::trim).map(class_2960::new).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    static {
        TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    }
}

