/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

public class BiomeSelection {
    public static boolean hasName(BiomeSelectionContext context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getBiomeKey().method_29177().method_12832().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeSelectionContext context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getBiomeKey().method_29177().method_12836().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeSelectionContext context, class_5321<class_1959> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getBiomeKey().equals(key));
    }

    public static boolean haveCategories(BiomeSelectionContext context, class_1959.class_1961 ... categories) {
        HashSet<class_1959.class_1961> categorySet = new HashSet<class_1959.class_1961>(Arrays.asList(categories));
        return categorySet.contains(context.getBiome().method_8688());
    }

    public static boolean hasStructure(BiomeSelectionContext context, class_3195<?> structureFeature) {
        return context.getBiome().method_30970().method_30980(structureFeature);
    }

    public static boolean hasStructureType(BiomeSelectionContext context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().anyMatch(structure -> context.getBiome().method_30970().method_30980(structure));
    }

    public static boolean doesNotHaveStructureType(BiomeSelectionContext context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().noneMatch(structure -> context.getBiome().method_30970().method_30980(structure));
    }

    public static boolean isBiomeAllowed(BiomeSelectionContext context, class_3195<?> structureFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, structureFeature, class_2378.field_16644) || !BiomeSelection.isBiomeDisallowed(context, structureFeature, class_2378.field_16644) && defaultCondition.get() != false;
    }

    public static boolean isBiomeAllowed(BiomeSelectionContext context, class_2975<?, ?> configuredFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, configuredFeature, class_5458.field_25929) || !BiomeSelection.isBiomeDisallowed(context, configuredFeature, class_5458.field_25929) && defaultCondition.get() != false;
    }

    public static <T> boolean isBiomeAllowed(BiomeSelectionContext context, T worldgenObject, class_2378<T> registry) {
        class_2960 registryId = registry.method_10221(worldgenObject);
        String biomeID = context.getBiomeKey().method_29177().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_ALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                class_1959.class_1961 category = class_1959.class_1961.method_28424((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome allow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getBiome().method_8688().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    public static <T> boolean isBiomeDisallowed(BiomeSelectionContext context, T worldgenObject, class_2378<T> registry) {
        class_2960 registryId = registry.method_10221(worldgenObject);
        String biomeID = context.getBiomeKey().method_29177().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_DISALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                class_1959.class_1961 category = class_1959.class_1961.method_28424((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome disallow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getBiome().method_8688().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }
}

