/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4966;
import net.minecraft.class_5425;
import net.minecraft.class_5539;

public class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new HashMap<class_2680, Boolean>();

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_1922 world, class_2338 pos, class_2680 state) {
        if (!IS_FULLCUBE_MAP.containsKey(state)) {
            boolean isFullCube = class_2248.method_9614((class_265)state.method_26201(world, pos));
            IS_FULLCUBE_MAP.put(state, isFullCube);
        }
        return IS_FULLCUBE_MAP.get(state);
    }

    public static class_2680 orientateChest(class_5425 blockView, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 wallDirection = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)blockPos).method_10098(facing);
            if (!GeneralUtils.isFullCube((class_1922)blockView, (class_2338)mutable, blockView.method_8320((class_2338)mutable))) continue;
            wallDirection = facing;
            mutable.method_10104(facing.method_10153(), 2);
            if (blockView.method_8320((class_2338)mutable).method_26207().method_15799()) continue;
            break;
        }
        return (class_2680)blockState.method_11657((class_2769)class_2383.field_11177, (Comparable)wallDirection.method_10153());
    }

    public static boolean isBlacklistedForWorld(class_5425 currentWorld, class_2960 worldgenObjectID) {
        class_2960 worldID = currentWorld.method_8410().method_27983().method_29177();
        boolean allowInDim = ((List)BiomeDimensionAllowDisallow.DIMENSION_DISALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().noneMatch(pattern -> pattern.matcher(worldID.toString()).find());
        if (!allowInDim && ((List)BiomeDimensionAllowDisallow.DIMENSION_ALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().anyMatch(pattern -> pattern.matcher(worldID.toString()).find())) {
            allowInDim = true;
        }
        return !allowInDim;
    }

    public static void addToBiome(String modificationName, Predicate<BiomeSelectionContext> selectorPredicate, Consumer<BiomeModificationContext> biomeAdditionConsumer) {
        BiomeModifications.create((class_2960)new class_2960("repurposed_structures", modificationName)).add(ModificationPhase.ADDITIONS, selectorPredicate, biomeAdditionConsumer);
    }

    public static class_1799 enchantRandomly(Random random, class_1799 itemToEnchant, float chance) {
        List list;
        if (random.nextFloat() < chance && !(list = class_2378.field_11160.method_10220().filter(class_1887::method_25950).filter(enchantmentToCheck -> enchantmentToCheck.method_8192(itemToEnchant)).collect(Collectors.toList())).isEmpty()) {
            class_1887 enchantment = (class_1887)list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(class_3532.method_15395((Random)random, (int)enchantment.method_8187(), (int)enchantment.method_8183()) + 1);
            itemToEnchant.method_7978(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static class_2338 getHighestLand(class_2794 chunkGenerator, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_12104() - 20, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView);
        while (mutable.method_10264() > chunkGenerator.method_16398()) {
            class_2680 currentBlockstate = blockView.method_32892((class_2338)mutable);
            if (!currentBlockstate.method_26225()) {
                mutable.method_10098(class_2350.field_11033);
                continue;
            }
            if (blockView.method_32892(mutable.method_10069(0, 3, 0)).method_26207() == class_3614.field_15959 && (canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225())) {
                return mutable;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable;
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_16398() + 1, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView);
        class_2680 currentBlockstate = blockView.method_32892((class_2338)mutable);
        while (mutable.method_10264() <= chunkGenerator.method_12104() - 20) {
            if ((canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225()) && blockView.method_32892(mutable.method_10084()).method_26207() == class_3614.field_15959 && blockView.method_32892(mutable.method_10086(5)).method_26207() == class_3614.field_15959) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            currentBlockstate = blockView.method_32892((class_2338)mutable);
        }
        return mutable.method_10103(mutable.method_10263(), chunkGenerator.method_16398(), mutable.method_10260());
    }

    public static void centerAllPieces(class_2338 targetPos, List<class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 structurePiece : pieces) {
            structurePiece.method_14922(xOffset, 0, zOffset);
        }
    }
}

