/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetChanceConfig;
import java.util.BitSet;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5821;

public class StructureBreakage
extends class_3031<StructureTargetChanceConfig> {
    private static final Predicate<class_2680> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.method_26207() == class_3614.field_15914 || blockState.method_26207() == class_3614.field_15941 || blockState.method_27852(class_2246.field_10176) || blockState.method_27852(class_2246.field_10100) || blockState.method_27852(class_2246.field_10387) || blockState.method_27852(class_2246.field_10480) || blockState.method_27852(class_2246.field_10576);
    };

    public StructureBreakage(Codec<StructureTargetChanceConfig> config) {
        super(config);
    }

    public boolean method_13151(class_5821<StructureTargetChanceConfig> context) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (context.method_33654().nextFloat() < ((StructureTargetChanceConfig)context.method_33656()).chance) {
            mutable.method_10101((class_2382)context.method_33655()).method_10100(context.method_33654().nextInt(7) - 3, 0, context.method_33654().nextInt(7) - 3);
            boolean foundSurface = this.findSurface(context.method_33652(), mutable, class_2350.field_11036);
            if (!foundSurface) {
                mutable.method_10104(class_2350.field_11033, 5);
                foundSurface = this.findSurface(context.method_33652(), mutable, class_2350.field_11033);
            }
            if (!foundSurface) {
                return false;
            }
            mutable.method_10104(class_2350.field_11036, 2);
            float f = context.method_33654().nextFloat() * (float)Math.PI;
            float g = 3.0f;
            int i = 2;
            double d = (float)mutable.method_10263() + class_3532.method_15374((float)f) * g;
            double e = (float)mutable.method_10263() - class_3532.method_15374((float)f) * g;
            double h = (float)mutable.method_10260() + class_3532.method_15362((float)f) * g;
            double j = (float)mutable.method_10260() - class_3532.method_15362((float)f) * g;
            double l = mutable.method_10264() + context.method_33654().nextInt(3) - 2;
            double m = mutable.method_10264() + context.method_33654().nextInt(3) - 2;
            int n = mutable.method_10263() - class_3532.method_15386((float)g) - i;
            int o = mutable.method_10264() - 4;
            int p = mutable.method_10260() - class_3532.method_15386((float)g) - i;
            int q = 2 * (class_3532.method_15386((float)g) + i);
            int r = 8;
            for (int s = n; s <= n + q; ++s) {
                int t = p;
                if (t > p + q) continue;
                return this.generateVeinPart(context, d, e, h, j, l, m, n, o, p, q, r, context.method_33653());
            }
        }
        return true;
    }

    private boolean findSurface(class_5281 world, class_2338.class_2339 mutable, class_2350 direction) {
        for (int i = 0; i <= 5; ++i) {
            if (FORTRESS_BLOCKS.test(world.method_8320((class_2338)mutable))) {
                return true;
            }
            mutable.method_10098(direction);
        }
        return false;
    }

    protected boolean generateVeinPart(class_5821<StructureTargetChanceConfig> context, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i, class_2794 chunkGenerator) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double[] ds = new double[96];
        for (m = 0; m < 24; ++m) {
            float f = (float)m / 24.0f;
            o = class_3532.method_16436((double)f, (double)startX, (double)endX);
            p = class_3532.method_16436((double)f, (double)startY, (double)endY);
            q = class_3532.method_16436((double)f, (double)startZ, (double)endZ);
            r = context.method_33654().nextDouble() * 24.0 / 16.0;
            double l = ((double)(class_3532.method_15374((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < 23; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < 24; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4] - ds[n * 4]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < 24; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(class_3532.method_15357((double)(u - t)), x);
            int ab = Math.max(class_3532.method_15357((double)(v - t)), y);
            int ac = Math.max(class_3532.method_15357((double)(w - t)), z);
            int ad = Math.max(class_3532.method_15357((double)(u + t)), aa);
            int ae = Math.max(class_3532.method_15357((double)(v + t)), ab);
            int af = Math.max(class_3532.method_15357((double)(w + t)), ac);
            for (int ag = aa; ag <= ad; ++ag) {
                double ah = ((double)ag + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int ai = ab; ai <= ae; ++ai) {
                    double aj = ((double)ai + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int ak = ac; ak <= af; ++ak) {
                        boolean isBelowSealevel;
                        int am;
                        double al = ((double)ak + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = ag - x + (ai - y) * size + (ak - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.method_10103(ag, ai, ak);
                        class_2680 state = context.method_33652().method_8320((class_2338)mutable);
                        if (!FORTRESS_BLOCKS.test(state)) continue;
                        class_1923 currentChunkPos = new class_1923((class_2338)mutable);
                        class_2791 currentChunk = context.method_33652().method_8392(currentChunkPos.field_9181, currentChunkPos.field_9180);
                        boolean bl = isBelowSealevel = mutable.method_10264() < chunkGenerator.method_16398();
                        if (isBelowSealevel && this.isBorderingAir((class_5425)context.method_33652(), mutable)) continue;
                        currentChunk.method_12010((class_2338)mutable, isBelowSealevel ? class_2246.field_10382.method_9564() : class_2246.field_10543.method_9564(), false);
                        ++j;
                        state = currentChunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11033));
                        while (state.method_26207() == class_3614.field_15956) {
                            currentChunk.method_12010((class_2338)mutable, isBelowSealevel ? class_2246.field_10382.method_9564() : class_2246.field_10543.method_9564(), false);
                            state = currentChunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11033));
                        }
                        state = currentChunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11036));
                        while (state.method_26207() == class_3614.field_15956) {
                            isBelowSealevel = mutable.method_10264() < chunkGenerator.method_16398();
                            currentChunk.method_12010((class_2338)mutable, isBelowSealevel ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564(), false);
                            state = currentChunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11036));
                        }
                        class_2338.class_2339 mutableVineCheck = new class_2338.class_2339();
                        for (class_2350 direction : class_2350.values()) {
                            class_2680 neighboringBlock;
                            if (direction == class_2350.field_11036) continue;
                            mutableVineCheck.method_10101((class_2382)mutable).method_10098(direction);
                            if (currentChunkPos.field_9181 != mutableVineCheck.method_10263() >> 4 || currentChunkPos.field_9180 != mutableVineCheck.method_10260() >> 4) {
                                currentChunk = context.method_33652().method_22350((class_2338)mutableVineCheck);
                                currentChunkPos = new class_1923((class_2338)mutableVineCheck);
                            }
                            if (!(neighboringBlock = currentChunk.method_8320((class_2338)mutableVineCheck)).method_27852(class_2246.field_10597) || !((Boolean)neighboringBlock.method_11654((class_2769)class_2541.method_10828((class_2350)direction.method_10153()))).booleanValue()) continue;
                            while (neighboringBlock.method_26207() == class_3614.field_15956) {
                                currentChunk.method_12010((class_2338)mutableVineCheck, isBelowSealevel ? class_2246.field_10382.method_9564() : class_2246.field_10543.method_9564(), false);
                                neighboringBlock = currentChunk.method_8320((class_2338)mutableVineCheck.method_10098(class_2350.field_11033));
                            }
                        }
                    }
                }
            }
        }
        return j > 0;
    }

    private boolean isBorderingAir(class_5425 world, class_2338.class_2339 mutable) {
        class_2338.class_2339 mutableWaterCheck = new class_2338.class_2339();
        class_1923 currentChunkPos2 = new class_1923((class_2338)mutable);
        class_2791 currentChunk2 = world.method_8392(currentChunkPos2.field_9181, currentChunkPos2.field_9180);
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11036) continue;
            mutableWaterCheck.method_10101((class_2382)mutable).method_10098(direction);
            if (currentChunkPos2.field_9181 != mutableWaterCheck.method_10263() >> 4 || currentChunkPos2.field_9180 != mutableWaterCheck.method_10260() >> 4) {
                currentChunk2 = world.method_22350((class_2338)mutableWaterCheck);
                currentChunkPos2 = new class_1923((class_2338)mutableWaterCheck);
            }
            if (!currentChunk2.method_8320((class_2338)mutableWaterCheck).method_26215()) continue;
            return true;
        }
        return false;
    }
}

