/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3485;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class AdvancedDistanceJigsawStructure
extends AdvancedJigsawStructure {
    protected final int distanceFromWorldOrigin;

    public AdvancedDistanceJigsawStructure(class_2960 poolID, int structureSize, int biomeRange, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange, int distanceFromWorldOrigin) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange);
        this.distanceFromWorldOrigin = distanceFromWorldOrigin;
    }

    @Override
    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 featureConfig, class_5539 heightLimitView) {
        int zBlockPos;
        int radius = this.distanceFromWorldOrigin;
        int xBlockPos = chunkPos1.method_8326();
        return xBlockPos * xBlockPos + (zBlockPos = chunkPos1.method_8328()) * zBlockPos > radius * radius;
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new Start((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class Start
    extends AdvancedJigsawStructure.MainStart {
        private final class_2960 structureID;

        public Start(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
            this.structureID = class_2378.field_16644.method_10221(structureIn);
        }

        @Override
        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            int bottomClipOff;
            int topClipOff;
            class_2338.class_2339 blockpos = new class_2338.class_2339(chunkPos1.method_8326(), 0, chunkPos1.method_8328());
            if (AdvancedDistanceJigsawStructure.this.maxY - AdvancedDistanceJigsawStructure.this.minY <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + class_2378.field_16644.method_10221((Object)this.method_16656()));
            }
            int structureStartHeight = this.field_16715.nextInt(AdvancedDistanceJigsawStructure.this.maxY - AdvancedDistanceJigsawStructure.this.minY) + AdvancedDistanceJigsawStructure.this.minY;
            blockpos.method_10104(class_2350.field_11036, structureStartHeight);
            if (AdvancedDistanceJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedDistanceJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedDistanceJigsawStructure.this.maxY + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedDistanceJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedDistanceJigsawStructure.this.minY - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + AdvancedDistanceJigsawStructure.this.verticalRange;
                bottomClipOff = structureStartHeight - AdvancedDistanceJigsawStructure.this.verticalRange;
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(AdvancedDistanceJigsawStructure.this.startPool), AdvancedDistanceJigsawStructure.this.structureSize), chunkGenerator, structureManager, (class_2338)blockpos, this.field_15325, (Random)this.field_16715, false, false, heightLimitView, this.structureID, topClipOff, bottomClipOff);
            this.method_14969();
        }
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedJigsawStructure.Builder<T> {
        protected int distanceFromWorldOrigin = 2817;

        public Builder(class_2960 startPool) {
            super(startPool);
        }

        public T setDistanceFromWorldOrigin(int distanceFromWorldOrigin) {
            this.distanceFromWorldOrigin = distanceFromWorldOrigin;
            return (T)((Builder)this.getThis());
        }

        @Override
        public AdvancedDistanceJigsawStructure build() {
            return new AdvancedDistanceJigsawStructure(this.startPool, this.structureSize, this.biomeRange, this.maxY, this.minY, this.clipOutOfBoundsPieces, this.verticalRange, this.distanceFromWorldOrigin);
        }
    }
}

