/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3485;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class AdvancedJigsawStructure
extends AbstractBaseStructure<class_3111> {
    protected final class_2960 startPool;
    protected final int structureSize;
    protected final int biomeRange;
    protected final int maxY;
    protected final int minY;
    protected final boolean clipOutOfBoundsPieces;
    protected final Integer verticalRange;

    public AdvancedJigsawStructure(class_2960 poolID, int structureSize, int biomeRange, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange) {
        super(class_3111.field_24893);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.biomeRange = biomeRange;
        this.maxY = maxY;
        this.minY = minY;
        this.clipOutOfBoundsPieces = clipOutOfBoundsPieces;
        this.verticalRange = verticalRange;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
        if (!(biomeSource instanceof class_1973)) {
            for (int curChunkX = chunkPos1.field_9181 - this.biomeRange; curChunkX <= chunkPos1.field_9181 + this.biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos1.field_9180 - this.biomeRange; curChunkZ <= chunkPos1.field_9180 + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.method_16359(curChunkX << 2, 64, curChunkZ << 2).method_30970().method_30980((class_3195)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new MainStart((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class MainStart
    extends class_4183<class_3111> {
        private final class_2960 structureID;

        public MainStart(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
            this.structureID = class_2378.field_16644.method_10221(structureIn);
        }

        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            int bottomClipOff;
            int topClipOff;
            class_2338.class_2339 blockpos = new class_2338.class_2339(chunkPos1.method_8326(), 0, chunkPos1.method_8328());
            if (AdvancedJigsawStructure.this.maxY - AdvancedJigsawStructure.this.minY <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + class_2378.field_16644.method_10221((Object)this.method_16656()));
            }
            int structureStartHeight = this.field_16715.nextInt(AdvancedJigsawStructure.this.maxY - AdvancedJigsawStructure.this.minY) + AdvancedJigsawStructure.this.minY;
            blockpos.method_10104(class_2350.field_11036, structureStartHeight);
            if (AdvancedJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedJigsawStructure.this.maxY + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedJigsawStructure.this.minY - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + AdvancedJigsawStructure.this.verticalRange;
                bottomClipOff = structureStartHeight - AdvancedJigsawStructure.this.verticalRange;
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(AdvancedJigsawStructure.this.startPool), AdvancedJigsawStructure.this.structureSize), chunkGenerator, structureManager, (class_2338)blockpos, this.field_15325, (Random)this.field_16715, false, false, heightLimitView, this.structureID, topClipOff, bottomClipOff);
            this.method_14969();
        }
    }

    public static class Builder<T extends Builder<T>> {
        protected final class_2960 startPool;
        protected int structureSize = 1;
        protected int biomeRange = 0;
        protected int maxY = 255;
        protected int minY = 0;
        protected boolean clipOutOfBoundsPieces = true;
        protected Integer verticalRange = null;

        public Builder(class_2960 startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(int structureSize) {
            this.structureSize = structureSize;
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setMaxY(int maxY) {
            this.maxY = maxY;
            return this.getThis();
        }

        public T setMinY(int minY) {
            this.minY = minY;
            return this.getThis();
        }

        public T setVerticalRange(int verticalRange) {
            this.verticalRange = verticalRange;
            return this.getThis();
        }

        public T doNotClipOutOfBoundsPieces() {
            this.clipOutOfBoundsPieces = false;
            return this.getThis();
        }

        public AdvancedJigsawStructure build() {
            return new AdvancedJigsawStructure(this.startPool, this.structureSize, this.biomeRange, this.maxY, this.minY, this.clipOutOfBoundsPieces, this.verticalRange);
        }
    }
}

