/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6130;

public class BuriableStructure
extends AbstractBaseStructure<class_3111> {
    private final class_2960 startPool;
    private final int offsetAmount;
    private final boolean onLand;
    private final boolean cannotSpawnInWater;

    public BuriableStructure(class_2960 startPool, int offsetAmount, boolean onLand, boolean cannotSpawnInWater) {
        super(class_3111.field_24893);
        this.startPool = startPool;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
        this.offsetAmount = offsetAmount;
        this.onLand = onLand;
        this.cannotSpawnInWater = cannotSpawnInWater;
    }

    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
        if (this.cannotSpawnInWater) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = chunkGenerator.method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, heightLimitView);
            class_4966 columnOfBlocks = chunkGenerator.method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), heightLimitView);
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10086(landHeight));
            return topBlock.method_26227().method_15769();
        }
        return true;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new Start((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class Start
    extends class_3449<class_3111> {
        public Start(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
        }

        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            class_2338 blockpos = new class_2338(chunkPos1.method_8326(), chunkGenerator.method_16398(), chunkPos1.method_8328());
            class_3778.method_30419((class_5455)dynamicRegistryManager, (class_3812)new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(BuriableStructure.this.startPool), 11), class_3790::new, (class_2794)chunkGenerator, (class_3485)structureManager, (class_2338)blockpos, (class_6130)this, (Random)this.field_16715, (boolean)false, (boolean)false, (class_5539)heightLimitView);
            GeneralUtils.centerAllPieces(blockpos, this.field_15325);
            this.method_14969();
            class_2470 rotation = ((class_3443)this.field_15325.get(0)).method_16888();
            class_2338 maxCorner = new class_2338(((class_3443)this.field_15325.get(0)).method_14935().method_35414(), 0, ((class_3443)this.field_15325.get(0)).method_14935().method_14663()).method_10070(rotation);
            class_2902.class_2903 heightMapToUse = BuriableStructure.this.onLand ? class_2902.class_2903.field_13194 : class_2902.class_2903.field_13195;
            int highestLandPos = chunkGenerator.method_16397(blockpos.method_10263() + maxCorner.method_10263(), blockpos.method_10260() + maxCorner.method_10260(), heightMapToUse, heightLimitView);
            highestLandPos = Math.min(highestLandPos, chunkGenerator.method_16397(blockpos.method_10263(), blockpos.method_10260() + maxCorner.method_10260(), heightMapToUse, heightLimitView));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.method_16397(blockpos.method_10263() + maxCorner.method_10263(), blockpos.method_10260(), heightMapToUse, heightLimitView));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.method_16397(blockpos.method_10263(), blockpos.method_10260(), heightMapToUse, heightLimitView));
            if (!BuriableStructure.this.onLand) {
                int maxHeightForSubmerging = chunkGenerator.method_16398() - ((class_3443)this.field_15325.get(0)).method_14935().method_14660();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            this.method_14976((Random)this.field_16715, highestLandPos - (BuriableStructure.this.offsetAmount + 1), highestLandPos - BuriableStructure.this.offsetAmount);
        }
    }

    public static class Builder<T extends Builder<T>> {
        private final class_2960 startPool;
        private int offsetAmount = 14;
        private boolean onLand = true;
        private boolean cannotSpawnInWater = true;

        public Builder(class_2960 startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setOffsetAmount(int offsetAmount) {
            this.offsetAmount = offsetAmount;
            return this.getThis();
        }

        public T useOceanHeightmap() {
            this.onLand = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = false;
            return this.getThis();
        }

        public BuriableStructure build() {
            return new BuriableStructure(this.startPool, this.offsetAmount, this.onLand, this.cannotSpawnInWater);
        }
    }
}

