/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_4966;
import net.minecraft.class_5314;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class GenericJigsawStructure
extends AbstractBaseStructure<class_3111> {
    protected final class_2960 startPool;
    protected final int structureSize;
    protected final int centerOffset;
    protected final int biomeRange;
    protected final int structureBlacklistRange;
    protected final Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet;
    protected final int allowTerrainHeightRange;
    protected final int terrainHeightRadius;
    protected final int minHeightLimit;
    protected int fixedYSpawn;
    protected boolean useHeightmap;
    protected boolean cannotSpawnInWater;

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater) {
        super(class_3111.field_24893);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.avoidStructuresSet = avoidStructuresSet;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        this.fixedYSpawn = fixedYSpawn;
        this.useHeightmap = useHeightmap;
        this.cannotSpawnInWater = cannotSpawnInWater;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
        int curChunkZ;
        int curChunkX;
        if (!(biomeSource instanceof class_1973)) {
            for (curChunkX = chunkPos1.field_9181 - this.biomeRange; curChunkX <= chunkPos1.field_9181 + this.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkPos1.field_9180 - this.biomeRange; curChunkZ <= chunkPos1.field_9180 + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.method_16359(curChunkX << 2, 64, curChunkZ << 2).method_30970().method_30980((class_3195)this)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkPos1.field_9181 - this.structureBlacklistRange; curChunkX <= chunkPos1.field_9181 + this.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkPos1.field_9180 - this.structureBlacklistRange; curChunkZ <= chunkPos1.field_9180 + this.structureBlacklistRange; ++curChunkZ) {
                for (RSStructureTagMap.STRUCTURE_TAGS tag : this.avoidStructuresSet) {
                    for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        class_5314 structureConfig;
                        if (structureFeature == this || (structureConfig = chunkGenerator.method_12109().method_28600(structureFeature)) == null || structureConfig.method_28803() <= 8) continue;
                        class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                        return false;
                    }
                }
            }
        }
        if (this.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkPos1.field_9181 - this.terrainHeightRadius; curChunkX2 <= chunkPos1.field_9181 + this.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkPos1.field_9180 - this.terrainHeightRadius; curChunkZ2 <= chunkPos1.field_9180 + this.terrainHeightRadius; ++curChunkZ2) {
                    int height = chunkGenerator.method_16397((curChunkX2 << 4) + 7, (curChunkZ2 << 4) + 7, class_2902.class_2903.field_13194, heightLimitView);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= this.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= this.allowTerrainHeightRange;
        }
        if (this.cannotSpawnInWater) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = chunkGenerator.method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, heightLimitView);
            class_4966 columnOfBlocks = chunkGenerator.method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), heightLimitView);
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10086(landHeight));
            return topBlock.method_26227().method_15769();
        }
        return true;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new MainStart((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class MainStart
    extends class_4183<class_3111> {
        public MainStart(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
        }

        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            class_2338 blockpos = new class_2338(chunkPos1.method_8326(), GenericJigsawStructure.this.fixedYSpawn, chunkPos1.method_8328());
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(GenericJigsawStructure.this.startPool), GenericJigsawStructure.this.structureSize), chunkGenerator, structureManager, blockpos, this.field_15325, (Random)this.field_16715, GenericJigsawStructure.this.useHeightmap, GenericJigsawStructure.this.useHeightmap, heightLimitView, null, Integer.MAX_VALUE, Integer.MIN_VALUE);
            GeneralUtils.centerAllPieces(blockpos, this.field_15325);
            this.method_14969();
            ((class_3443)this.field_15325.get(0)).method_14922(0, GenericJigsawStructure.this.centerOffset, 0);
        }
    }

    public static class Builder<T extends Builder<T>> {
        protected final class_2960 startPool;
        protected int structureSize = 1;
        protected int centerOffset = 0;
        protected int biomeRange = 0;
        protected int structureBlacklistRange = 0;
        protected Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet = new HashSet<RSStructureTagMap.STRUCTURE_TAGS>();
        protected int allowTerrainHeightRange = -1;
        protected int terrainHeightRadius = 0;
        protected int minHeightLimit = Integer.MIN_VALUE;
        protected int fixedYSpawn = 0;
        protected boolean useHeightmap = true;
        protected boolean cannotSpawnInWater = false;

        public Builder(class_2960 startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(int structureSize) {
            this.structureSize = structureSize;
            return this.getThis();
        }

        public T setCenterOffset(int centerOffset) {
            this.centerOffset = centerOffset;
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setStructureBlacklistRange(int structureBlacklistRange) {
            this.structureBlacklistRange = structureBlacklistRange;
            return this.getThis();
        }

        public T setAvoidStructuresSet(Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
            this.avoidStructuresSet = avoidStructuresSet;
            return this.getThis();
        }

        public T setAllowTerrainHeightRange(int allowTerrainHeightRange) {
            this.allowTerrainHeightRange = allowTerrainHeightRange;
            return this.getThis();
        }

        public T setTerrainHeightRadius(int terrainHeightRadius) {
            this.terrainHeightRadius = terrainHeightRadius;
            return this.getThis();
        }

        public T setMinHeightLimit(int minHeightLimit) {
            this.minHeightLimit = minHeightLimit;
            return this.getThis();
        }

        public T setFixedYSpawn(int fixedYSpawn) {
            this.fixedYSpawn = fixedYSpawn;
            return this.getThis();
        }

        public T doNotUseHeightmap() {
            this.useHeightmap = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = true;
            return this.getThis();
        }

        public GenericJigsawStructure build() {
            return new GenericJigsawStructure(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater);
        }
    }
}

