/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3485;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    protected final boolean highestLandSearch;
    protected final boolean canPlaceOnLiquid;
    protected final int ledgeSpotOffset;
    protected final int liquidSpotOffset;

    public GenericNetherJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater, boolean highestLandSearch, boolean canPlaceOnLiquid, int ledgeSpotOffset, int liquidSpotOffset) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, minHeightLimit, fixedYSpawn, useHeightmap, cannotSpawnInWater);
        this.highestLandSearch = highestLandSearch;
        this.canPlaceOnLiquid = canPlaceOnLiquid;
        this.ledgeSpotOffset = ledgeSpotOffset;
        this.liquidSpotOffset = liquidSpotOffset;
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new Start((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkPos1, biome, defaultFeatureConfig, heightLimitView);
            class_2338 placementPos = GenericNetherJigsawStructure.this.highestLandSearch ? GeneralUtils.getHighestLand(chunkGenerator, this.method_36217(), heightLimitView, GenericNetherJigsawStructure.this.canPlaceOnLiquid) : GeneralUtils.getLowestLand(chunkGenerator, this.method_36217(), heightLimitView, GenericNetherJigsawStructure.this.canPlaceOnLiquid);
            if (placementPos.method_10264() >= chunkGenerator.method_12104() || placementPos.method_10264() <= chunkGenerator.method_16398() + 1) {
                this.method_14976((Random)this.field_16715, chunkGenerator.method_16398() + GenericNetherJigsawStructure.this.ledgeSpotOffset, chunkGenerator.method_16398() + (GenericNetherJigsawStructure.this.ledgeSpotOffset + 1));
            } else {
                this.method_14976((Random)this.field_16715, placementPos.method_10264() + GenericNetherJigsawStructure.this.liquidSpotOffset, placementPos.method_10264() + (GenericNetherJigsawStructure.this.liquidSpotOffset + 1));
            }
        }
    }

    public static class Builder<T extends Builder<T>>
    extends GenericJigsawStructure.Builder<T> {
        protected boolean highestLandSearch = false;
        protected boolean canPlaceOnLiquid = false;
        protected int ledgeSpotOffset;
        protected int liquidSpotOffset;

        public Builder(class_2960 startPool) {
            super(startPool);
        }

        public T searchForHighestLand() {
            this.highestLandSearch = true;
            return (T)((Builder)this.getThis());
        }

        public T canSpawnOnLiquid() {
            this.canPlaceOnLiquid = true;
            return (T)((Builder)this.getThis());
        }

        public T setLedgeSpotOffset(int ledgeSpotOffset) {
            this.ledgeSpotOffset = ledgeSpotOffset;
            return (T)((Builder)this.getThis());
        }

        public T setLiquidSpotOffset(int liquidSpotOffset) {
            this.liquidSpotOffset = liquidSpotOffset;
            return (T)((Builder)this.getThis());
        }

        @Override
        public GenericNetherJigsawStructure build() {
            return new GenericNetherJigsawStructure(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater, this.highestLandSearch, this.canPlaceOnLiquid, this.ledgeSpotOffset, this.liquidSpotOffset);
        }
    }
}

