/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class LandBasedEndStructure
extends GenericJigsawStructure {
    public LandBasedEndStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, minHeightLimit, fixedYSpawn, useHeightmap, cannotSpawnInWater);
    }

    @Override
    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
        return LandBasedEndStructure.getTerrainHeight(chunkPos1, chunkGenerator, heightLimitView) >= Math.min(chunkGenerator.method_12104(), 50);
    }

    private static int getTerrainHeight(class_1923 chunkPos1, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int xPos = chunkPos1.field_9181 << 4;
        int zPos = chunkPos1.field_9180 << 4;
        int height = chunkGenerator.method_18028(xPos, zPos, class_2902.class_2903.field_13194, heightLimitView);
        class_2338 pos = new class_2338(xPos, chunkGenerator.method_12104(), zPos);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13194, heightLimitView));
        }
        return height;
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new Start((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(LandBasedEndStructure.this, structureIn, chunkPos1, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkPos1, biome, defaultFeatureConfig, heightLimitView);
            class_3341 box = ((class_3443)this.field_15325.get(0)).method_14935();
            class_2338 centerPos = new class_2338((class_2382)box.method_22874());
            int radius = (int)Math.sqrt(box.method_14659().method_10263() * box.method_14659().method_10263() + box.method_14659().method_10260() * box.method_14659().method_10260()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = chunkGenerator.method_18028(centerPos.method_10263() + xOffset, centerPos.method_10260() + zOffset, class_2902.class_2903.field_13194, heightLimitView);
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((class_3443)this.field_15325.get(0)).method_14935().method_35416();
            int offsetAmount = avgHeight - parentHeight + LandBasedEndStructure.this.centerOffset;
            this.field_15325.forEach(child -> child.method_14922(0, offsetAmount, 0));
            GeneralUtils.centerAllPieces(centerPos, this.field_15325);
            this.method_14969();
        }
    }

    public static class Builder<T extends GenericJigsawStructure.Builder<T>>
    extends GenericJigsawStructure.Builder<T> {
        public Builder(class_2960 startPool) {
            super(startPool);
        }

        @Override
        public LandBasedEndStructure build() {
            return new LandBasedEndStructure(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater);
        }
    }
}

