/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3485;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_4966;
import net.minecraft.class_5314;
import net.minecraft.class_5455;
import net.minecraft.class_5539;

public class MineshaftEndStructure
extends MineshaftStructure {
    public MineshaftEndStructure(class_2960 poolID, int structureSize, int biomeRange, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange, double probability) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange, probability);
    }

    @Override
    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 featureConfig, class_5539 heightLimitView) {
        boolean superCheck = super.isFeatureChunk(chunkGenerator, biomeSource, seed, chunkRandom, chunkPos1, biome, chunkPos, featureConfig, heightLimitView);
        if (!superCheck) {
            return false;
        }
        int structureCheckRadius = 6;
        for (int curChunkX = chunkPos1.field_9181 - structureCheckRadius; curChunkX <= chunkPos1.field_9181 + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkPos1.field_9180 - structureCheckRadius; curChunkZ <= chunkPos1.field_9180 + structureCheckRadius; ++curChunkZ) {
                for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.END_MINESHAFT_AVOID_STRUCTURE)) {
                    class_5314 structureConfig;
                    if (structureFeature == this || (structureConfig = chunkGenerator.method_12109().method_28600(structureFeature)) == null || structureConfig.method_28803() <= 10) continue;
                    class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                    return false;
                }
            }
        }
        int minThickness = RepurposedStructures.RSAllConfig.RSMineshaftsConfig.misc.endMineshaftMinIslandThickness;
        if (minThickness == 0) {
            return true;
        }
        class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = chunkPos1.method_8326();
        int zPos = chunkPos1.method_8328();
        for (int i = 2; i >= 1; --i) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_1160 offsetPos = new class_1160((float)direction.method_10148(), 0.0f, (float)direction.method_10165());
                offsetPos = new class_1160(offsetPos.method_4943() * 30.0f * (float)i, 0.0f, offsetPos.method_4947() * 30.0f * (float)i);
                this.analyzeLand(chunkGenerator, xPos + (int)offsetPos.method_4943(), zPos + (int)offsetPos.method_4947(), islandTopBottomThickness, heightLimitView);
                if (islandTopBottomThickness.method_10260() >= minThickness) continue;
                return false;
            }
        }
        this.analyzeLand(chunkGenerator, xPos, zPos, islandTopBottomThickness, heightLimitView);
        return islandTopBottomThickness.method_10260() >= minThickness;
    }

    private void analyzeLand(class_2794 chunkGenerator, int xPos, int zPos, class_2338.class_2339 islandTopBottomThickness, class_5539 heightLimitView) {
        class_4966 columnOfBlocks = chunkGenerator.method_26261(xPos, zPos, heightLimitView);
        class_2338.class_2339 currentPos = new class_2338.class_2339(xPos, chunkGenerator.method_12104(), zPos);
        boolean isInIsland = false;
        while (currentPos.method_10264() >= -1) {
            class_2680 state = columnOfBlocks.method_32892((class_2338)currentPos);
            if (!state.method_26215() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.method_10264(), islandTopBottomThickness.method_10263());
                islandTopBottomThickness.method_10103(topIslandY, islandTopBottomThickness.method_10264(), islandTopBottomThickness.method_10260());
            } else if (state.method_26215() && isInIsland) {
                int bottomIslandY = Math.max(currentPos.method_10264(), islandTopBottomThickness.method_10264());
                islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), bottomIslandY, islandTopBottomThickness.method_10260());
                break;
            }
            currentPos.method_10098(class_2350.field_11033);
        }
        if (!isInIsland) {
            islandTopBottomThickness.method_10103(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.method_10263() - islandTopBottomThickness.method_10264();
        islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), islandTopBottomThickness.method_10264(), thickness);
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3) -> new MainStart((class_3195<class_3111>)x$0, x$1, x$2, x$3);
    }

    public class MainStart
    extends class_4183<class_3111> {
        private final class_2960 structureID;

        public MainStart(class_3195<class_3111> structureIn, class_1923 chunkPos1, int referenceIn, long seedIn) {
            super(structureIn, chunkPos1, referenceIn, seedIn);
            this.structureID = class_2378.field_16644.method_10221(structureIn);
        }

        public void generatePieces(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, class_1923 chunkPos1, class_1959 biome, class_3111 defaultFeatureConfig, class_5539 heightLimitView) {
            class_2338.class_2339 blockpos = new class_2338.class_2339(chunkPos1.method_8326(), 0, chunkPos1.method_8328());
            class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            MineshaftEndStructure.this.analyzeLand(chunkGenerator, blockpos.method_10263(), blockpos.method_10260(), islandTopBottomThickness, heightLimitView);
            int minThickness = RepurposedStructures.RSAllConfig.RSMineshaftsConfig.misc.endMineshaftMinIslandThickness;
            int maxY = 53;
            int minY = 15;
            if (minThickness == 0) {
                blockpos.method_10104(class_2350.field_11036, 35);
            } else {
                int structureStartHeight = this.field_16715.nextInt(islandTopBottomThickness.method_10260() - minThickness + 1) + islandTopBottomThickness.method_10264() + minThickness / 2;
                blockpos.method_10104(class_2350.field_11036, structureStartHeight);
                maxY = islandTopBottomThickness.method_10263() - 5;
                minY = islandTopBottomThickness.method_10264();
                if (maxY - minY <= 5) {
                    minY = maxY - 5;
                }
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(MineshaftEndStructure.this.startPool), MineshaftEndStructure.this.structureSize), chunkGenerator, structureManager, (class_2338)blockpos, this.field_15325, (Random)this.field_16715, false, false, heightLimitView, this.structureID, maxY, minY);
            this.method_14969();
        }
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedJigsawStructure.Builder<T> {
        protected double probability = 0.01;

        public Builder(class_2960 startPool) {
            super(startPool);
        }

        public T setProbability(double probability) {
            this.probability = probability;
            return (T)((Builder)this.getThis());
        }

        @Override
        public MineshaftEndStructure build() {
            return new MineshaftEndStructure(this.startPool, this.structureSize, this.biomeRange, this.maxY, this.minY, this.clipOutOfBoundsPieces, this.verticalRange, this.probability);
        }
    }
}

