/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5314;
import net.minecraft.class_5539;

public class MineshaftStructure
extends AdvancedJigsawStructure {
    protected final double probability;

    public MineshaftStructure(class_2960 poolID, int structureSize, int biomeRange, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange, double probability) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange);
        this.probability = probability;
    }

    @Override
    public class_2338 method_14015(class_4538 world, class_5138 structureAccessor, class_2338 searchStartPos, int searchRadius, boolean skipExistingChunks, long worldSeed, class_5314 config) {
        return MineshaftStructure.locateStructureFast(world, structureAccessor, searchStartPos, searchRadius, skipExistingChunks, worldSeed, config, this, this.probability);
    }

    public static <C extends class_3037> class_2338 locateStructureFast(class_4538 worldView, class_5138 structureAccessor, class_2338 blockPos, int radius, boolean skipExistingChunks, long seed, class_5314 structureConfig, class_3195<C> structure, double probability) {
        int spacing = structureConfig.method_28803();
        int chunkPosX = blockPos.method_10263() >> 4;
        int chunkPosZ = blockPos.method_10260() >> 4;
        class_2919 msRandom = new class_2919();
        class_2919 chunkRandom = new class_2919();
        for (int currentRadius = 0; currentRadius <= 100000; ++currentRadius) {
            for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                boolean xEdge = xRadius == -currentRadius || xRadius == currentRadius;
                for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                    boolean zEdge;
                    boolean bl = zEdge = zRadius == -currentRadius || zRadius == currentRadius;
                    if (xEdge || zEdge) {
                        class_2791 chunk;
                        class_3449 structureStart;
                        int trueChunkX = chunkPosX + spacing * xRadius;
                        int trueChunkZ = chunkPosZ + spacing * zRadius;
                        class_1923 chunkPos = structure.method_27218(structureConfig, seed, chunkRandom, trueChunkX, trueChunkZ);
                        msRandom.method_12663(seed + (long)structureConfig.method_28808(), chunkPos.field_9181, chunkPos.field_9180);
                        double d = probability / 10000.0;
                        if (!(msRandom.nextDouble() < d) || !worldView.method_16359((chunkPos.field_9181 << 2) + 2, 60, (chunkPos.field_9180 << 2) + 2).method_30970().method_30980(structure) || (structureStart = structureAccessor.method_26975(class_4076.method_18681((class_1923)(chunk = worldView.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423)).method_12004(), (int)0), structure, (class_2810)chunk)) == null || !structureStart.method_16657()) continue;
                        if (skipExistingChunks && structureStart.method_14979()) {
                            structureStart.method_14964();
                            return structureStart.method_14962();
                        }
                        if (skipExistingChunks) continue;
                        return structureStart.method_14962();
                    }
                    zRadius = currentRadius - 1;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean isFeatureChunk(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, class_1923 chunkPos1, class_1959 biome, class_1923 chunkPos, class_3111 featureConfig, class_5539 heightLimitView) {
        class_5314 structureConfig = chunkGenerator.method_12109().method_28600((class_3195)this);
        if (structureConfig != null) {
            chunkRandom.method_12663(seed + (long)structureConfig.method_28808(), chunkPos1.field_9181, chunkPos1.field_9180);
            double d = this.probability / 10000.0;
            return chunkRandom.nextDouble() < d;
        }
        return false;
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedJigsawStructure.Builder<T> {
        protected double probability = 0.01;

        public Builder(class_2960 startPool) {
            super(startPool);
        }

        public T setProbability(double probability) {
            this.probability = probability;
            return (T)((Builder)this.getThis());
        }

        @Override
        public MineshaftStructure build() {
            return new MineshaftStructure(this.startPool, this.structureSize, this.biomeRange, this.maxY, this.minY, this.clipOutOfBoundsPieces, this.verticalRange, this.probability);
        }
    }
}

