/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.capability.ageable;

import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.ageable.IAgeable;

public class Ageable
implements IAgeable {
    public static final int FORCED_AGE_TIME = 40;
    private static int MIN_FOOD_LEVEL_FOR_BREEDING = (Integer)SapienceConfig.COMMON.MIN_FOOD_VALUE_FOR_BREEDING.get();
    private boolean wasBorn;
    private int growingAge;
    private int forcedAge;
    private int forcedAgeTimer;
    private byte foodLevel;

    @Override
    public boolean wasBorn() {
        return this.wasBorn;
    }

    @Override
    public void setBorn(boolean wasBorn) {
        this.wasBorn = wasBorn;
    }

    @Override
    public int getGrowingAge() {
        return this.growingAge;
    }

    @Override
    public int getForcedAge() {
        return this.forcedAge;
    }

    @Override
    public int getForcedAgeTimer() {
        return this.forcedAgeTimer;
    }

    @Override
    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int growingAge;
        int originalAge = growingAge = this.getGrowingAge();
        if ((growingAge += growthSeconds * 20) > 0) {
            growingAge = 0;
        }
        int ageAmount = growingAge - originalAge;
        this.setGrowingAge(growingAge);
        if (updateForcedAge) {
            this.forcedAge += ageAmount;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    @Override
    public void addGrowth(int growth) {
        this.ageUp(growth, false);
    }

    @Override
    public void setGrowingAge(int age) {
        int i = this.growingAge;
        this.growingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.onGrowingAdult();
        }
    }

    @Override
    public void setForcedAge(int forcedAge) {
        this.forcedAge = forcedAge;
    }

    @Override
    public void setForcedAgeTimer(int forcedAgeTimer) {
        this.forcedAgeTimer = forcedAgeTimer;
    }

    @Override
    public void onGrowingAdult() {
    }

    @Override
    public byte getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public void setFoodLevel(byte foodLevel) {
        this.foodLevel = foodLevel;
    }

    @Override
    public void depleteFoodValue() {
        this.decreaseFoodLevel(MIN_FOOD_LEVEL_FOR_BREEDING);
    }

    @Override
    public boolean canBreed() {
        return this.getFoodLevel() >= MIN_FOOD_LEVEL_FOR_BREEDING && this.getGrowingAge() == 0;
    }

    @Override
    public boolean canSelfAge() {
        return this.getFoodLevel() >= MIN_FOOD_LEVEL_FOR_BREEDING && this.getGrowingAge() < 0;
    }
}

