/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.ageable.IAgeable;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinTasks.class})
public class PiglinTasksMixin {
    @Inject(at={@At(value="HEAD")}, method={"func_234468_a_"}, cancellable=true)
    private static void wasHurtBy(PiglinEntity piglin, LivingEntity attacker, CallbackInfo ci) {
        if (GeneralHelper.isOnSameTeam((LivingEntity)piglin, attacker)) {
            ci.cancel();
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;func_234459_a_(Lnet/minecraft/entity/EntityType;)Z"), method={"func_234533_t_"})
    private static boolean shouldAvoidZombified(EntityType entityType, PiglinEntity piglin) {
        Brain brain = piglin.func_213375_cj();
        LivingEntity livingentity = (LivingEntity)brain.func_218207_c(MemoryModuleType.field_234106_z_).get();
        return PiglinTasksHelper.isZombified(livingentity) && GeneralHelper.isNotOnSameTeam((LivingEntity)piglin, livingentity);
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234481_b_"}, cancellable=true)
    private static void getLookTasks(CallbackInfoReturnable<FirstShuffledTask<PiglinEntity>> callbackInfoReturnable) {
        FirstShuffledTask firstShuffledTask = new FirstShuffledTask((List)PiglinTasksHelper.getInteractionTasks());
        callbackInfoReturnable.setReturnValue((Object)firstShuffledTask);
    }

    @Inject(at={@At(value="HEAD")}, method={"func_234497_c_"})
    private static void setAngerTarget(AbstractPiglinEntity piglinEntity, LivingEntity target, CallbackInfo callbackInfo) {
        if (PiglinTasksHelper.canTarget(target)) {
            piglinEntity.field_70170_p.func_72960_a((Entity)piglinEntity, (byte)16);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;func_234465_a_(Lnet/minecraft/entity/item/ItemEntity;)Lnet/minecraft/item/ItemStack;")}, method={"func_234470_a_"}, cancellable=true)
    private static void pickUpWantedItem(PiglinEntity piglinEntity, ItemEntity itemEntity, CallbackInfo callbackInfo) {
        IAgeable ageable = AgeableHelper.getAgeableCapability((Entity)piglinEntity);
        if (ageable != null && PiglinTasksHelper.isPiglinFoodItem(itemEntity.func_92059_d().func_77973_b())) {
            ItemStack extractedItemStack = PiglinTasksHelper.extractSingletonFromItemEntity(itemEntity);
            PiglinTasksHelper.removeTimeTryingToReachAdmireItem(piglinEntity);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglinEntity)piglinEntity, extractedItemStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath((AbstractPiglinEntity)piglinEntity);
            callbackInfo.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234499_c_"}, cancellable=true)
    private static void isPiglinFoodItem(Item item, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean isPiglinFoodItem = PiglinTasksHelper.isPiglinFoodItem(item);
        callbackInfoReturnable.setReturnValue((Object)isPiglinFoodItem);
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234474_a_"}, cancellable=true)
    private static void canPickUpItemStack(PiglinEntity piglinEntity, ItemStack itemStack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean hasConsumableOffhandItem = PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglinEntity)piglinEntity);
        boolean canPickUpItemStack = (Boolean)callbackInfoReturnable.getReturnValue();
        if (PiglinTasksHelper.isPiglinFoodItem(itemStack.func_77973_b())) {
            canPickUpItemStack = PiglinTasksHelper.canPickUpFoodStack(piglinEntity, itemStack);
        }
        callbackInfoReturnable.setReturnValue((Object)(canPickUpItemStack && !hasConsumableOffhandItem ? 1 : 0));
    }

    @Inject(at={@At(value="HEAD")}, method={"func_234477_a_"}, cancellable=true)
    private static void finishAdmiringItem(PiglinEntity piglinEntity, boolean doBarter, CallbackInfo callbackInfo) {
        Entity interactorEntity = ReputationHelper.getPreviousInteractor((MobEntity)piglinEntity);
        boolean willDropLoot = interactorEntity instanceof LivingEntity && ReputationHelper.isAllowedToBarter(piglinEntity, (LivingEntity)interactorEntity) || interactorEntity == null && (Boolean)SapienceConfig.COMMON.REQUIRE_LIVING_FOR_BARTER.get() == false;
        ItemStack offhandStack = piglinEntity.func_184586_b(Hand.OFF_HAND);
        boolean isIngotBarterGreedItem = PiglinTasksHelper.isNormalBarterItem(offhandStack.func_77973_b());
        if (isIngotBarterGreedItem) {
            GreedHelper.addStackToGreedInventoryCheckBartered((MobEntity)piglinEntity, offhandStack, doBarter && piglinEntity.func_242337_eM());
        }
        if (!piglinEntity.func_70631_g_()) {
            if (PiglinTasksHelper.isExpensiveBarterItem(offhandStack.func_77973_b()) && doBarter && willDropLoot) {
                PiglinTasksHelper.dropBlockBarteringLoot((AbstractPiglinEntity)piglinEntity);
                CompoundNBT compoundNBT = offhandStack.func_196082_o();
                compoundNBT.func_74757_a("Bartered", true);
                ReputationHelper.updatePreviousInteractorReputation((MobEntity)piglinEntity, PiglinReputationType.BARTER);
            } else if (PiglinTasksHelper.isCheapBarterItem(offhandStack.func_77973_b()) && doBarter && willDropLoot) {
                PiglinTasksHelper.dropNuggetBarteringLoot((AbstractPiglinEntity)piglinEntity);
                CompoundNBT compoundNBT = offhandStack.func_196082_o();
                compoundNBT.func_74757_a("Bartered", true);
                ReputationHelper.updatePreviousInteractorReputation((MobEntity)piglinEntity, PiglinReputationType.BARTER);
            } else if (PiglinTasksHelper.isPiglinLoved(offhandStack.func_77973_b()) && !PiglinTasksHelper.isBarterItem(offhandStack.func_77973_b())) {
                ReputationHelper.updatePreviousInteractorReputation((MobEntity)piglinEntity, PiglinReputationType.GOLD_GIFT);
            }
        } else if (PiglinTasksHelper.isPiglinLoved(offhandStack.func_77973_b()) || PiglinTasksHelper.isBarterItem(offhandStack.func_77973_b())) {
            ReputationHelper.updatePreviousInteractorReputation((MobEntity)piglinEntity, PiglinReputationType.GOLD_GIFT);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;func_234475_a_(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Ljava/util/List;)V", ordinal=0)}, method={"func_234477_a_"}, cancellable=true)
    private static void dropLoot(PiglinEntity piglinEntity, boolean doBarter, CallbackInfo callbackInfo) {
        boolean willDropLoot;
        Entity interactorEntity = ReputationHelper.getPreviousInteractor((MobEntity)piglinEntity);
        if (doBarter) {
            ReputationHelper.updatePreviousInteractorReputation((MobEntity)piglinEntity, PiglinReputationType.BARTER);
        }
        boolean bl = willDropLoot = interactorEntity instanceof LivingEntity && ReputationHelper.isAllowedToBarter(piglinEntity, (LivingEntity)interactorEntity) || interactorEntity == null && (Boolean)SapienceConfig.COMMON.REQUIRE_LIVING_FOR_BARTER.get() == false;
        if (!willDropLoot) {
            callbackInfo.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234489_b_"}, cancellable=true)
    private static void canAcceptItemStack(PiglinEntity piglinEntity, ItemStack itemStack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)((Boolean)callbackInfoReturnable.getReturnValue() != false && !PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglinEntity)piglinEntity) ? 1 : 0));
    }

    @ModifyVariable(at=@At(value="STORE"), method={"func_234478_a_"})
    private static List<PiglinEntity> getPiglinsAngryAtThief(List<PiglinEntity> nearbyPiglinsList, PlayerEntity playerEntity, boolean checkVisible) {
        List<PiglinEntity> filteredNearbyPiglinsList = nearbyPiglinsList.stream().filter(PiglinTasksHelper::hasIdle).filter(nearbyPiglin -> !checkVisible || BrainUtil.func_233876_c_((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity)).filter(nearbyPiglin -> !ReputationHelper.isAllowedToTouchGold(playerEntity, nearbyPiglin)).collect(Collectors.toList());
        filteredNearbyPiglinsList.forEach(nearbyPiglin -> ReputationHelper.updatePiglinReputation((AbstractPiglinEntity)nearbyPiglin, PiglinReputationType.GOLD_STOLEN, (Entity)playerEntity));
        return filteredNearbyPiglinsList;
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234471_a_"})
    private static void processInteractionForPiglinCurrency(PiglinEntity piglinEntity, PlayerEntity playerEntity, Hand hand, CallbackInfoReturnable<ActionResultType> callbackInfoReturnable) {
        if (((ActionResultType)callbackInfoReturnable.getReturnValue()).func_226246_a_()) {
            ReputationHelper.setPreviousInteractor((MobEntity)piglinEntity, (Entity)playerEntity);
        }
    }
}

