/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.reputation.IReputation;
import com.infamous.sapience.capability.reputation.ReputationProvider;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class ReputationHelper {
    private static final int ALLY_REPUTATION = (Integer)SapienceConfig.COMMON.ALLY_GOSSIP_REQUIREMENT.get();
    private static final int FRIENDLY_REPUTATION = (Integer)SapienceConfig.COMMON.FRIENDLY_GOSSIP_REQUIREMENT.get();
    private static final int NEUTRAL_REPUTATION = 0;
    private static final int UNFRIENDLY_REPUTATION = (Integer)SapienceConfig.COMMON.UNFRIENDLY_GOSSIP_REQUIREMENT.get();
    private static final int ENEMY_REPUTATION = (Integer)SapienceConfig.COMMON.ENEMY_GOSSIP_REQUIREMENT.get();

    @Nullable
    private static IReputation getReputationCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(ReputationProvider.REPUTATION_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IReputation)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the reputation capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the reputation capability from the Entity in ReputationHelper#getReputationCapability!");
        return null;
    }

    public static void updatePiglinReputation(AbstractPiglinEntity piglinEntity, IReputationType type, Entity target) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)piglinEntity);
        if (reputation != null) {
            GossipManager gossipManager = reputation.getGossipManager();
            if (type == PiglinReputationType.WITHER_KILLED) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MAJOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.WITHER_SKELETON_KILLED) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MAJOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_SKELETON_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_SKELETON_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.GOLD_GIFT) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.GOLD_GIFT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.FOOD_GIFT) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.FOOD_GIFT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BARTER) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.TRADING, ((Integer)SapienceConfig.COMMON.BARTER_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.GOLD_STOLEN) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.GOLD_STOLEN_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ADULT_PIGLIN_HURT) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_HURT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BABY_PIGLIN_HURT) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_HURT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ADULT_PIGLIN_KILLED) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BABY_PIGLIN_KILLED) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BRUTE_KILLED) {
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BRUTE_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BRUTE_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            }
        }
    }

    public static void spreadGossip(AbstractPiglinEntity host, LivingEntity ally, long gameTime) {
        IReputation hostReputation = ReputationHelper.getReputationCapability((Entity)host);
        IReputation allyReputation = ReputationHelper.getReputationCapability((Entity)ally);
        if (!(hostReputation == null || allyReputation == null || gameTime >= hostReputation.getLastGossipTime() && gameTime < hostReputation.getLastGossipTime() + 1200L || gameTime >= allyReputation.getLastGossipTime() && gameTime < allyReputation.getLastGossipTime() + 1200L)) {
            hostReputation.getGossipManager().func_220912_a(allyReputation.getGossipManager(), host.func_70681_au(), 10);
            hostReputation.setLastGossipTime(gameTime);
            allyReputation.setLastGossipTime(gameTime);
        }
    }

    public static void makeWitnessesOfMurder(LivingEntity murderedEntity, Entity murderer, IReputationType killedReputationType) {
        if (murderedEntity.field_70170_p instanceof ServerWorld) {
            AxisAlignedBB axisalignedbb = murderedEntity.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0);
            List nearbyWitnesses = murderedEntity.field_70170_p.func_175647_a(LivingEntity.class, axisalignedbb, nearbyEntity -> nearbyEntity != murderedEntity && nearbyEntity.func_70089_S() && nearbyEntity.func_70685_l((Entity)murderedEntity));
            ServerWorld serverworld = (ServerWorld)murderedEntity.field_70170_p;
            nearbyWitnesses.stream().filter(gossipTarget -> gossipTarget instanceof IReputationTracking).forEach(gossipTarget -> serverworld.func_217489_a(killedReputationType, murderer, (IReputationTracking)gossipTarget));
        }
    }

    public static void updateGossip(MobEntity mobEntity) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null && mobEntity.field_70170_p instanceof ServerWorld) {
            long gameTime = mobEntity.field_70170_p.func_82737_E();
            if (reputation.getLastGossipDecay() == 0L) {
                reputation.setLastGossipDecay(gameTime);
            } else if (gameTime >= reputation.getLastGossipDecay() + 24000L) {
                reputation.getGossipManager().func_223538_b();
                reputation.setLastGossipDecay(gameTime);
            }
        }
    }

    public static void setGossip(MobEntity mobEntity, INBT gossip) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null) {
            reputation.getGossipManager().func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gossip));
        }
    }

    private static int getEntityReputation(LivingEntity reputationEntity, LivingEntity entityToCheck) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)reputationEntity);
        if (reputation != null) {
            return reputation.getGossipManager().func_220921_a(entityToCheck.func_110124_au(), gossipType -> true);
        }
        return 0;
    }

    @Nullable
    public static Entity getPreviousInteractor(MobEntity mobEntity) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null && mobEntity.field_70170_p instanceof ServerWorld) {
            if (reputation.getPreviousInteractor() != null) {
                return ((ServerWorld)mobEntity.field_70170_p).func_217461_a(reputation.getPreviousInteractor());
            }
            return null;
        }
        return null;
    }

    public static void setPreviousInteractor(MobEntity mobEntity, @Nullable Entity interactor) {
        IReputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null) {
            if (interactor != null) {
                reputation.setPreviousInteractor(interactor.func_110124_au());
            } else {
                reputation.setPreviousInteractor(null);
            }
        }
    }

    public static void updatePreviousInteractorReputation(MobEntity mobEntity, IReputationType reputationType) {
        Entity previousInteractor = ReputationHelper.getPreviousInteractor(mobEntity);
        if (previousInteractor != null && mobEntity instanceof IReputationTracking && mobEntity.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)mobEntity.field_70170_p;
            serverWorld.func_217489_a(reputationType, previousInteractor, (IReputationTracking)mobEntity);
            ReputationHelper.setPreviousInteractor(mobEntity, null);
        }
    }

    public static boolean isAllowedToTouchGold(PlayerEntity playerEntity, PiglinEntity nearbyPiglin) {
        return ReputationHelper.getEntityReputation((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity) >= ALLY_REPUTATION || GeneralHelper.isOnSameTeam((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity);
    }

    public static boolean hasAcceptableAttire(LivingEntity livingEntity, LivingEntity sensorEntity) {
        return PiglinTasks.func_234460_a_((LivingEntity)livingEntity) && ReputationHelper.getEntityReputation(sensorEntity, livingEntity) > ENEMY_REPUTATION || ReputationHelper.getEntityReputation(sensorEntity, livingEntity) >= FRIENDLY_REPUTATION;
    }

    public static boolean isAllowedToBarter(PiglinEntity piglinEntity, LivingEntity interactorEntity) {
        return ReputationHelper.getEntityReputation((LivingEntity)piglinEntity, interactorEntity) > UNFRIENDLY_REPUTATION;
    }
}

