/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.client.model.quads.NoTintBakedQuadRetextured;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OneWayGlassModel
extends SecretBlockModel {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static BakedModel glassModel;

    public OneWayGlassModel(BakedModel model) {
        super(model);
    }

    @Override
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{super.getRenderTypes(state, rand, data), ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()})});
    }

    @Override
    protected List<BakedQuad> render(@NotNull BlockState mirrorState, @NotNull BlockState baseState, @NotNull BakedModel model, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        Function<RenderType, List<BakedQuad>> superQuads = type -> this.getQuadsForSide(mirrorState, baseState, side, rand, extraData, (RenderType)type);
        return this.getQuadsNotSolid(baseState, mirrorState, model, superQuads, rand, extraData, renderType);
    }

    private List<BakedQuad> getQuadsNotSolid(BlockState baseState, BlockState delegate, BakedModel delegateModel, Function<RenderType, List<BakedQuad>> superQuads, RandomSource rand, ModelData extraData, RenderType layer) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layer == null || layer == RenderType.m_110463_()) {
            quads.addAll(this.getGlassQuadsNotSolid(baseState, superQuads, extraData));
        }
        if (layer == null || delegateModel.getRenderTypes(delegate, rand, extraData).contains(layer)) {
            quads.addAll(this.getDelegateQuadsNotSolid(baseState, () -> (List)superQuads.apply(layer)));
        }
        return quads;
    }

    private List<BakedQuad> getGlassQuadsNotSolid(BlockState baseState, Function<RenderType, List<BakedQuad>> superQuads, ModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : this.gatherAllQuads(superQuads)) {
            if (!((Boolean)baseState.m_61143_((Property)PipeBlock.f_55154_.get(bakedQuad.m_111306_()))).booleanValue()) continue;
            quads.add(new NoTintBakedQuadRetextured(bakedQuad, glassModel.getParticleIcon(extraData)));
        }
        return quads;
    }

    private List<BakedQuad> getDelegateQuadsNotSolid(BlockState baseState, Supplier<List<BakedQuad>> superQuads) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : superQuads.get()) {
            if (((Boolean)baseState.m_61143_((Property)PipeBlock.f_55154_.get(bakedQuad.m_111306_()))).booleanValue()) continue;
            quads.add(bakedQuad);
        }
        return quads;
    }

    private List<BakedQuad> getQuadsForSide(BlockState mirrorState, BlockState baseState, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        List<BakedQuad> quads = super.render(mirrorState, baseState, MC.m_91289_().m_110910_(mirrorState), side, rand, extraData, renderType);
        super.render(mirrorState, baseState, MC.m_91289_().m_110910_(mirrorState), null, rand, extraData, renderType).stream().filter(q -> q.m_111306_() == side).forEach(quads::add);
        return quads;
    }

    @SubscribeEvent
    public static void onModelsReady(ModelEvent.BakingCompleted event) {
        glassModel = event.getModelManager().m_119422_(BlockModelShaper.m_110895_((BlockState)Blocks.f_50058_.m_49966_()));
    }
}

