/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.mojang.datafixers.util.Pair;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.client.model.quads.TrueVisionBakedQuad;
import com.wynprice.secretrooms.server.items.TrueVisionGogglesClientHandler;
import com.wynprice.secretrooms.server.utils.ModelDataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class SecretBlockModel
implements BakedModel {
    private static final Supplier<BlockRenderDispatcher> DISPATCHER = () -> Minecraft.m_91087_().m_91289_();
    private final BakedModel model;

    public SecretBlockModel(BakedModel model) {
        this.model = model;
    }

    public Optional<Pair<BlockState, BakedModel>> getModel(ModelData data) {
        return ModelDataUtils.getData(data, SecretModelData.SRM_BLOCKSTATE).map(s -> Pair.of((Object)s, (Object)DISPATCHER.get().m_110910_(s)));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        Optional<Pair<BlockState, BakedModel>> data = this.getModel(extraData);
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        BlockState mirrorState = (BlockState)data.get().getFirst();
        BakedModel mirrorModel = (BakedModel)data.get().getSecond();
        Function<RenderType, List<BakedQuad>> quads = type -> this.render(mirrorState, state, mirrorModel, side, rand, extraData, (RenderType)type);
        if (this.trueVision() && renderType == RenderType.m_110466_()) {
            List quadList = quads.apply(renderType);
            this.getHelmetQuads(this.gatherAllQuads(quads), quadList);
            return quadList;
        }
        return quads.apply(renderType);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        Optional<Pair<BlockState, BakedModel>> optional = this.getModel(data);
        if (optional.isEmpty()) {
            return ChunkRenderTypeSet.none();
        }
        BlockState mirrorState = (BlockState)optional.get().getFirst();
        BakedModel mirrorModel = (BakedModel)optional.get().getSecond();
        ChunkRenderTypeSet mirrorSet = mirrorModel.getRenderTypes(mirrorState, rand, data);
        if (this.trueVision()) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{mirrorSet, ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()})});
        }
        return mirrorSet;
    }

    private void getHelmetQuads(List<BakedQuad> allQuads, List<BakedQuad> quads) {
        for (BakedQuad quad : allQuads) {
            quads.add(TrueVisionBakedQuad.generateQuad(quad));
        }
    }

    private boolean trueVision() {
        return TrueVisionGogglesClientHandler.isWearingGoggles((Player)Minecraft.m_91087_().f_91074_);
    }

    protected List<BakedQuad> gatherAllQuads(Function<RenderType, List<BakedQuad>> superQuads) {
        return new ArrayList<BakedQuad>((Collection)superQuads.apply(null));
    }

    protected List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @NotNull BakedModel model, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        return new ArrayList<BakedQuad>(model.getQuads(mirrorState, side, rand, extraData, renderType));
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.trueVision() ? this.model.getParticleIcon(data) : ModelDataUtils.getData(data, SecretModelData.SRM_BLOCKSTATE).map(arg_0 -> ((BlockRenderDispatcher)DISPATCHER.get()).m_110910_(arg_0)).orElse(this.model).getParticleIcon(data);
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData data = this.model.getModelData(world, pos, state, tileData);
        ModelData.Builder builder = data.derive();
        if (data != tileData && !tileData.getProperties().isEmpty()) {
            if (tileData.has(SecretModelData.SRM_BLOCKSTATE) && !data.has(SecretModelData.SRM_BLOCKSTATE)) {
                builder.with(SecretModelData.SRM_BLOCKSTATE, (Object)((BlockState)tileData.get(SecretModelData.SRM_BLOCKSTATE)));
            }
            if (tileData.has(SecretModelData.MODEL_MAP_STATE) && !data.has(SecretModelData.MODEL_MAP_STATE)) {
                builder.with(SecretModelData.MODEL_MAP_STATE, (Object)((BlockState)tileData.get(SecretModelData.MODEL_MAP_STATE)));
            }
        }
        return builder.build();
    }

    public boolean m_7539_() {
        return this.model.m_7539_();
    }

    public boolean m_7547_() {
        return this.trueVision() && this.model.m_7547_();
    }

    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        return this.model.m_213637_(state, side, rand);
    }

    public ItemTransforms m_7442_() {
        return this.model.m_7442_();
    }

    public boolean m_7541_() {
        return this.model.m_7541_();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.model.useAmbientOcclusion(state);
    }

    public TextureAtlasSprite m_6160_() {
        return this.model.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.model.m_7343_();
    }

    public boolean m_7521_() {
        return false;
    }
}

