/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.google.common.math.DoubleMath;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.server.utils.ModelDataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecretMappedModel
extends SecretBlockModel {
    private final Map<BlockState, AABB> stateAreaCache = new HashMap<BlockState, AABB>();
    private static final Supplier<BlockRenderDispatcher> DISPATCHER = () -> Minecraft.m_91087_().m_91289_();

    public SecretMappedModel(BakedModel model) {
        super(model);
    }

    @Override
    protected List<BakedQuad> render(@NotNull BlockState mirrorState, @NotNull BlockState baseState, @NotNull BakedModel model, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        Optional<BlockState> blockState = ModelDataUtils.getData(extraData, SecretModelData.MODEL_MAP_STATE);
        if (!blockState.isPresent()) {
            return super.render(mirrorState, baseState, model, side, rand, extraData, renderType);
        }
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        BlockState mappedState = blockState.get();
        BakedModel mappedModel = DISPATCHER.get().m_110910_(mappedState);
        AABB bb = this.createQuadBorder(mappedModel, mappedState, rand, extraData);
        ArrayList allQuads = new ArrayList(model.getQuads(mirrorState, null, rand, extraData, null));
        for (Direction value : Direction.values()) {
            allQuads.addAll(model.getQuads(mirrorState, value, rand, extraData, null));
        }
        for (BakedQuad quad : allQuads) {
            outQuads.add(this.resizeQuad(quad, bb));
        }
        return outQuads;
    }

    private BakedQuad resizeQuad(BakedQuad texture, AABB modelRange) {
        List<Vec3> vertices = this.getVertexPositions(texture);
        List<Vec3> clamped = this.clampVertexPositions(modelRange, vertices);
        int size = DefaultVertexFormat.f_85811_.m_86017_();
        int[] aint = new int[texture.m_111303_().length];
        System.arraycopy(texture.m_111303_(), 0, aint, 0, aint.length);
        for (int v = 0; v < clamped.size(); ++v) {
            Vec3 vec = clamped.get(v);
            aint[v * size] = Float.floatToIntBits((float)vec.f_82479_);
            aint[v * size + 1] = Float.floatToIntBits((float)vec.f_82480_);
            aint[v * size + 2] = Float.floatToIntBits((float)vec.f_82481_);
        }
        this.resetUVPositions(aint, size, 4, vertices, clamped);
        return new BakedQuad(aint, texture.m_111305_(), texture.m_111306_(), texture.m_173410_(), texture.m_111307_());
    }

    private void resetUVPositions(int[] aint, int size, int uOff, List<Vec3> vertices, List<Vec3> clampedVertices) {
        boolean uvRot = aint[uOff] == aint[size + uOff];
        int[] t = new int[]{1, 0, 3, 2};
        int[] a = new int[]{3, 2, 1, 0};
        int[] mappedU = uvRot ? a : t;
        int[] mappedV = uvRot ? t : a;
        for (int v = 0; v < 4; ++v) {
            if (vertices.get(v).equals((Object)clampedVertices.get(v))) continue;
            Vec3 clamped = clampedVertices.get(v);
            Vec3 from = vertices.get(v);
            Vec3 toU = vertices.get(mappedU[v]);
            Vec3 toV = vertices.get(mappedV[v]);
            Direction.Axis uAxis = this.getDifferential(from, toU);
            Direction.Axis vAxis = this.getDifferential(from, toV);
            double uInterpolated = this.dist(clamped, from, uAxis) / this.dist(toU, from, uAxis);
            double vInterpolated = this.dist(clamped, from, vAxis) / this.dist(toV, from, vAxis);
            aint[v * size + uOff] = Float.floatToIntBits((float)this.interpolate(Float.intBitsToFloat(aint[v * size + uOff]), Float.intBitsToFloat(aint[mappedU[v] * size + uOff]), uInterpolated));
            aint[v * size + uOff + 1] = Float.floatToIntBits((float)this.interpolate(Float.intBitsToFloat(aint[v * size + uOff + 1]), Float.intBitsToFloat(aint[mappedV[v] * size + uOff + 1]), vInterpolated));
        }
    }

    private Direction.Axis getDifferential(Vec3 v1, Vec3 v2) {
        if (!DoubleMath.fuzzyEquals((double)v1.f_82479_, (double)v2.f_82479_, (double)1.0E-7)) {
            return Direction.Axis.X;
        }
        if (!DoubleMath.fuzzyEquals((double)v1.f_82480_, (double)v2.f_82480_, (double)1.0E-7)) {
            return Direction.Axis.Y;
        }
        if (!DoubleMath.fuzzyEquals((double)v1.f_82481_, (double)v2.f_82481_, (double)1.0E-7)) {
            return Direction.Axis.Z;
        }
        return null;
    }

    private double interpolate(double from, double to, double alpha) {
        return from + (to - from) * alpha;
    }

    private double dist(Vec3 v1, Vec3 v2, Direction.Axis axis) {
        if (axis == null) {
            return 1.0;
        }
        switch (axis) {
            case X: {
                return Math.abs(v1.f_82479_ - v2.f_82479_);
            }
            case Y: {
                return Math.abs(v1.f_82480_ - v2.f_82480_);
            }
            case Z: {
                return Math.abs(v1.f_82481_ - v2.f_82481_);
            }
        }
        return 1.0;
    }

    private List<Vec3> clampVertexPositions(AABB modelQuadRange, List<Vec3> vertices) {
        ArrayList<Vec3> out = new ArrayList<Vec3>();
        for (Vec3 vertex : vertices) {
            out.add(new Vec3(Mth.m_14008_((double)vertex.f_82479_, (double)modelQuadRange.f_82288_, (double)modelQuadRange.f_82291_), Mth.m_14008_((double)vertex.f_82480_, (double)modelQuadRange.f_82289_, (double)modelQuadRange.f_82292_), Mth.m_14008_((double)vertex.f_82481_, (double)modelQuadRange.f_82290_, (double)modelQuadRange.f_82293_)));
        }
        return out;
    }

    private List<Vec3> getVertexPositions(BakedQuad quad) {
        int size = DefaultVertexFormat.f_85811_.m_86017_();
        int[] aint = quad.m_111303_();
        ArrayList<Vec3> out = new ArrayList<Vec3>();
        for (int v = 0; v < 4; ++v) {
            out.add(new Vec3((double)Float.intBitsToFloat(aint[v * size]), (double)Float.intBitsToFloat(aint[v * size + 1]), (double)Float.intBitsToFloat(aint[v * size + 2])));
        }
        return out;
    }

    private AABB createQuadBorder(BakedModel mappedModel, BlockState state, RandomSource rand, ModelData extraData) {
        if (this.stateAreaCache.containsKey(state)) {
            return this.stateAreaCache.get(state);
        }
        ArrayList modelQuads = new ArrayList(mappedModel.getQuads(state, null, rand, extraData, null));
        for (Direction direction : Direction.values()) {
            modelQuads.addAll(mappedModel.getQuads(state, direction, rand, extraData, null));
        }
        Vec3 min = new Vec3(2.147483647E9, 2.147483647E9, 2.147483647E9);
        Vec3 max = new Vec3(-2.147483648E9, -2.147483648E9, -2.147483648E9);
        for (BakedQuad quad : modelQuads) {
            for (Vec3 vertexPos : this.getVertexPositions(quad)) {
                this.setVec(min, vertexPos, Math::min);
                this.setVec(max, vertexPos, Math::max);
            }
        }
        AABB bb = new AABB(min.f_82479_, min.f_82480_, min.f_82481_, max.f_82479_, max.f_82480_, max.f_82481_);
        this.stateAreaCache.put(state, bb);
        return bb;
    }

    private void setVec(Vec3 toSet, Vec3 vertex, BiFunction<Double, Double, Double> cons) {
        toSet.f_82479_ = cons.apply(toSet.f_82479_, vertex.f_82479_);
        toSet.f_82480_ = cons.apply(toSet.f_82480_, vertex.f_82480_);
        toSet.f_82481_ = cons.apply(toSet.f_82481_, vertex.f_82481_);
    }
}

