/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.wynprice.secretrooms.client.world.DelegateWorld;
import com.wynprice.secretrooms.client.world.DummyIWorld;
import com.wynprice.secretrooms.server.blocks.states.SecretBaseState;
import com.wynprice.secretrooms.server.data.SecretData;
import com.wynprice.secretrooms.server.tileentity.SecretTileEntity;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.extensions.IForgeBlockState;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class SecretBaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    private final StateDefinition<Block, BlockState> stateContainerOverride;
    private int calls = 0;

    public SecretBaseBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60988_());
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateContainerOverride = builder.m_61101_(Block::m_49966_, this::createNewState);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected BlockState createNewState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
        return new SecretBaseState(block, propertiesToValueMap, codec);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        boolean fluid;
        boolean value = SecretBaseBlock.getValue((BlockGetter)worldIn, pos, (m, reader, p) -> m.m_60734_() instanceof SimpleWaterloggedBlock && ((SimpleWaterloggedBlock)m.m_60734_()).m_6044_(reader, pos, m, fluidStateIn.m_76152_()), () -> false);
        if (value && (fluid = super.m_7361_(worldIn, pos, state, fluidStateIn))) {
            SecretBaseBlock.getMirrorData((BlockGetter)worldIn, pos).ifPresent(d -> {
                BlockState mirror = d.getBlockState();
                if (mirror.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    d.setBlockState((BlockState)mirror.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                }
            });
            return super.m_7361_(worldIn, pos, state, fluidStateIn);
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        ItemStack itemStack = super.m_142598_(worldIn, pos, state);
        if (!itemStack.m_41619_()) {
            SecretBaseBlock.getMirrorData((BlockGetter)worldIn, pos).ifPresent(d -> {
                BlockState mirror = d.getBlockState();
                if (mirror.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    d.setBlockState((BlockState)mirror.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                }
            });
        }
        return itemStack;
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateContainerOverride;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        SecretBaseBlock.getMirrorData((BlockGetter)worldIn, currentPos).ifPresent(data -> {
            BlockState newState;
            BlockState mirror = data.getBlockState();
            DummyIWorld world = new DummyIWorld(worldIn);
            if (!(facingState.m_60734_() instanceof SecretBaseBlock) && this.calls != 3) {
                ++this.calls;
                BlockState facingNewState = facingState.m_60728_(facing.m_122424_(), mirror, (LevelAccessor)world, facingPos, currentPos);
                --this.calls;
                Block.m_49902_((BlockState)facingState, (BlockState)facingNewState, (LevelAccessor)worldIn, (BlockPos)facingPos, (int)3);
            }
            if ((newState = mirror.m_60728_(facing, world.m_8055_(facingPos), (LevelAccessor)world, currentPos, facingPos)) != mirror) {
                data.setBlockState(newState);
                BlockEntity tileEntity = world.m_7702_(currentPos);
                data.setTileEntityNBT(tileEntity != null ? tileEntity.serializeNBT() : null);
            }
        });
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        SecretBaseBlock.getMirrorState((BlockGetter)worldIn, pos).ifPresent(mirror -> mirror.m_60701_((LevelAccessor)new DummyIWorld((LevelAccessor)worldIn), pos, 3));
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @javax.annotation.Nullable Entity entity) {
        return SecretBaseBlock.getValue((BlockGetter)world, pos, (mirror, reader, pos1) -> mirror.getSoundType(world, pos1, entity), () -> super.getSoundType(state, world, pos, entity));
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return SecretBaseBlock.getValue(level, pos, (mirror, reader, pos1) -> mirror.getBlockPathType(reader, pos1, mob), () -> super.getBlockPathType(state, level, pos, mob));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return SecretBaseBlock.getValue(world, pos, (mirror, reader, pos1) -> mirror.m_60647_(reader, pos, type), () -> super.m_7357_(state, world, pos, type));
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return SecretBaseBlock.getValue(world, pos, (mirror, reader, pos1) -> Float.valueOf(mirror.m_60792_(reader, pos)), () -> Float.valueOf(super.m_7749_(state, world, pos))).floatValue();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SecretBaseBlock.getValue(worldIn, pos, (mirror, reader, pos1) -> mirror.m_60651_(reader, pos1, context), () -> super.m_5940_(state, worldIn, pos, context));
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SecretBaseBlock.getValue(worldIn, pos, BlockBehaviour.BlockStateBase::m_60816_, () -> super.m_7947_(state, worldIn, pos));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SecretBaseBlock.getValue(worldIn, pos, (mirror, reader, pos1) -> mirror.m_60742_(reader, pos1, context), () -> super.m_5939_(state, worldIn, pos, context));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SecretBaseBlock.getValue(worldIn, pos, BlockBehaviour.BlockStateBase::m_60768_, () -> super.m_7952_(state, worldIn, pos));
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SecretBaseBlock.getValue(reader, pos, (m, w, p) -> m.m_60771_(w, p, context), () -> super.m_5909_(state, reader, pos, context));
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SecretBaseBlock.getValue(worldIn, pos, BlockBehaviour.BlockStateBase::m_60820_, () -> super.m_6079_(state, worldIn, pos));
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, @javax.annotation.Nullable Entity entity) {
        return SecretBaseBlock.getValue((BlockGetter)world, pos, (m, w, p) -> Float.valueOf(m.getFriction(world, p, entity)), () -> Float.valueOf(super.getFriction(state, world, pos, entity))).floatValue();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        Boolean isAoModel;
        Optional<BlockState> mirrorState;
        int result = SecretBaseBlock.getValue(world, pos, IForgeBlockState::getLightEmission, () -> super.getLightEmission(state, world, pos));
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        if ("net.minecraft.client.renderer.block.ModelBlockRenderer".equals(element.getClassName()) && (mirrorState = SecretBaseBlock.getMirrorState(world, pos)).isPresent() && (isAoModel = (Boolean)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91289_().m_110910_((BlockState)mirrorState.get()).m_7541_())) != null) {
            return result == 0 && isAoModel != false ? 0 : 1;
        }
        return result;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return SecretBaseBlock.getValue(world, pos, BlockBehaviour.BlockStateBase::m_60739_, () -> super.m_7753_(state, world, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return SecretBaseBlock.getValue(world, pos, BlockBehaviour.BlockStateBase::m_60631_, () -> super.m_7420_(state, world, pos));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, BlockStateProperties.f_61362_});
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState blockstate;
        Optional<BlockState> mirrorState = SecretBaseBlock.getMirrorState((BlockGetter)world, pos);
        if (mirrorState.isPresent() && (blockstate = mirrorState.get()).m_60799_() != RenderShape.INVISIBLE) {
            Vec3 vec3d = entity.m_20184_();
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), entity.m_20185_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + 0.1, entity.m_20189_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_(), vec3d.f_82479_ * -4.0, 1.5, vec3d.f_82481_ * -4.0);
        }
        return true;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                BlockPos pos;
                Optional<BlockState> mirrorState;
                if (target instanceof BlockHitResult && (mirrorState = SecretBaseBlock.getMirrorState((BlockGetter)level, pos = ((BlockHitResult)target).m_82425_())).isPresent()) {
                    BlockState blockstate = mirrorState.get();
                    Direction side = ((BlockHitResult)target).m_82434_();
                    if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                        int x = pos.m_123341_();
                        int y = pos.m_123342_();
                        int z = pos.m_123343_();
                        AABB axisalignedbb = blockstate.m_60808_((BlockGetter)level, pos).m_83215_();
                        double xPos = (double)x + level.f_46441_.m_188500_() * (axisalignedbb.f_82291_ - axisalignedbb.f_82288_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82288_;
                        double yPos = (double)y + level.f_46441_.m_188500_() * (axisalignedbb.f_82292_ - axisalignedbb.f_82289_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82289_;
                        double zPos = (double)z + level.f_46441_.m_188500_() * (axisalignedbb.f_82293_ - axisalignedbb.f_82290_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82290_;
                        switch (side) {
                            case UP: {
                                yPos = (double)y + axisalignedbb.f_82292_ + (double)0.1f;
                                break;
                            }
                            case DOWN: {
                                yPos = (double)y + axisalignedbb.f_82289_ - (double)0.1f;
                                break;
                            }
                            case NORTH: {
                                zPos = (double)z + axisalignedbb.f_82290_ - (double)0.1f;
                                break;
                            }
                            case SOUTH: {
                                zPos = (double)z + axisalignedbb.f_82293_ + (double)0.1f;
                                break;
                            }
                            case WEST: {
                                xPos = (double)x + axisalignedbb.f_82288_ - (double)0.1f;
                                break;
                            }
                            case EAST: {
                                xPos = (double)x + axisalignedbb.f_82291_ + (double)0.1f;
                            }
                        }
                        Minecraft.m_91087_().f_91061_.m_107344_(new TerrainParticle((ClientLevel)level, xPos, yPos, zPos, 0.0, 0.0, 0.0, blockstate, pos).m_107268_(0.2f).m_6569_(0.6f));
                    }
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                Optional<BlockState> mirrorState = SecretBaseBlock.getMirrorState((BlockGetter)level, pos);
                if (mirrorState.isPresent()) {
                    if (mirrorState.get().m_60795_()) {
                        return false;
                    }
                    BlockState blockstate = mirrorState.get();
                    VoxelShape voxelshape = blockstate.m_60808_((BlockGetter)level, pos);
                    voxelshape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                        double xDelta = Math.min(1.0, x2 - x1);
                        double yDelta = Math.min(1.0, y2 - y1);
                        double zDelta = Math.min(1.0, z2 - z1);
                        int xAmount = Math.max(2, Mth.m_14165_((double)(xDelta / 0.25)));
                        int yAmount = Math.max(2, Mth.m_14165_((double)(yDelta / 0.25)));
                        int zAmount = Math.max(2, Mth.m_14165_((double)(zDelta / 0.25)));
                        for (int x = 0; x < xAmount; ++x) {
                            for (int y = 0; y < yAmount; ++y) {
                                for (int z = 0; z < zAmount; ++z) {
                                    double dx = ((double)x + 0.5) / (double)xAmount;
                                    double dy = ((double)y + 0.5) / (double)yAmount;
                                    double dz = ((double)z + 0.5) / (double)zAmount;
                                    double xPos = dx * xDelta + x1;
                                    double yPos = dy * yDelta + y1;
                                    double zPos = dz * zDelta + z1;
                                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)new TerrainParticle((ClientLevel)level, (double)pos.m_123341_() + xPos, (double)pos.m_123342_() + yPos, (double)pos.m_123343_() + zPos, dx - 0.5, dy - 0.5, dz - 0.5, blockstate, pos));
                                }
                            }
                        }
                    });
                }
                return true;
            }
        });
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        SecretBaseBlock.getMirrorState((BlockGetter)worldserver, pos).ifPresent(blockState -> worldserver.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f));
        return true;
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SecretTileEntity(pos, state);
    }

    public void applyExtraModelData(BlockGetter world, BlockPos pos, BlockState state, ModelData.Builder builder) {
    }

    public Boolean getSolidValue() {
        return null;
    }

    public BlockState getPlaceState(BlockGetter wold, BlockPos placedOnPos, BlockState placedOn, BlockState fallback) {
        boolean waterlogged = placedOn.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)placedOn.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        return (BlockState)((BlockState)fallback.m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(placedOn.m_60815_()))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged));
    }

    public static <T> T getValue(BlockGetter world, BlockPos pos, StateFunction<T> function, Supplier<T> defaultValue) {
        return (T)SecretBaseBlock.getMirrorState(world, pos).map(DelegateWorld.createFunction(world, (reader, mirror) -> function.getValue((BlockState)mirror, (BlockGetter)reader, pos))).orElseGet(defaultValue);
    }

    public static Optional<BlockState> getMirrorState(BlockGetter world, BlockPos pos) {
        return SecretBaseBlock.getMirrorData(world, pos).map(SecretData::getBlockState);
    }

    public static Optional<SecretData> getMirrorData(BlockGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        BlockState blockState = null;
        if (world instanceof Level) {
            LevelChunk chunk = ((Level)world).m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            if (chunk != null) {
                blockState = chunk.m_8055_(pos);
            }
        } else {
            blockState = world.m_8055_(pos);
        }
        BlockEntity te = world.m_7702_(pos);
        return blockState != null && blockState.m_60734_() instanceof SecretBaseBlock && te instanceof SecretTileEntity ? Optional.of(((SecretTileEntity)te).getData()) : Optional.empty();
    }

    public static void requestModelRefresh(BlockGetter world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            tileEntity.requestModelDataUpdate();
        }
    }

    public static interface StateFunction<T> {
        public T getValue(BlockState var1, BlockGetter var2, BlockPos var3);
    }
}

