/*
 * Decompiled with CFR 0.152.
 */
package smelly.seekercompass;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageS2CParticle {
    public String particleName;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;

    public MessageS2CParticle(String particleName, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this.particleName = particleName;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_180714_a(this.particleName);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public static MessageS2CParticle deserialize(PacketBuffer buf) {
        String particleName = buf.func_218666_n();
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double motionX = buf.readDouble();
        double motionY = buf.readDouble();
        double motionZ = buf.readDouble();
        return new MessageS2CParticle(particleName, posX, posY, posZ, motionX, motionY, motionZ);
    }

    public static boolean handle(MessageS2CParticle message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
                BasicParticleType particleType = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(message.particleName));
                if (particleType != null) {
                    world.func_195594_a((IParticleData)particleType, message.posX, message.posY, message.posZ, message.motionX, message.motionY, message.motionZ);
                }
            });
        }
        return true;
    }
}

