/*
 * Decompiled with CFR 0.152.
 */
package smelly.seekercompass;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import smelly.seekercompass.MessageS2CParticle;
import smelly.seekercompass.SeekerCompass;
import smelly.seekercompass.SeekerCompassItem;

@Mod.EventBusSubscriber(modid="seeker_compass")
public class SCEvents {
    private static final String TAG_SPAWNED = "seeker_compass:pigman_spawned";
    public static final String TAG_POS = "seeker_compass:teleport_pos";
    public static final String TAG_CHUNK_UPDATE = "seeker_compass:chunk_update";
    public static final String TAG_CHUNK_TIMER = "seeker_compass:chunk_timer";
    public static final String TAG_PREV_CHUNK = "seeker_compass:prev_chunk";

    @SubscribeEvent
    public static void trackEntity(PlayerInteractEvent.EntityInteract event) {
        Hand hand;
        ItemStack itemstack;
        LivingEntity livingEntity;
        if (event.getWorld().field_72995_K || event.getTarget() == null) {
            return;
        }
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).func_70089_S() && (itemstack = player.func_184586_b(hand = event.getHand())).func_77973_b() == SeekerCompass.SEEKER_COMPASS.get() && SeekerCompassItem.isNotBroken(itemstack)) {
            Entity entity;
            if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("TrackingEntity") && (entity = ((ServerWorld)world).func_217461_a(NBTUtil.func_186860_b((CompoundNBT)itemstack.func_77978_p().func_74775_l("TrackingEntity")))) == target) {
                itemstack.func_77978_p().func_82580_o("TrackingEntity");
                itemstack.func_77978_p().func_82580_o("EntityStatus");
                itemstack.func_77978_p().func_82580_o("Rotations");
                player.field_70170_p.func_184133_a(null, target.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.75f, 1.5f);
                Random rand = player.func_70681_au();
                for (int i = 0; i < 8; ++i) {
                    Vec3d targetPosition = target.func_213303_ch();
                    Vec3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)target.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                    Vec3d motion = targetPosition.func_178788_d(position.func_72441_c(0.0, (double)(target.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                    SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", targetPosition.func_82615_a(), targetPosition.func_82617_b(), targetPosition.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
                }
                return;
            }
            itemstack.func_196082_o().func_218657_a("TrackingEntity", (INBT)NBTUtil.func_186862_a((UUID)target.func_110124_au()));
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemstack.func_77973_b()));
            player.func_184609_a(hand);
            player.field_70170_p.func_184133_a(null, target.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.75f, 0.25f);
            Random rand = player.func_70681_au();
            for (int i = 0; i < 8; ++i) {
                Vec3d targetPosition = target.func_213303_ch();
                Vec3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)target.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                Vec3d motion = position.func_178788_d(targetPosition.func_72441_c(0.0, (double)(target.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinWorldEvent event) {
        CompoundNBT nbt;
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.func_200600_R() == EntityType.field_200785_Y && !(nbt = entity.getPersistentData()).func_74767_n(TAG_SPAWNED)) {
            ZombiePigmanEntity pigman = (ZombiePigmanEntity)entity;
            if (pigman.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b() && pigman.func_70681_au().nextFloat() < 0.02f) {
                pigman.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)SeekerCompass.SEEKER_COMPASS.get()));
                pigman.func_184642_a(EquipmentSlotType.OFFHAND, 2.0f);
            }
            nbt.func_74757_a(TAG_SPAWNED, true);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ChunkPos chunkpos = new ChunkPos(entity.func_180425_c());
        CompoundNBT tag = entity.getPersistentData();
        if (!(entity.func_130014_f_() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)entity.func_130014_f_();
        if (tag.func_74764_b(TAG_CHUNK_UPDATE) && tag.func_74767_n(TAG_CHUNK_UPDATE)) {
            long prevChunkLong;
            ChunkPos prevChunkPos;
            if (tag.func_74764_b(TAG_PREV_CHUNK) && !chunkpos.equals((Object)(prevChunkPos = new ChunkPos(ChunkPos.func_212578_a((long)(prevChunkLong = tag.func_74763_f(TAG_PREV_CHUNK))), ChunkPos.func_212579_b((long)prevChunkLong)))) && !SCEvents.isChunkForced(world, prevChunkPos)) {
                world.func_72863_F().func_217206_a(prevChunkPos, false);
            }
            if (tag.func_74764_b(TAG_CHUNK_TIMER)) {
                int timer = tag.func_74762_e(TAG_CHUNK_TIMER);
                if (timer > 0) {
                    world.func_72863_F().func_217206_a(chunkpos, true);
                    entity.getPersistentData().func_74768_a(TAG_CHUNK_TIMER, timer - 1);
                } else {
                    if (!SCEvents.isChunkForced(world, chunkpos)) {
                        world.func_72863_F().func_217206_a(chunkpos, false);
                    }
                    entity.getPersistentData().func_74757_a(TAG_CHUNK_UPDATE, false);
                }
                entity.getPersistentData().func_74772_a(TAG_PREV_CHUNK, chunkpos.func_201841_a());
            }
        }
    }

    public static boolean isChunkForced(ServerWorld world, ChunkPos pos) {
        ChunkPos spawnChunk = new ChunkPos(new BlockPos(world.func_72912_H().func_76079_c(), 0, world.func_72912_H().func_76074_e()));
        Stream spawnChunks = ChunkPos.func_222243_a((ChunkPos)spawnChunk, (int)11);
        LongIterator longIterator = world.func_217469_z().iterator();
        while (longIterator.hasNext()) {
            long values = (Long)longIterator.next();
            if (!pos.equals((Object)new ChunkPos(ChunkPos.func_212578_a((long)values), ChunkPos.func_212579_b((long)values)))) continue;
            return true;
        }
        return spawnChunks.anyMatch(chunk -> chunk.equals((Object)pos));
    }
}

