/*
 * Decompiled with CFR 0.152.
 */
package smelly.seekercompass;

import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import smelly.seekercompass.MessageS2CParticle;
import smelly.seekercompass.SCEvents;
import smelly.seekercompass.SCTags;
import smelly.seekercompass.SeekerCompass;
import smelly.seekercompass.advancements.SCCriteriaTriggers;
import smelly.seekercompass.enchants.SCEnchants;

public class SeekerCompassItem
extends Item {
    public SeekerCompassItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity livingEntity) {
                LivingEntity entity;
                if (!SeekerCompassItem.isNotBroken(stack)) {
                    return 0.0f;
                }
                if (livingEntity == null && !stack.func_82839_y()) {
                    return 0.484375f;
                }
                boolean flag = livingEntity != null;
                Object object = entity = flag ? livingEntity : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Rotations") && stack.func_77978_p().func_74764_b("EntityStatus") && !stack.func_82839_y()) {
                    return (float)SeekerCompassItem.positiveModulo(SeekerCompassItem.getRotationData(stack).rotation, 1.0);
                }
                double randRotation = Math.random();
                if (flag) {
                    randRotation = this.wobble(world, randRotation);
                }
                return (float)SeekerCompassItem.positiveModulo((float)randRotation, 1.0);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World world, double rotation) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = rotation - this.rotation;
                    d0 = SeekerCompassItem.positiveModulo(d0 + 0.5, 1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = SeekerCompassItem.positiveModulo(this.rotation + this.rota, 1.0);
                }
                return this.rotation;
            }
        });
        this.func_185043_a(new ResourceLocation("broken"), (stack, world, entity) -> SeekerCompassItem.isNotBroken(stack) ? 0.0f : 1.0f);
    }

    public static double positiveModulo(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static boolean isNotBroken(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    private Entity getEntity(ServerWorld world, ItemStack stack) {
        return world.func_217461_a(NBTUtil.func_186860_b((CompoundNBT)((CompoundNBT)stack.func_77978_p().func_74781_a("TrackingEntity"))));
    }

    private static EntityStatusData getEntityStatus(ItemStack stack) {
        return EntityStatusData.read((CompoundNBT)stack.func_77978_p().func_74781_a("EntityStatus"));
    }

    private static RotationData getRotationData(ItemStack stack) {
        return RotationData.read(stack.func_77978_p().func_74775_l("Rotations"));
    }

    private static VoodooData getVoodooData(ItemStack stack) {
        return VoodooData.read(stack.func_77978_p().func_74775_l("VoodooInfo"));
    }

    public boolean hasVoodooCooldown(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("VoodooInfo") ? SeekerCompassItem.getVoodooData((ItemStack)stack).timer > 0 : false;
    }

    private double getAngleToTrackedEntity(ItemStack stack, Entity entity) {
        EntityStatusData data = EntityStatusData.read((CompoundNBT)stack.func_77978_p().func_74781_a("EntityStatus"));
        BlockPos pos = data.pos;
        return Math.atan2((double)pos.func_177952_p() - entity.func_226281_cx_(), (double)pos.func_177958_n() - entity.func_226277_ct_());
    }

    private Pair<Long, double[]> wobble(World world, double angle, long lastUpdateTickIn, double rotationIn, double rotaIn) {
        long lastUpdateTick = lastUpdateTickIn;
        double rotation = rotationIn;
        double rota = rotaIn;
        if (world.func_82737_E() != lastUpdateTick) {
            lastUpdateTick = world.func_82737_E();
            double d0 = angle - rotation;
            d0 = SeekerCompassItem.positiveModulo(d0 + 0.5, 1.0) - 0.5;
            rota += d0 * 0.1;
            rotation = SeekerCompassItem.positiveModulo(rotation + (rota *= 0.8), 1.0);
        }
        return Pair.of((Object)lastUpdateTick, (Object)new double[]{rotation, rota});
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && SeekerCompassItem.isNotBroken(stack)) {
            CompoundNBT tag = stack.func_77978_p();
            if (world.func_82737_E() % 20L == 0L && entity instanceof PlayerEntity && tag != null && tag.func_74764_b("TrackingEntity")) {
                PlayerEntity player = (PlayerEntity)entity;
                stack.func_222118_a(1, (LivingEntity)player, living -> living.func_213334_d(player.func_184600_cs()));
            }
            if (tag != null && tag.func_74764_b("VoodooInfo")) {
                VoodooData data = SeekerCompassItem.getVoodooData(stack);
                if (data.timer > 0) {
                    tag.func_218657_a("VoodooInfo", (INBT)VoodooData.write(new VoodooData(data.timesUsed, data.timer - 1)));
                } else if (data.timesUsed >= 9) {
                    tag.func_218657_a("VoodooInfo", (INBT)VoodooData.write(new VoodooData(0, 0)));
                }
            }
            if (tag != null && tag.func_74764_b("TrackingEntity")) {
                RotationData rotations;
                Entity trackingEntity = this.getEntity((ServerWorld)world, stack);
                if (trackingEntity != null) {
                    tag.func_218657_a("EntityStatus", (INBT)EntityStatusData.write(trackingEntity));
                    trackingEntity.getPersistentData().func_74757_a("seeker_compass:chunk_update", true);
                    trackingEntity.getPersistentData().func_74768_a("seeker_compass:chunk_timer", 20);
                    if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.PERSISTENCE.get()), (ItemStack)stack) > 0 && trackingEntity instanceof MobEntity) {
                        ((MobEntity)trackingEntity).func_110163_bv();
                    }
                } else if (tag.func_74764_b("EntityStatus")) {
                    EntityStatusData data = EntityStatusData.read((CompoundNBT)tag.func_74781_a("EntityStatus"));
                    ChunkPos chunkpos = new ChunkPos(data.pos);
                    if (!SCEvents.isChunkForced((ServerWorld)world, chunkpos)) {
                        world.func_72863_F().func_217206_a(chunkpos, false);
                    }
                    tag.func_218657_a("EntityStatus", (INBT)EntityStatusData.writeMissingEntity(data));
                }
                if (tag.func_74764_b("Rotations")) {
                    double turn;
                    rotations = RotationData.read(tag.func_74775_l("Rotations"));
                    if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("EntityStatus") && SeekerCompassItem.getEntityStatus(stack).canTrackEntity(entity.field_71093_bK)) {
                        double yaw = entity.field_70177_z;
                        yaw = SeekerCompassItem.positiveModulo(yaw / 360.0, 1.0);
                        double angle = this.getAngleToTrackedEntity(stack, entity) / 6.2831854820251465;
                        turn = 0.5 - (yaw - 0.25 - angle);
                    } else {
                        turn = Math.random();
                    }
                    Pair<Long, double[]> rotationData = this.wobble(world, turn, rotations.lastUpdateTick, rotations.rotation, rotations.rota);
                    rotations = new RotationData(((double[])rotationData.getSecond())[0], ((double[])rotationData.getSecond())[1], (Long)rotationData.getFirst());
                    tag.func_218657_a("Rotations", (INBT)RotationData.write(rotations));
                } else {
                    double turn;
                    rotations = new RotationData(0.0, 0.0, 0L);
                    if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("EntityStatus") && SeekerCompassItem.getEntityStatus(stack).canTrackEntity(entity.field_71093_bK)) {
                        double yaw = entity.field_70177_z;
                        yaw = SeekerCompassItem.positiveModulo(yaw / 360.0, 1.0);
                        double angle = this.getAngleToTrackedEntity(stack, entity) / 6.2831854820251465;
                        turn = 0.5 - (yaw - 0.25 - angle);
                    } else {
                        turn = Math.random();
                    }
                    Pair<Long, double[]> rotationData = this.wobble(world, turn, rotations.lastUpdateTick, rotations.rotation, rotations.rota);
                    rotations = new RotationData(((double[])rotationData.getSecond())[0], ((double[])rotationData.getSecond())[1], (Long)rotationData.getFirst());
                    tag.func_218657_a("Rotations", (INBT)RotationData.write(rotations));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (SeekerCompassItem.isNotBroken(stack) && tag != null && tag.func_74764_b("TrackingEntity") && tag.func_74764_b("EntityStatus")) {
            EntityStatusData status = EntityStatusData.read(tag.func_74775_l("EntityStatus"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.tracking_entity", new Object[0]));
            tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.entity_type", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)status.entityType, (Object[])new Object[0]))));
            tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.entity_name", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(status.entityName)));
            boolean alive = status.isAlive;
            TextFormatting color = alive ? TextFormatting.GREEN : TextFormatting.RED;
            String aliveString = String.valueOf(alive);
            aliveString = aliveString.substring(0, 1).toUpperCase() + aliveString.substring(1).toLowerCase();
            tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.alive", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a(new StringTextComponent(aliveString).func_211708_a(color)));
            tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.health", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a(new StringTextComponent(String.valueOf(status.health)).func_211708_a(TextFormatting.GREEN)));
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.TRACKING.get()), (ItemStack)stack) > 0) {
                tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.blockpos", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(status.pos.func_229422_x_())));
                tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.standing_on", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)world.func_180495_p(status.pos.func_177977_b()).func_177230_c().func_149739_a(), (Object[])new Object[0]))));
                tooltip.add(new TranslationTextComponent("tooltip.seeker_compass.biome", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)world.func_226691_t_(status.pos).func_210773_k(), (Object[])new Object[0]))));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (SeekerCompassItem.isNotBroken(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("TrackingEntity") && player.func_225608_bj_()) {
            Vec3d pos;
            Entity entity;
            int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.VOODOO.get()), (ItemStack)stack);
            if (level > 0 && !SeekerCompassItem.getTargetEntity((Entity)player, 8).isPresent()) {
                Entity entity2;
                if (this.hasVoodooCooldown(stack) && !player.func_184812_l_()) {
                    if (!world.field_72995_K) {
                        player.func_145747_a(new TranslationTextComponent("message.seeker_compass.voodoo_cooldown", new Object[0]).func_150257_a(new StringTextComponent(String.valueOf(SeekerCompassItem.getVoodooData((ItemStack)stack).timer)).func_211708_a(TextFormatting.GOLD)));
                    }
                    return ActionResult.func_226251_d_((Object)stack);
                }
                if (world instanceof ServerWorld && (entity2 = this.getEntity((ServerWorld)world, stack)) != null && entity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player).func_76348_h().func_82726_p(), 1.5f + (float)level)) {
                    SCCriteriaTriggers.VOODOO_MAGIC.trigger((ServerPlayerEntity)player);
                    Random rand = player.func_70681_au();
                    for (int i = 0; i < 8; ++i) {
                        Vec3d targetPosition = entity2.func_213303_ch();
                        Vec3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)entity2.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                        Vec3d motion = position.func_178788_d(targetPosition.func_72441_c(0.0, (double)(entity2.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                        SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
                    }
                    if (!player.func_184812_l_()) {
                        int damage = MathHelper.func_76125_a((int)(stack.func_77952_i() + 400), (int)0, (int)(stack.func_77958_k() - 1));
                        stack.func_196085_b(damage);
                        if (damage == stack.func_77958_k() - 1) {
                            player.func_213823_a(SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.5f, 1.5f);
                        }
                        VoodooData data = SeekerCompassItem.getVoodooData(stack);
                        int newTimesUsed = data.timesUsed + 1;
                        if (newTimesUsed >= 9) {
                            stack.func_77978_p().func_218657_a("VoodooInfo", (INBT)VoodooData.write(new VoodooData(9, 12000)));
                        } else {
                            stack.func_77978_p().func_218657_a("VoodooInfo", (INBT)VoodooData.write(new VoodooData(newTimesUsed, 0)));
                        }
                    }
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.WARPING.get()), (ItemStack)stack) > 0 && !SeekerCompassItem.getTargetEntity((Entity)player, 8).isPresent() && world instanceof ServerWorld && (entity = this.getEntity((ServerWorld)world, stack)) != null && player.func_213373_a((pos = entity.func_213303_ch()).func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), false)) {
                player.field_70143_R = 0.0f;
                world.func_184148_a(null, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), SoundEvents.field_187791_eX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                pos = player.func_213303_ch();
                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_warp", pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 0.0, 0.0, 0.0));
                stack.func_190918_g(1);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos placingPos = context.func_195995_a().func_177984_a();
        if (SeekerCompassItem.isNotBroken(stack) && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.SUMMONING.get()), (ItemStack)stack) > 0 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("TrackingEntity") && player.func_225608_bj_()) {
            Entity trackedEntity;
            if (world instanceof ServerWorld && ((trackedEntity = this.getEntity((ServerWorld)world, stack)) instanceof TameableEntity || SCTags.EntityTags.SUMMONABLES.func_199685_a_((Object)trackedEntity.func_200600_R())) && ((LivingEntity)trackedEntity).func_213373_a((double)placingPos.func_177958_n(), (double)placingPos.func_177956_o(), (double)placingPos.func_177952_p(), false)) {
                world.func_184148_a(null, (double)placingPos.func_177958_n(), (double)placingPos.func_177956_o(), (double)placingPos.func_177952_p(), SoundEvents.field_187791_eX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_warp", placingPos.func_177958_n(), placingPos.func_177956_o(), placingPos.func_177952_p(), 0.0, 0.0, 0.0));
                if (!player.func_184812_l_()) {
                    int damage = MathHelper.func_76125_a((int)(stack.func_77952_i() + 300), (int)0, (int)(stack.func_77958_k() - 1));
                    stack.func_196085_b(damage);
                    if (damage == stack.func_77958_k() - 1) {
                        player.func_213823_a(SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (!stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b("TrackingEntity")) {
            boolean creative = player.func_184812_l_();
            if (world.func_180495_p(placingPos.func_177977_b()).func_177230_c() == Blocks.field_150343_Z && (player.field_71068_ca >= 10 || creative)) {
                if (!creative) {
                    player.field_71068_ca -= 10;
                }
                world.func_184148_a(null, (double)placingPos.func_177958_n(), (double)placingPos.func_177956_o(), (double)placingPos.func_177952_p(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.75f, 1.0f);
                if (world instanceof ServerWorld) {
                    SCCriteriaTriggers.JOHN_CENA.trigger((ServerPlayerEntity)player);
                    for (ServerPlayerEntity players : ((ServerWorld)world).func_217369_A()) {
                        for (int i = 0; i < players.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack itemstack = players.field_71071_by.func_70301_a(i);
                            if (itemstack.func_190926_b() || itemstack.func_77973_b() != this || !itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b("TrackingEntity") || player != this.getEntity((ServerWorld)world, itemstack) || this.getEntity((ServerWorld)world, itemstack) == null) continue;
                            itemstack.func_77978_p().func_82580_o("TrackingEntity");
                            itemstack.func_77978_p().func_82580_o("EntityStatus");
                            itemstack.func_77978_p().func_82580_o("Rotations");
                            Random rand = player.func_70681_au();
                            for (int i2 = 0; i2 < 8; ++i2) {
                                Vec3d targetPosition = players.func_213303_ch();
                                Vec3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)players.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                                Vec3d motion = targetPosition.func_178788_d(position.func_72441_c(0.0, (double)(players.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", targetPosition.func_82615_a(), targetPosition.func_82617_b(), targetPosition.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
                            }
                            player.field_70170_p.func_184133_a(null, players.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.75f, 1.5f);
                        }
                    }
                }
                stack.func_190918_g(1);
            }
        }
        if (!stack.func_77942_o() && player.func_110124_au().equals(UUID.fromString("b8b859a5-2dbc-4743-8f7a-4768f6692606")) && world.func_180495_p(placingPos.func_177977_b()).func_177230_c() == Blocks.field_150357_h) {
            player.field_71068_ca += 50;
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantedBookItem.func_92115_a((ItemStack)book, (EnchantmentData)new EnchantmentData(Enchantments.field_185309_u, 5));
            if (!player.func_191521_c(book)) {
                player.func_71019_a(book, false);
                player.func_71019_a(new ItemStack((IItemProvider)Items.field_151166_bC, 64), false);
            }
        }
        return super.func_195939_a(context);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151064_bs;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1200;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        Color color = new Color(16743936);
        return color.getRGB();
    }

    public static Optional<Entity> getTargetEntity(@Nullable Entity entityIn, int distance) {
        int i;
        Predicate<Entity> predicate;
        AxisAlignedBB axisalignedbb;
        Vec3d vec3d1;
        Vec3d vec3d2;
        if (entityIn == null) {
            return Optional.empty();
        }
        Vec3d vec3d = entityIn.func_174824_e(1.0f);
        EntityRayTraceResult entityraytraceresult = SeekerCompassItem.rayTraceEntities(entityIn, vec3d, vec3d2 = vec3d.func_178787_e(vec3d1 = entityIn.func_70676_i(1.0f).func_186678_a((double)distance)), axisalignedbb = entityIn.func_174813_aQ().func_216361_a(vec3d1).func_186662_g(1.0), predicate = p_217727_0_ -> !p_217727_0_.func_175149_v() && p_217727_0_.func_70067_L(), i = distance * distance);
        if (entityraytraceresult == null) {
            return Optional.empty();
        }
        return vec3d.func_72436_e(entityraytraceresult.func_216347_e()) > (double)i ? Optional.empty() : Optional.of(entityraytraceresult.func_216348_a());
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntities(Entity p_221273_0_, Vec3d p_221273_1_, Vec3d p_221273_2_, AxisAlignedBB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        World world = p_221273_0_.field_70170_p;
        double d0 = p_221273_5_;
        Entity entity = null;
        Vec3d vec3d = null;
        for (Entity entity1 : world.func_175674_a(p_221273_0_, p_221273_3_, p_221273_4_)) {
            Vec3d vec3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(p_221273_1_, p_221273_2_);
            if (axisalignedbb.func_72318_a(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3d = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.func_72436_e(vec3d1 = (Vec3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == p_221273_0_.func_184208_bv()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3d = vec3d1;
                continue;
            }
            entity = entity1;
            vec3d = vec3d1;
            d0 = d1;
        }
        if (entity == null) {
            return null;
        }
        return new EntityRayTraceResult(entity, vec3d);
    }

    static class VoodooData {
        public final int timesUsed;
        public final int timer;

        public VoodooData(int timesUsed, int timer) {
            this.timer = timer;
            this.timesUsed = timesUsed;
        }

        public static VoodooData read(CompoundNBT compound) {
            return new VoodooData(compound.func_74762_e("TimesUsed"), compound.func_74762_e("Timer"));
        }

        public static CompoundNBT write(VoodooData data) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("TimesUsed", data.timesUsed);
            tag.func_74768_a("Timer", data.timer);
            return tag;
        }
    }

    static class RotationData {
        private final double rotation;
        private final double rota;
        private final long lastUpdateTick;

        public RotationData(double rotation, double rota, long lastUpdateTick) {
            this.rotation = rotation;
            this.rota = rota;
            this.lastUpdateTick = lastUpdateTick;
        }

        public static RotationData read(CompoundNBT compound) {
            return new RotationData(compound.func_74769_h("Rotation"), compound.func_74769_h("Rota"), compound.func_74763_f("LastUpdateTick"));
        }

        public static CompoundNBT write(RotationData data) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("Rotation", data.rotation);
            tag.func_74780_a("Rota", data.rota);
            tag.func_74772_a("LastUpdateTick", data.lastUpdateTick);
            return tag;
        }
    }

    static class EntityStatusData {
        public final boolean isAlive;
        public final float health;
        public final String entityType;
        public final String entityName;
        public final BlockPos pos;
        public final int dimensionId;

        public EntityStatusData(boolean isAlive, float health, String entityType, String entityName, BlockPos pos, int dimensionId) {
            this.isAlive = isAlive;
            this.health = health;
            this.entityType = entityType;
            this.entityName = entityName;
            this.pos = pos;
            this.dimensionId = dimensionId;
        }

        public boolean canTrackEntity(DimensionType type) {
            return DimensionType.func_186069_a((int)this.dimensionId) == type && this.isAlive;
        }

        public static EntityStatusData read(CompoundNBT compound) {
            return new EntityStatusData(compound.func_74767_n("Alive"), compound.func_74760_g("Health"), compound.func_74779_i("EntityType"), compound.func_74779_i("EntityName"), NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)compound.func_74781_a("Pos"))), compound.func_74762_e("DimensionId"));
        }

        public static CompoundNBT write(Entity trackingEntity) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Alive", trackingEntity.func_70089_S());
            tag.func_74778_a("EntityType", trackingEntity.func_200600_R().func_210760_d());
            tag.func_74778_a("EntityName", trackingEntity.func_200200_C_().getString());
            if (trackingEntity instanceof LivingEntity) {
                tag.func_74776_a("Health", ((LivingEntity)trackingEntity).func_110143_aJ());
            }
            tag.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)trackingEntity.func_180425_c()));
            tag.func_74768_a("DimensionId", trackingEntity.field_71093_bK.func_186068_a());
            return tag;
        }

        public static CompoundNBT writeMissingEntity(EntityStatusData status) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Alive", false);
            tag.func_74778_a("EntityType", status.entityType);
            tag.func_74778_a("EntityName", status.entityName);
            tag.func_74776_a("Health", 0.0f);
            tag.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)status.pos));
            tag.func_74768_a("DimensionId", status.dimensionId);
            return tag;
        }
    }
}

