/*
 * Decompiled with CFR 0.152.
 */
package net.smelly.seekercompass;

import com.google.gson.Gson;
import com.minecraftabnormals.abnormals_core.common.loot.modification.LootModifiers;
import com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers.LootPoolEntriesModifier;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.modification.ConfiguredModifier;
import com.minecraftabnormals.abnormals_core.core.util.modification.IModifier;
import com.minecraftabnormals.abnormals_core.core.util.modification.ModifierDataProvider;
import com.minecraftabnormals.abnormals_core.core.util.modification.TargetedModifier;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.smelly.seekercompass.SCConfig;
import net.smelly.seekercompass.SeekerCompassItem;
import net.smelly.seekercompass.enchants.SCEnchants;
import net.smelly.seekercompass.modification.modifiers.BiasedItemWeightModifier;
import net.smelly.seekercompass.modification.modifiers.SCLootModifiers;
import net.smelly.seekercompass.network.C2SStopStalkingMessage;
import net.smelly.seekercompass.network.S2CParticleMessage;
import net.smelly.seekercompass.network.S2CUpdateStalkedMessage;
import net.smelly.seekercompass.network.S2CUpdateStalkerMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="seeker_compass")
public class SeekerCompass {
    public static final String MOD_ID = "seeker_compass";
    public static final Logger LOGGER = LogManager.getLogger((String)"seeker_compass".toUpperCase());
    public static final String NETWORK_PROTOCOL = "SC1";
    public static SeekerCompass instance;
    public static final SimpleChannel CHANNEL;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> SEEKER_COMPASS;

    public SeekerCompass() {
        instance = this;
        CHANNEL.registerMessage(0, S2CParticleMessage.class, S2CParticleMessage::serialize, S2CParticleMessage::deserialize, S2CParticleMessage::handle);
        CHANNEL.registerMessage(1, S2CUpdateStalkerMessage.class, S2CUpdateStalkerMessage::serialize, S2CUpdateStalkerMessage::deserialize, S2CUpdateStalkerMessage::handle);
        CHANNEL.registerMessage(2, C2SStopStalkingMessage.class, C2SStopStalkingMessage::serialize, C2SStopStalkingMessage::deserialize, C2SStopStalkingMessage::handle);
        CHANNEL.registerMessage(3, S2CUpdateStalkedMessage.class, S2CUpdateStalkedMessage::serialize, S2CUpdateStalkedMessage::deserialize, S2CUpdateStalkedMessage::handle);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        SCEnchants.ENCHANTMENTS.register(modEventBus);
        SCLootModifiers.load();
        modEventBus.addListener(this::setupCommon);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(event -> {
            ForgeConfigSpec spec = event.getConfig().getSpec();
            if (spec == SCConfig.COMMON_SPEC) {
                SCConfig.COMMON.load();
            } else if (spec == SCConfig.CLIENT_SPEC) {
                SCConfig.CLIENT.load();
            }
        });
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, SCConfig.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, SCConfig.COMMON_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(EventPriority.LOWEST, this::setupClient));
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DataUtil.add((EnchantmentType[])ItemGroup.field_78040_i.func_111225_m(), (EnchantmentType)SCEnchants.SEEKER_COMPASS));
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a(SeekerCompass.createLootModifierDataProvider(dataGenerator));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)SEEKER_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
                private double rotation;
                private double rota;
                private long lastUpdateTick;

                @OnlyIn(value=Dist.CLIENT)
                public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
                    CompoundNBT tag;
                    LivingEntity entity;
                    if (!SeekerCompassItem.isNotBroken(stack)) {
                        return 0.0f;
                    }
                    if (livingEntity == null && !stack.func_82839_y()) {
                        return 0.484375f;
                    }
                    boolean flag = livingEntity != null;
                    Object object = entity = flag ? livingEntity : stack.func_82836_z();
                    if (world == null) {
                        world = (ClientWorld)entity.field_70170_p;
                    }
                    if ((tag = stack.func_77978_p()) != null && tag.func_74764_b("Rotations") && tag.func_74764_b("EntityStatus") && !stack.func_82839_y()) {
                        return (float)SeekerCompassItem.positiveModulo(SeekerCompassItem.RotationData.read((CompoundNBT)tag.func_74775_l((String)"Rotations")).rotation, 1.0);
                    }
                    double randRotation = Math.random();
                    if (flag) {
                        randRotation = this.wobble(world, randRotation);
                    }
                    return (float)SeekerCompassItem.positiveModulo((float)randRotation, 1.0);
                }

                @OnlyIn(value=Dist.CLIENT)
                private double wobble(ClientWorld world, double rotation) {
                    if (world.func_82737_E() != this.lastUpdateTick) {
                        this.lastUpdateTick = world.func_82737_E();
                        double d0 = rotation - this.rotation;
                        d0 = SeekerCompassItem.positiveModulo(d0 + 0.5, 1.0) - 0.5;
                        this.rota += d0 * 0.1;
                        this.rota *= 0.8;
                        this.rotation = SeekerCompassItem.positiveModulo(this.rotation + this.rota, 1.0);
                    }
                    return this.rotation;
                }
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)SEEKER_COMPASS.get()), (ResourceLocation)new ResourceLocation("broken"), (stack, world, entity) -> SeekerCompassItem.isNotBroken(stack) ? 0.0f : 1.0f);
        });
    }

    private static ModifierDataProvider<LootTableLoadEvent, Gson, Pair<Gson, LootPredicateManager>> createLootModifierDataProvider(DataGenerator dataGenerator) {
        return LootModifiers.createDataProvider((DataGenerator)dataGenerator, (String)"Seeker Compass Loot Modifiers", (String)MOD_ID, (ModifierDataProvider.ProviderEntry[])new ModifierDataProvider.ProviderEntry[]{new ModifierDataProvider.ProviderEntry(new TargetedModifier(new ResourceLocation("gameplay/fishing/treasure"), Arrays.asList(new ConfiguredModifier((IModifier)LootModifiers.ENTRIES_MODIFIER, (Object)new LootPoolEntriesModifier.Config(false, 0, Collections.singletonList(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)SEEKER_COMPASS.get())).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)new RandomValueRange(0.0f))).func_216081_b()))), new ConfiguredModifier((IModifier)SCLootModifiers.BIASED_ITEM_WEIGHT_MODIFIER, (Object)new BiasedItemWeightModifier.Config(0, 1, (Supplier<Item>)SEEKER_COMPASS))))), new ModifierDataProvider.ProviderEntry(new TargetedModifier(new ResourceLocation("chests/nether_bridge"), Collections.singletonList(new ConfiguredModifier((IModifier)LootModifiers.ENTRIES_MODIFIER, (Object)new LootPoolEntriesModifier.Config(false, 0, Collections.singletonList(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)SEEKER_COMPASS.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_216081_b()))))))});
    }

    static {
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "net")).networkProtocolVersion(() -> NETWORK_PROTOCOL).clientAcceptedVersions(NETWORK_PROTOCOL::equals).serverAcceptedVersions(NETWORK_PROTOCOL::equals).simpleChannel();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        SEEKER_COMPASS = ITEMS.register(MOD_ID, () -> new SeekerCompassItem(new Item.Properties().func_200917_a(1).func_200918_c(1200).func_208103_a(Rarity.UNCOMMON).func_200916_a(ItemGroup.field_78040_i)));
    }
}

