/*
 * Decompiled with CFR 0.152.
 */
package net.smelly.seekercompass;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.abnormals_core.core.events.EntityTrackingEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.smelly.seekercompass.SCConfig;
import net.smelly.seekercompass.SeekerCompass;
import net.smelly.seekercompass.interfaces.ClientStalkable;
import net.smelly.seekercompass.interfaces.Stalkable;
import net.smelly.seekercompass.mixin.client.EntityRendererInvokerMixin;
import net.smelly.seekercompass.network.S2CUpdateStalkedMessage;

@Mod.EventBusSubscriber(modid="seeker_compass")
public final class StalkerEyeHandler {
    private static final ResourceLocation STALKER_EYE = new ResourceLocation("seeker_compass", "textures/entity/stalker_eye.png");

    @SubscribeEvent
    public static void onEntityTracking(EntityTrackingEvent event) {
        Stalkable stalkable;
        Entity entity;
        if (!event.isUpdating() && (entity = event.getEntity()) instanceof Stalkable && (stalkable = (Stalkable)entity).isDirty()) {
            PacketDistributor.PacketTarget packetTarget = entity instanceof ServerPlayerEntity ? PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity) : PacketDistributor.TRACKING_ENTITY.with(() -> entity);
            SeekerCompass.CHANNEL.send(packetTarget, (Object)new S2CUpdateStalkedMessage(entity.func_145782_y(), stalkable.hasStalkers()));
        }
    }

    @SubscribeEvent
    public static void onStartTrackingEntity(PlayerEvent.StartTracking event) {
        PlayerEntity player;
        Entity target = event.getTarget();
        if (target instanceof LivingEntity && (player = event.getPlayer()) instanceof ServerPlayerEntity) {
            SeekerCompass.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new S2CUpdateStalkedMessage(target.func_145782_y(), ((Stalkable)target).hasStalkers()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity;
        if (SCConfig.CLIENT.stalkingEyeProcedure.rendersAboveEntity && ((ClientStalkable)(entity = event.getEntity())).isBeingStalked()) {
            LivingRenderer livingRenderer = event.getRenderer();
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            EntityRendererManager dispatcher = livingRenderer.func_177068_d();
            float offset = ((EntityRendererInvokerMixin)livingRenderer).callShouldShowName(entity) && ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)dispatcher.func_229099_b_((Entity)entity)) ? 0.5f : 0.0f;
            matrixStack.func_227861_a_(0.0, (double)(entity.func_213302_cg() + 0.5f + offset), 0.0);
            matrixStack.func_227863_a_(dispatcher.func_229098_b_());
            matrixStack.func_227862_a_(-0.05f, -0.05f, 0.05f);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            ClientInfo.MINECRAFT.func_110434_K().func_110577_a(STALKER_EYE);
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_227888_a_(matrix4f, -3.5f, 5.0f, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, 3.5f, 5.0f, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, 3.5f, 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, -3.5f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
            matrixStack.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderStalkingEye(RenderGameOverlayEvent.Post event) {
        Entity cameraEntity;
        Minecraft minecraft;
        if (SCConfig.CLIENT.stalkingEyeProcedure.rendersInGUI && event.getType() == RenderGameOverlayEvent.ElementType.ALL && !(minecraft = Minecraft.func_71410_x()).func_147113_T() && ((cameraEntity = minecraft.func_175606_aa()) instanceof Stalkable && ((ClientStalkable)cameraEntity).isBeingStalked() || StalkerEyeHandler.isHoveringOverStalkedEntity(minecraft.field_71476_x))) {
            MatrixStack stack = event.getMatrixStack();
            stack.func_227860_a_();
            RenderSystem.enableBlend();
            minecraft.func_110434_K().func_110577_a(STALKER_EYE);
            MainWindow mainWindow = minecraft.func_228018_at_();
            int scaledWidth = mainWindow.func_198107_o();
            int scaledHeight = mainWindow.func_198087_p();
            float middle = (float)scaledWidth / 2.0f;
            int bottom = scaledHeight - ForgeIngameGui.right_height;
            int top = bottom + 10;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float left = middle - 7.0f;
            float right = middle + 7.0f;
            bufferbuilder.func_225582_a_((double)left, (double)top, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)right, (double)top, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
            stack.func_227865_b_();
            ForgeIngameGui.right_height += 11;
        }
    }

    private static boolean isHoveringOverStalkedEntity(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
            return entity instanceof ClientStalkable && ((ClientStalkable)entity).isBeingStalked();
        }
        return false;
    }
}

