/*
 * Decompiled with CFR 0.152.
 */
package net.smelly.seekercompass.mixin;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.PacketDistributor;
import net.smelly.seekercompass.SeekerCompass;
import net.smelly.seekercompass.interfaces.Stalkable;
import net.smelly.seekercompass.interfaces.Stalker;
import net.smelly.seekercompass.network.S2CUpdateStalkerMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerEntity.class})
public final class PlayerEntityMixin
implements Stalker {
    @Nullable
    private LivingEntity stalkingEntity;
    private boolean shouldBeStalking;

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tickStalking(CallbackInfo info) {
        if (this instanceof ServerPlayerEntity) {
            if (!this.shouldBeStalking() && this.isStalking()) {
                this.setStalkingEntity(null);
            }
            this.setShouldBeStalking(false);
        }
    }

    @Override
    public void setStalkingEntity(@Nullable LivingEntity stalkingEntity) {
        boolean nonNull;
        LivingEntity prevEntity = this.stalkingEntity;
        this.stalkingEntity = stalkingEntity;
        boolean bl = nonNull = stalkingEntity != null;
        if (this instanceof ServerPlayerEntity) {
            Stalkable stalkable;
            if (prevEntity instanceof Stalkable && (stalkable = (Stalkable)prevEntity).isBeingStalkedBy((PlayerEntity)this)) {
                stalkable.removeStalker((PlayerEntity)this);
            }
            if (nonNull) {
                ((Stalkable)stalkingEntity).addStalker((PlayerEntity)((ServerPlayerEntity)this));
            }
            this.setShouldBeStalking(nonNull);
            SeekerCompass.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this), (Object)new S2CUpdateStalkerMessage(stalkingEntity != null ? stalkingEntity.func_145782_y() : -1));
        }
    }

    @Override
    @Nullable
    public LivingEntity getStalkingEntity() {
        return this.stalkingEntity;
    }

    @Override
    public boolean isStalking() {
        return this.stalkingEntity != null;
    }

    @Override
    public void setShouldBeStalking(boolean canStalk) {
        this.shouldBeStalking = canStalk;
    }

    @Override
    public boolean shouldBeStalking() {
        return this.shouldBeStalking;
    }
}

