/*
 * Decompiled with CFR 0.152.
 */
package net.smelly.seekercompass.network;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.smelly.seekercompass.interfaces.Stalker;
import net.smelly.seekercompass.sound.StalkingSound;

public final class S2CUpdateStalkerMessage {
    private final int entityId;

    public S2CUpdateStalkerMessage(int entityId) {
        this.entityId = entityId;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
    }

    public static S2CUpdateStalkerMessage deserialize(PacketBuffer buf) {
        return new S2CUpdateStalkerMessage(buf.readInt());
    }

    public static boolean handle(S2CUpdateStalkerMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                ClientPlayerEntity player = ClientInfo.getClientPlayer();
                int id = message.entityId;
                Stalker stalker = (Stalker)player;
                LivingEntity prev = stalker.getStalkingEntity();
                if (id == -1) {
                    stalker.setStalkingEntity(null);
                    S2CUpdateStalkerMessage.updateClientStalking(prev, null);
                } else {
                    Entity entity = player.field_70170_p.func_73045_a(id);
                    if (entity instanceof LivingEntity) {
                        stalker.setStalkingEntity((LivingEntity)entity);
                        S2CUpdateStalkerMessage.updateClientStalking(prev, (LivingEntity)entity);
                    }
                }
            });
        }
        context.setPacketHandled(true);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateClientStalking(@Nullable LivingEntity prevEntity, @Nullable LivingEntity stalkingEntity) {
        boolean nonNull = stalkingEntity != null;
        GameSettings options = ClientInfo.MINECRAFT.field_71474_y;
        if (nonNull) {
            options.field_74319_N = true;
        } else if (options.field_74319_N) {
            options.field_74319_N = false;
        }
        if (prevEntity != stalkingEntity) {
            ClientInfo.MINECRAFT.func_147118_V().func_147682_a((ISound)new StalkingSound(nonNull));
        }
        if (nonNull || ClientInfo.MINECRAFT.func_175606_aa() == prevEntity) {
            ClientInfo.MINECRAFT.func_175607_a((Entity)stalkingEntity);
        }
    }
}

