/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.tnt.TNTUpgrade;

public class LargePlaneEntity
extends PlaneEntity {
    public boolean hasBlockUpgrade = false;

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        for (Entity entity : list) {
            if (this.f_19853_.f_46443_ || this.m_6688_() instanceof Player || entity.m_20363_((Entity)this) || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20329_((Entity)this);
        }
    }

    @Override
    public boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (!this.hasBlockUpgrade && this.m_20197_().size() < 2) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.m_41720_());
            return upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean tryToAddTNT(Player playerEntity, ItemStack itemStack) {
        if (!this.hasBlockUpgrade && this.canAddUpgrade((UpgradeType)SimplePlanesUpgrades.TNT.get()) && this.m_20197_().size() < 2) {
            this.addUpgrade(playerEntity, itemStack, new TNTUpgrade(this));
            return true;
        }
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 10.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.LARGE_PLANE_FUEL_COST.get();
    }

    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        if (passengers.size() > 1 || passengers.size() == 1 && this.hasBlockUpgrade || passenger.m_20202_() == this) {
            return false;
        }
        return !(passenger instanceof PlaneEntity);
    }

    @Override
    public void m_7332_(Entity passenger) {
        List passengers = this.m_20197_();
        super.m_7332_(passenger);
        if (passengers.indexOf(passenger) == 0) {
            passenger.m_6034_(passenger.m_20185_(), this.m_20186_() + this.m_6048_() + this.getEntityYOffset(passenger), passenger.m_20189_());
        } else {
            this.updateSecondPassenger(passenger);
        }
    }

    public void updateSecondPassenger(Entity passenger) {
        Vector3f pos = this.transformPos(this.getSecondPassengerPos(passenger));
        passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
    }

    protected Vector3f getSecondPassengerPos(Entity passenger) {
        return new Vector3f(0.0f, (float)(super.m_6048_() + this.getEntityYOffset(passenger)), -1.0f);
    }

    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).m_6162_() ? -0.1 : -0.3;
        }
        return passenger.m_6049_();
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return 1.2;
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.LARGE_PLANE_ITEM.get();
    }
}

